/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector.source;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.catalog.CatalogPartitionSpec;

@JsonSerialize(using=CompactPartitionSerializer.class)
@JsonDeserialize(using=CompactPartitionDeserializer.class)
public class CompactPartition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_NAME_RESOLVED_PARTITION_SPEC = "resolved-partition-spec";
    private static final String FIELD_NAME_FILE_ENTRIES = "file-entries";
    private final LinkedHashMap<String, String> resolvedPartitionSpec;
    private final List<String> fileEntries;

    private CompactPartition(LinkedHashMap<String, String> partitionSpec, List<String> fileEntries) {
        this.resolvedPartitionSpec = partitionSpec;
        this.fileEntries = fileEntries;
    }

    public LinkedHashMap<String, String> getResolvedPartitionSpec() {
        return this.resolvedPartitionSpec;
    }

    public List<String> getFileEntries() {
        return this.fileEntries;
    }

    public static CompactPartition of(CatalogPartitionSpec partitionSpec, List<Path> paths) {
        return new CompactPartition(new LinkedHashMap<String, String>(partitionSpec.getPartitionSpec()), paths.stream().map(Path::getPath).collect(Collectors.toList()));
    }

    public static CompactPartition of(LinkedHashMap<String, String> partitionSpec, List<String> paths) {
        return new CompactPartition(partitionSpec, paths);
    }

    public String toString() {
        return "CompactPartition{resolvedPartitionSpec=" + this.resolvedPartitionSpec + ", fileEntries=" + this.fileEntries + "}";
    }

    public static class CompactPartitionDeserializer
    extends StdDeserializer<CompactPartition> {
        private static final long serialVersionUID = 1L;
        private JsonNode root;

        public CompactPartitionDeserializer() {
            super(CompactPartition.class);
        }

        public CompactPartition deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode rootNode = this.root == null ? (JsonNode)jsonParser.readValueAsTree().get(0) : this.root;
            JsonNode partitionSpecNode = rootNode.get(CompactPartition.FIELD_NAME_RESOLVED_PARTITION_SPEC);
            LinkedHashMap<String, String> resolvedPartitionSpec = new LinkedHashMap<String, String>();
            ArrayList<String> fileEntries = new ArrayList<String>();
            Iterator mapIterator = partitionSpecNode.fields();
            while (mapIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)mapIterator.next();
                resolvedPartitionSpec.put((String)entry.getKey(), ((JsonNode)entry.getValue()).textValue());
            }
            JsonNode fileEntriesNode = rootNode.get(CompactPartition.FIELD_NAME_FILE_ENTRIES);
            for (JsonNode fileEntry : fileEntriesNode) {
                fileEntries.add(fileEntry.asText());
            }
            return CompactPartition.of(resolvedPartitionSpec, fileEntries);
        }

        public void setRoot(JsonNode root) {
            this.root = root;
        }
    }

    public static class CompactPartitionSerializer
    extends StdSerializer<CompactPartition> {
        private static final long serialVersionUID = 1L;

        public CompactPartitionSerializer() {
            super(CompactPartition.class);
        }

        public void serialize(CompactPartition compactPartition, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectFieldStart(CompactPartition.FIELD_NAME_RESOLVED_PARTITION_SPEC);
            for (Map.Entry<String, String> entry : compactPartition.getResolvedPartitionSpec().entrySet()) {
                jsonGenerator.writeStringField(entry.getKey(), entry.getValue());
            }
            jsonGenerator.writeEndObject();
            jsonGenerator.writeFieldName(CompactPartition.FIELD_NAME_FILE_ENTRIES);
            jsonGenerator.writeStartArray();
            for (String fileEntry : compactPartition.getFileEntries()) {
                jsonGenerator.writeString(fileEntry);
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
        }
    }
}

