/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector.sink;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkV2Provider;
import org.apache.flink.table.connector.sink.TestManagedSink;
import org.apache.flink.table.connector.sink.abilities.SupportsOverwrite;
import org.apache.flink.table.connector.sink.abilities.SupportsPartitioning;
import org.apache.flink.table.factories.DynamicTableFactory;

public class TestManagedTableSink
implements DynamicTableSink,
SupportsOverwrite,
SupportsPartitioning {
    private final DynamicTableFactory.Context context;
    private final Path basePath;
    private LinkedHashMap<String, String> staticPartitionSpecs = new LinkedHashMap();
    private boolean overwrite = false;

    public TestManagedTableSink(DynamicTableFactory.Context context, Path basePath) {
        this.context = context;
        this.basePath = basePath;
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        return ChangelogMode.insertOnly();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        return SinkV2Provider.of((Sink)new TestManagedSink(this.context.getObjectIdentifier(), this.basePath));
    }

    public DynamicTableSink copy() {
        TestManagedTableSink copied = new TestManagedTableSink(this.context, this.basePath);
        copied.overwrite = this.overwrite;
        copied.staticPartitionSpecs = this.staticPartitionSpecs;
        return copied;
    }

    public String asSummaryString() {
        return "TestManagedTableSink";
    }

    public void applyOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void applyStaticPartition(Map<String, String> partition) {
        List partitionKeys = this.context.getCatalogTable().getPartitionKeys();
        for (String partitionKey : partitionKeys) {
            if (!partition.containsKey(partitionKey)) continue;
            this.staticPartitionSpecs.put(partitionKey, partition.get(partitionKey));
        }
    }
}

