/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector.sink;

import java.io.IOException;
import org.apache.flink.api.connector.sink2.Committer;
import org.apache.flink.api.connector.sink2.CommitterInitContext;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.api.connector.sink2.SupportsCommitter;
import org.apache.flink.api.connector.sink2.WriterInitContext;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.connector.sink2.SupportsPreCommitTopology;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.sink.TestManagedCommittable;
import org.apache.flink.table.connector.sink.TestManagedSinkCommittableSerializer;
import org.apache.flink.table.connector.sink.TestManagedSinkCommitter;
import org.apache.flink.table.connector.sink.TestManagedSinkWriter;
import org.apache.flink.table.data.RowData;

public class TestManagedSink
implements Sink<RowData>,
SupportsCommitter<TestManagedCommittable>,
SupportsPreCommitTopology<TestManagedCommittable, TestManagedCommittable> {
    private static final long serialVersionUID = 1L;
    private final ObjectIdentifier tableIdentifier;
    private final Path basePath;

    public TestManagedSink(ObjectIdentifier tableIdentifier, Path basePath) {
        this.tableIdentifier = tableIdentifier;
        this.basePath = basePath;
    }

    public SinkWriter<RowData> createWriter(WriterInitContext context) throws IOException {
        return new TestManagedSinkWriter();
    }

    public Committer<TestManagedCommittable> createCommitter(CommitterInitContext context) throws IOException {
        return new TestManagedSinkCommitter(this.tableIdentifier, this.basePath);
    }

    public SimpleVersionedSerializer<TestManagedCommittable> getCommittableSerializer() {
        return new TestManagedSinkCommittableSerializer();
    }

    public DataStream<CommittableMessage<TestManagedCommittable>> addPreCommitTopology(DataStream<CommittableMessage<TestManagedCommittable>> committables) {
        return committables.global();
    }

    public SimpleVersionedSerializer<TestManagedCommittable> getWriteResultSerializer() {
        return new TestManagedSinkCommittableSerializer();
    }
}

