/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class UnresolvedUserDefinedType
extends LogicalType {
    @Nullable
    private final String catalog;
    @Nullable
    private final String database;
    private final String typeIdentifier;

    public UnresolvedUserDefinedType(boolean isNullable, @Nullable String catalog, @Nullable String database, String typeIdentifier) {
        super(isNullable, LogicalTypeRoot.UNRESOLVED);
        this.catalog = catalog;
        this.database = database;
        this.typeIdentifier = (String)Preconditions.checkNotNull((Object)typeIdentifier, (String)"Type identifier must not be null.");
    }

    public UnresolvedUserDefinedType(@Nullable String catalog, @Nullable String database, String typeIdentifier) {
        this(true, catalog, database, typeIdentifier);
    }

    public Optional<String> getCatalog() {
        return Optional.ofNullable(this.catalog);
    }

    public Optional<String> getDatabase() {
        return Optional.ofNullable(this.database);
    }

    public String getTypeIdentifier() {
        return this.typeIdentifier;
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new UnresolvedUserDefinedType(isNullable, this.catalog, this.database, this.typeIdentifier);
    }

    @Override
    public String asSummaryString() {
        String path = Stream.of(this.catalog, this.database, this.typeIdentifier).filter(Objects::nonNull).map(EncodingUtils::escapeIdentifier).collect(Collectors.joining("."));
        return this.withNullability(path, new Object[0]);
    }

    @Override
    public String asSerializableString() {
        throw new TableException("An unresolved user-defined type has no serializable string representation. It needs to be resolved into a proper user-defined type.");
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        throw new TableException("An unresolved user-defined type does not support any input conversion.");
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        throw new TableException("An unresolved user-defined type does not support any output conversion.");
    }

    @Override
    public Class<?> getDefaultConversion() {
        throw new TableException("An unresolved user-defined type has no default conversion.");
    }

    @Override
    public List<LogicalType> getChildren() {
        throw new TableException("An unresolved user-defined type cannot return children.");
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UnresolvedUserDefinedType that = (UnresolvedUserDefinedType)o;
        return Objects.equals(this.catalog, that.catalog) && Objects.equals(this.database, that.database) && this.typeIdentifier.equals(that.typeIdentifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.catalog, this.database, this.typeIdentifier);
    }
}

