/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;

@PublicEvolving
public final class FloatType
extends LogicalType {
    private static final String FORMAT = "FLOAT";
    private static final Set<String> NULL_OUTPUT_CONVERSION = FloatType.conversionSet(Float.class.getName());
    private static final Set<String> NOT_NULL_INPUT_OUTPUT_CONVERSION = FloatType.conversionSet(Float.class.getName(), Float.TYPE.getName());
    private static final Class<?> DEFAULT_CONVERSION = Float.class;

    public FloatType(boolean isNullable) {
        super(isNullable, LogicalTypeRoot.FLOAT);
    }

    public FloatType() {
        this(true);
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new FloatType(isNullable);
    }

    @Override
    public String asSerializableString() {
        return this.withNullability(FORMAT, new Object[0]);
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        return NOT_NULL_INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        if (this.isNullable()) {
            return NULL_OUTPUT_CONVERSION.contains(clazz.getName());
        }
        return NOT_NULL_INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public Class<?> getDefaultConversion() {
        return DEFAULT_CONVERSION;
    }

    @Override
    public List<LogicalType> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }
}

