/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.DataTypeVisitor;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public abstract class DataType
implements Serializable {
    protected final LogicalType logicalType;
    protected final Class<?> conversionClass;

    DataType(LogicalType logicalType, @Nullable Class<?> conversionClass) {
        this.logicalType = (LogicalType)Preconditions.checkNotNull((Object)logicalType, (String)"Logical type must not be null.");
        this.conversionClass = DataType.performEarlyClassValidation(logicalType, DataType.ensureConversionClass(logicalType, conversionClass));
    }

    public LogicalType getLogicalType() {
        return this.logicalType;
    }

    public Class<?> getConversionClass() {
        return this.conversionClass;
    }

    public abstract DataType notNull();

    public abstract DataType nullable();

    public abstract DataType bridgedTo(Class<?> var1);

    public abstract <R> R accept(DataTypeVisitor<R> var1);

    public String toString() {
        return this.logicalType.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataType dataType = (DataType)o;
        return this.logicalType.equals(dataType.logicalType) && this.conversionClass.equals(dataType.conversionClass);
    }

    public int hashCode() {
        return Objects.hash(this.logicalType, this.conversionClass);
    }

    private static <C> Class<C> performEarlyClassValidation(LogicalType logicalType, Class<C> candidate) {
        if (candidate != null && !logicalType.supportsInputConversion(candidate) && !logicalType.supportsOutputConversion(candidate)) {
            throw new ValidationException(String.format("Logical type '%s' does not support a conversion from or to class '%s'.", logicalType.asSummaryString(), candidate.getName()));
        }
        return candidate;
    }

    private static Class<?> ensureConversionClass(LogicalType logicalType, @Nullable Class<?> clazz) {
        if (clazz == null) {
            return logicalType.getDefaultConversion();
        }
        return clazz;
    }
}

