/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class ArrayType
extends LogicalType {
    private static final String FORMAT = "ARRAY<%s>";
    private static final Set<String> INPUT_OUTPUT_CONVERSION = ArrayType.conversionSet("org.apache.flink.table.dataformat.BinaryArray");
    private final LogicalType elementType;

    public ArrayType(boolean isNullable, LogicalType elementType) {
        super(isNullable, LogicalTypeRoot.ARRAY);
        this.elementType = (LogicalType)Preconditions.checkNotNull((Object)elementType, (String)"Element type must not be null.");
    }

    public ArrayType(LogicalType elementType) {
        this(true, elementType);
    }

    public LogicalType getElementType() {
        return this.elementType;
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new ArrayType(isNullable, this.elementType.copy());
    }

    @Override
    public String asSummaryString() {
        return this.withNullability(FORMAT, this.elementType.asSummaryString());
    }

    @Override
    public String asSerializableString() {
        return this.withNullability(FORMAT, this.elementType.asSerializableString());
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        if (INPUT_OUTPUT_CONVERSION.contains(clazz.getName())) {
            return true;
        }
        if (!clazz.isArray()) {
            return false;
        }
        return this.elementType.supportsInputConversion(clazz.getComponentType());
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        if (INPUT_OUTPUT_CONVERSION.contains(clazz.getName())) {
            return true;
        }
        if (!clazz.isArray()) {
            return false;
        }
        return this.elementType.supportsOutputConversion(clazz.getComponentType());
    }

    @Override
    public Class<?> getDefaultConversion() {
        return Array.newInstance(this.elementType.getDefaultConversion(), 0).getClass();
    }

    @Override
    public List<LogicalType> getChildren() {
        return Collections.singletonList(this.elementType);
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayType arrayType = (ArrayType)o;
        return this.elementType.equals(arrayType.elementType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementType);
    }
}

