/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.util.Collector;

@PublicEvolving
public abstract class TableFunction<T>
extends UserDefinedFunction {
    protected Collector<T> collector;

    public final void setCollector(Collector<T> collector) {
        this.collector = collector;
    }

    public TypeInformation<T> getResultType() {
        return null;
    }

    public TypeInformation<?>[] getParameterTypes(Class<?>[] signature) {
        TypeInformation[] types = new TypeInformation[signature.length];
        for (int i = 0; i < signature.length; ++i) {
            try {
                types[i] = TypeExtractor.getForClass(signature[i]);
                continue;
            }
            catch (InvalidTypesException e) {
                throw new ValidationException("Parameter types of table function " + this.getClass().getCanonicalName() + " cannot be automatically determined. Please provide type information manually.");
            }
        }
        return types;
    }

    protected final void collect(T row) {
        this.collector.collect(row);
    }

    @Override
    public final FunctionKind getKind() {
        return FunctionKind.TABLE;
    }
}

