/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeGeneralization;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LogicalTypeGeneralizationTest {
    @Parameterized.Parameter
    public List<LogicalType> types;
    @Parameterized.Parameter(value=1)
    public LogicalType commonType;

    @Parameterized.Parameters(name="{index}: [Types: {0}, To: {1}]")
    public static List<Object[]> testData() {
        return Arrays.asList({Arrays.asList(new IntType(), new IntType()), new IntType()}, {Arrays.asList(new IntType(), new ArrayType((LogicalType)new IntType())), null}, {Arrays.asList(new IntType(), new VarCharType(23)), null}, {Arrays.asList(new BinaryType(), new VarCharType(23)), null}, {Arrays.asList(new IntType(false), new IntType(false)), new IntType(false)}, {Arrays.asList(new IntType(true), new BigIntType(false)), new BigIntType()}, {Arrays.asList(new NullType(), new NullType()), new NullType()}, {Arrays.asList(new NullType(), new IntType(), new IntType()), new IntType()}, {Arrays.asList(new ArrayType((LogicalType)new IntType()), new ArrayType((LogicalType)new IntType())), new ArrayType((LogicalType)new IntType())}, {Arrays.asList(new ArrayType((LogicalType)new BigIntType()), new ArrayType((LogicalType)new IntType())), new ArrayType((LogicalType)new BigIntType())}, {Arrays.asList(new MultisetType((LogicalType)new BigIntType()), new MultisetType((LogicalType)new IntType())), new MultisetType((LogicalType)new BigIntType())}, {Arrays.asList(new MapType((LogicalType)new BigIntType(), (LogicalType)new DoubleType()), new MapType((LogicalType)new IntType(), (LogicalType)new DoubleType())), new MapType((LogicalType)new BigIntType(), (LogicalType)new DoubleType())}, {Arrays.asList(RowType.of((LogicalType[])new LogicalType[]{new IntType(), new IntType(), new BigIntType()}), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType(), new IntType()})), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType(), new BigIntType()})}, {Arrays.asList(new CharType(2), new CharType(2)), new CharType(2)}, {Arrays.asList(new CharType(2), new CharType(4)), new VarCharType(4)}, {Arrays.asList(new VarCharType(2), new VarCharType(Integer.MAX_VALUE)), new VarCharType(Integer.MAX_VALUE)}, {Arrays.asList(new VarCharType(2), new CharType(5)), new VarCharType(5)}, {Arrays.asList(new CharType(5), new VarCharType(2), new VarCharType(7)), new VarCharType(7)}, {Arrays.asList(new BinaryType(2), new BinaryType(4)), new VarBinaryType(4)}, {Arrays.asList(new BinaryType(5), new VarBinaryType(2), new VarBinaryType(7)), new VarBinaryType(7)}, {Arrays.asList(new DoubleType(), new FloatType()), new DoubleType()}, {Arrays.asList(new DoubleType(), new DecimalType(2, 2)), new DoubleType()}, {Arrays.asList(new DoubleType(), new IntType()), new DoubleType()}, {Arrays.asList(new DecimalType(2, 2), new DoubleType(), new FloatType()), new DoubleType()}, {Arrays.asList(new DecimalType(2, 2), new DecimalType(5, 2), new DecimalType(7, 5)), new DecimalType(8, 5)}, {Arrays.asList(new DecimalType(2, 2), new IntType(), new BigIntType()), new DecimalType(21, 2)}, {Arrays.asList(new DateType(), new DateType(), new TimeType()), null}, {Arrays.asList(new TimeType(3), new TimeType(5), new TimeType(2)), new TimeType(5)}, {Arrays.asList(new TimestampType(3), new TimestampType(5), new TimestampType(2)), new TimestampType(5)}, {Arrays.asList(new TimestampType(3), new ZonedTimestampType(5), new LocalZonedTimestampType(2)), new ZonedTimestampType(5)}, {Arrays.asList(new TimestampType(3), new LocalZonedTimestampType(2)), new LocalZonedTimestampType(3)}, {Arrays.asList(new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY), new DateType()), new DateType()}, {Arrays.asList(new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.MONTH), new DateType()), new DateType()}, {Arrays.asList(new TimeType(), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.MINUTE)), new TimeType()}, {Arrays.asList(new IntType(), new DateType()), new DateType()}, {Arrays.asList(new TimeType(), new DecimalType()), null}, {Arrays.asList(new TimestampType(), new DecimalType()), new TimestampType()}, {Arrays.asList(new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_MINUTE), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.SECOND)), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_SECOND)}, {Arrays.asList(new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.HOUR), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.SECOND, 2, 0)), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.HOUR_TO_SECOND, 2, 6)}, {Arrays.asList(new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.MONTH), new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR)), new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR_TO_MONTH)});
    }

    @Test
    public void testCommonType() {
        Assert.assertThat((Object)LogicalTypeGeneralization.findCommonType(this.types), (Matcher)CoreMatchers.equalTo(Optional.ofNullable(this.commonType)));
    }
}

