/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.types.LogicalTypesTest;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TypeInformationAnyType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LogicalTypeCastsTest {
    @Parameterized.Parameter
    public LogicalType sourceType;
    @Parameterized.Parameter(value=1)
    public LogicalType targetType;
    @Parameterized.Parameter(value=2)
    public boolean supportsImplicit;
    @Parameterized.Parameter(value=3)
    public boolean supportsExplicit;

    @Parameterized.Parameters(name="{index}: [From: {0}, To: {1}, Implicit: {2}, Explicit: {3}]")
    public static List<Object[]> testData() {
        return Arrays.asList({new SmallIntType(), new BigIntType(), true, true}, {new SmallIntType(false), new SmallIntType(), true, true}, {new SmallIntType(), new SmallIntType(false), false, false}, {new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR), new SmallIntType(), true, true}, {new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR_TO_MONTH), new SmallIntType(), false, false}, {new IntType(), new DecimalType(5, 5), true, true}, {new FloatType(), new IntType(), false, true}, {new VarCharType(Integer.MAX_VALUE), new FloatType(), false, true}, {new FloatType(), new VarCharType(Integer.MAX_VALUE), false, true}, {new DecimalType(3, 2), new VarCharType(Integer.MAX_VALUE), false, true}, {new TypeInformationAnyType(Types.GENERIC(LogicalTypesTest.class)), new TypeInformationAnyType(Types.GENERIC(LogicalTypesTest.class)), true, true}, {new TypeInformationAnyType(Types.GENERIC(LogicalTypesTest.class)), new TypeInformationAnyType(Types.GENERIC(Object.class)), false, false}, {new NullType(), new IntType(), true, true}, {new ArrayType((LogicalType)new IntType()), new ArrayType((LogicalType)new BigIntType()), true, true}, {new ArrayType((LogicalType)new IntType()), new ArrayType((LogicalType)new VarCharType(Integer.MAX_VALUE)), false, true}, {new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new IntType()))), new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new BigIntType()))), true, true}, {new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType(), "description"), new RowType.RowField("f2", (LogicalType)new IntType()))), new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new BigIntType()))), true, true}, {new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new IntType()))), new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new BooleanType()))), false, false}, {new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new IntType()))), new VarCharType(Integer.MAX_VALUE), false, false});
    }

    @Test
    public void testImplicitCasting() {
        Assert.assertThat((Object)LogicalTypeCasts.supportsImplicitCast((LogicalType)this.sourceType, (LogicalType)this.targetType), (Matcher)CoreMatchers.equalTo((Object)this.supportsImplicit));
    }

    @Test
    public void testExplicitCasting() {
        Assert.assertThat((Object)LogicalTypeCasts.supportsExplicitCast((LogicalType)this.sourceType, (LogicalType)this.targetType), (Matcher)CoreMatchers.equalTo((Object)this.supportsExplicit));
    }
}

