/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.VoidSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.TypeTestingUtils;
import org.apache.flink.table.types.logical.AnyType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.TypeInformationAnyType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.table.types.utils.LogicalTypeDataTypeConverter;
import org.apache.flink.types.Row;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DataTypesTest {
    @Parameterized.Parameter
    public DataType dataType;
    @Parameterized.Parameter(value=1)
    public LogicalType expectedLogicalType;
    @Parameterized.Parameter(value=2)
    public Class<?> expectedConversionClass;

    @Parameterized.Parameters(name="{index}: {0}=[Logical: {1}, Class: {2}]")
    public static List<Object[]> dataTypes() {
        return Arrays.asList({DataTypes.CHAR((int)2), new CharType(2), String.class}, {DataTypes.VARCHAR((int)2), new VarCharType(2), String.class}, {DataTypes.STRING(), new VarCharType(Integer.MAX_VALUE), String.class}, {DataTypes.BOOLEAN(), new BooleanType(), Boolean.class}, {DataTypes.BINARY((int)42), new BinaryType(42), byte[].class}, {DataTypes.VARBINARY((int)42), new VarBinaryType(42), byte[].class}, {DataTypes.BYTES(), new VarBinaryType(Integer.MAX_VALUE), byte[].class}, {DataTypes.DECIMAL((int)10, (int)10), new DecimalType(10, 10), BigDecimal.class}, {DataTypes.TINYINT(), new TinyIntType(), Byte.class}, {DataTypes.SMALLINT(), new SmallIntType(), Short.class}, {DataTypes.INT(), new IntType(), Integer.class}, {DataTypes.BIGINT(), new BigIntType(), Long.class}, {DataTypes.FLOAT(), new FloatType(), Float.class}, {DataTypes.DOUBLE(), new DoubleType(), Double.class}, {DataTypes.DATE(), new DateType(), LocalDate.class}, {DataTypes.TIME((int)3), new TimeType(3), LocalTime.class}, {DataTypes.TIME(), new TimeType(0), LocalTime.class}, {DataTypes.TIMESTAMP((int)3), new TimestampType(3), LocalDateTime.class}, {DataTypes.TIMESTAMP(), new TimestampType(6), LocalDateTime.class}, {DataTypes.TIMESTAMP_WITH_TIME_ZONE((int)3), new ZonedTimestampType(3), OffsetDateTime.class}, {DataTypes.TIMESTAMP_WITH_TIME_ZONE(), new ZonedTimestampType(6), OffsetDateTime.class}, {DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3), new LocalZonedTimestampType(3), Instant.class}, {DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE(), new LocalZonedTimestampType(6), Instant.class}, {DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MINUTE(), (DataTypes.Resolution)DataTypes.SECOND((int)3)), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.MINUTE_TO_SECOND, 2, 3), Duration.class}, {DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()), new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.MONTH), Period.class}, {DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), new ArrayType((LogicalType)new ArrayType((LogicalType)new IntType())), Integer[][].class}, {DataTypes.MULTISET((DataType)DataTypes.MULTISET((DataType)DataTypes.INT())), new MultisetType((LogicalType)new MultisetType((LogicalType)new IntType())), Map.class}, {DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.SMALLINT()), new MapType((LogicalType)new IntType(), (LogicalType)new SmallIntType()), Map.class}, {DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"field1", (DataType)DataTypes.CHAR((int)2)), DataTypes.FIELD((String)"field2", (DataType)DataTypes.BOOLEAN())}), new RowType(Arrays.asList(new RowType.RowField("field1", (LogicalType)new CharType(2)), new RowType.RowField("field2", (LogicalType)new BooleanType()))), Row.class}, {DataTypes.NULL(), new NullType(), Object.class}, {DataTypes.ANY((TypeInformation)Types.GENERIC(DataTypesTest.class)), new TypeInformationAnyType(Types.GENERIC(DataTypesTest.class)), DataTypesTest.class}, {DataTypes.ANY(Void.class, (TypeSerializer)VoidSerializer.INSTANCE), new AnyType(Void.class, (TypeSerializer)VoidSerializer.INSTANCE), Void.class});
    }

    @Test
    public void testLogicalType() {
        Assert.assertThat((Object)this.dataType, TypeTestingUtils.hasLogicalType(this.expectedLogicalType));
    }

    @Test
    public void testConversionClass() {
        Assert.assertThat((Object)this.dataType, TypeTestingUtils.hasConversionClass(this.expectedConversionClass));
    }

    @Test
    public void testLogicalTypeToDataTypeConversion() {
        Assert.assertThat((Object)LogicalTypeDataTypeConverter.toDataType((LogicalType)this.expectedLogicalType), (Matcher)CoreMatchers.equalTo((Object)this.dataType));
    }

    @Test
    public void testDataTypeToLogicalTypeConversion() {
        Assert.assertThat((Object)LogicalTypeDataTypeConverter.toLogicalType((DataType)this.dataType), (Matcher)CoreMatchers.equalTo((Object)this.expectedLogicalType));
    }
}

