/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ExpressionTest {
    private static final ScalarFunction DUMMY_FUNCTION = new ScalarFunction(){};
    private static final Expression TREE_WITH_NULL = ExpressionTest.createExpressionTree(null);
    private static final Expression TREE_WITH_VALUE = ExpressionTest.createExpressionTree(12);
    private static final Expression TREE_WITH_SAME_VALUE = ExpressionTest.createExpressionTree(12);
    private static final String TREE_WITH_NULL_STRING = "and(true, equals(field, dummy(null)))";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testExpressionString() {
        Assert.assertEquals((Object)TREE_WITH_NULL_STRING, (Object)TREE_WITH_NULL.toString());
    }

    @Test
    public void testExpressionEquality() {
        Assert.assertEquals((Object)TREE_WITH_VALUE, (Object)TREE_WITH_SAME_VALUE);
    }

    @Test
    public void testExpressionInequality() {
        Assert.assertNotEquals((Object)TREE_WITH_NULL, (Object)TREE_WITH_VALUE);
    }

    @Test
    public void testValueLiteralString() {
        Assert.assertEquals((Object)"[null, null, [1, 2, 3]]", (Object)new ValueLiteralExpression((Object)new Integer[][]{null, null, {1, 2, 3}}).toString());
        Assert.assertEquals((Object)"[null, null, ['1', '2', '3', 'Dog''s']]", (Object)new ValueLiteralExpression((Object)new String[][]{null, null, {"1", "2", "3", "Dog's"}}, DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.STRING()))).toString());
    }

    @Test
    public void testInvalidValueLiteral() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("does not support a value literal of class 'java.lang.Integer'");
        new ValueLiteralExpression((Object)12, DataTypes.TINYINT());
    }

    @Test
    public void testInvalidValueLiteralExtraction() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Cannot derive a data type");
        new ValueLiteralExpression((Object)this);
    }

    @Test
    public void testBigDecimalValueLiteralExtraction() {
        float f = 2.4444444f;
        Assert.assertEquals((float)2.4444444f, (float)new ValueLiteralExpression((Object)Float.valueOf(2.4444444f)).getValueAs(BigDecimal.class).map(BigDecimal::floatValue).orElseThrow(AssertionError::new).floatValue(), (float)0.0f);
    }

    @Test
    public void testSqlTimestampValueLiteralExtraction() {
        Timestamp sqlTimestamp = Timestamp.valueOf("2006-11-03 00:00:00.123456789");
        LocalDateTime localDateTime = LocalDateTime.of(2006, 11, 3, 0, 0, 0, 123456789);
        Assert.assertEquals((Object)localDateTime, new ValueLiteralExpression((Object)sqlTimestamp).getValueAs(LocalDateTime.class).orElseThrow(AssertionError::new));
        Assert.assertEquals((Object)sqlTimestamp, new ValueLiteralExpression((Object)localDateTime).getValueAs(Timestamp.class).orElseThrow(AssertionError::new));
    }

    @Test
    public void testSymbolValueLiteralExtraction() {
        TimeIntervalUnit intervalUnit = TimeIntervalUnit.DAY_TO_MINUTE;
        Assert.assertEquals((Object)intervalUnit, new ValueLiteralExpression((Object)intervalUnit).getValueAs(TimeIntervalUnit.class).orElseThrow(AssertionError::new));
    }

    private static Expression createExpressionTree(Integer nestedValue) {
        return new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.AND, Arrays.asList(new ValueLiteralExpression((Object)true), new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, Arrays.asList(new FieldReferenceExpression("field", DataTypes.INT(), 0, 0), new CallExpression((FunctionDefinition)new ScalarFunctionDefinition("dummy", DUMMY_FUNCTION), Collections.singletonList(new ValueLiteralExpression((Object)nestedValue, DataTypes.INT())), DataTypes.INT())), DataTypes.BOOLEAN())), DataTypes.BOOLEAN());
    }
}

