/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.descriptors.DescriptorTestBase;
import org.apache.flink.table.descriptors.DescriptorValidator;
import org.apache.flink.table.descriptors.Statistics;
import org.apache.flink.table.descriptors.StatisticsValidator;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.junit.Test;

public class StatisticsTest
extends DescriptorTestBase {
    @Test(expected=ValidationException.class)
    public void testInvalidRowCount() {
        this.addPropertyAndVerify(this.descriptors().get(0), "statistics.row-count", "abx");
    }

    @Test(expected=ValidationException.class)
    public void testMissingName() {
        this.removePropertyAndVerify(this.descriptors().get(0), "statistics.columns.0.name");
    }

    @Override
    public List<Descriptor> descriptors() {
        Statistics desc1 = new Statistics().rowCount(1000L).columnStats("a", new ColumnStats(Long.valueOf(1L), Long.valueOf(2L), Double.valueOf(3.0), Integer.valueOf(4), (Number)6, (Number)5)).columnAvgLength("b", Double.valueOf(42.0)).columnNullCount("a", Long.valueOf(300L));
        HashMap<String, ColumnStats> map = new HashMap<String, ColumnStats>();
        map.put("a", new ColumnStats(null, Long.valueOf(2L), Double.valueOf(3.0), null, (Number)6, (Number)5));
        Statistics desc2 = new Statistics().tableStats(new TableStats(32L, map));
        return Arrays.asList(desc1, desc2);
    }

    @Override
    public DescriptorValidator validator() {
        return new StatisticsValidator();
    }

    @Override
    public List<Map<String, String>> properties() {
        HashMap<String, String> props1 = new HashMap<String, String>(){
            {
                this.put("statistics.property-version", "1");
                this.put("statistics.row-count", "1000");
                this.put("statistics.columns.0.name", "a");
                this.put("statistics.columns.0.distinct-count", "1");
                this.put("statistics.columns.0.null-count", "300");
                this.put("statistics.columns.0.avg-length", "3.0");
                this.put("statistics.columns.0.max-length", "4");
                this.put("statistics.columns.0.max-value", "6");
                this.put("statistics.columns.0.min-value", "5");
                this.put("statistics.columns.1.name", "b");
                this.put("statistics.columns.1.avg-length", "42.0");
            }
        };
        HashMap<String, String> props2 = new HashMap<String, String>(){
            {
                this.put("statistics.property-version", "1");
                this.put("statistics.row-count", "32");
                this.put("statistics.columns.0.name", "a");
                this.put("statistics.columns.0.null-count", "2");
                this.put("statistics.columns.0.avg-length", "3.0");
                this.put("statistics.columns.0.max-value", "6");
                this.put("statistics.columns.0.min-value", "5");
            }
        };
        return Arrays.asList(props1, props2);
    }
}

