/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.descriptors.DescriptorTestBase;
import org.apache.flink.table.descriptors.DescriptorValidator;
import org.apache.flink.table.descriptors.Metadata;
import org.apache.flink.table.descriptors.MetadataValidator;
import org.junit.Test;

public class MetadataTest
extends DescriptorTestBase {
    @Test(expected=ValidationException.class)
    public void testInvalidCreationTime() {
        this.addPropertyAndVerify(this.descriptors().get(0), "metadata.creation-time", "dfghj");
    }

    @Override
    public List<Descriptor> descriptors() {
        Metadata desc = new Metadata().comment("Some additional comment").creationTime(123L).lastAccessTime(12020202L);
        return Arrays.asList(desc);
    }

    @Override
    public DescriptorValidator validator() {
        return new MetadataValidator();
    }

    @Override
    public List<Map<String, String>> properties() {
        HashMap<String, String> props = new HashMap<String, String>(){
            {
                this.put("metadata.comment", "Some additional comment");
                this.put("metadata.creation-time", "123");
                this.put("metadata.last-access-time", "12020202");
            }
        };
        return Arrays.asList(props);
    }
}

