/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.DescriptorTestBase;
import org.apache.flink.table.descriptors.DescriptorValidator;
import org.apache.flink.table.descriptors.ExternalCatalogDescriptor;
import org.apache.flink.table.descriptors.ExternalCatalogDescriptorValidator;
import org.junit.Test;

public class ExternalCatalogDescriptorTest
extends DescriptorTestBase {
    private static final String CATALOG_TYPE_VALUE = "ExternalCatalogDescriptorTest";
    private static final int CATALOG_PROPERTY_VERSION_VALUE = 1;
    private static final String CATALOG_FOO = "foo";
    private static final String CATALOG_FOO_VALUE = "foo-1";

    @Test(expected=ValidationException.class)
    public void testMissingCatalogType() {
        this.removePropertyAndVerify(this.descriptors().get(0), "catalog.type");
    }

    @Test(expected=ValidationException.class)
    public void testMissingFoo() {
        this.removePropertyAndVerify(this.descriptors().get(0), CATALOG_FOO);
    }

    @Override
    protected List<Descriptor> descriptors() {
        TestExternalCatalogDescriptor minimumDesc = new TestExternalCatalogDescriptor(CATALOG_FOO_VALUE);
        return Collections.singletonList(minimumDesc);
    }

    @Override
    protected List<Map<String, String>> properties() {
        HashMap<String, String> minimumProps = new HashMap<String, String>();
        minimumProps.put("catalog.type", CATALOG_TYPE_VALUE);
        minimumProps.put("catalog.property-version", "1");
        minimumProps.put(CATALOG_FOO, CATALOG_FOO_VALUE);
        return Collections.singletonList(minimumProps);
    }

    @Override
    protected DescriptorValidator validator() {
        return new TestExternalCatalogDescriptorValidator();
    }

    private class TestExternalCatalogDescriptorValidator
    extends ExternalCatalogDescriptorValidator {
        private TestExternalCatalogDescriptorValidator() {
        }

        public void validate(DescriptorProperties properties) {
            super.validate(properties);
            properties.validateString(ExternalCatalogDescriptorTest.CATALOG_FOO, false, 1);
        }
    }

    private class TestExternalCatalogDescriptor
    extends ExternalCatalogDescriptor {
        private String foo;

        public TestExternalCatalogDescriptor(String foo) {
            super(ExternalCatalogDescriptorTest.CATALOG_TYPE_VALUE, 1);
            this.foo = foo;
        }

        protected Map<String, String> toCatalogProperties() {
            DescriptorProperties properties = new DescriptorProperties();
            if (this.foo != null) {
                properties.putString(ExternalCatalogDescriptorTest.CATALOG_FOO, this.foo);
            }
            return properties.asMap();
        }
    }
}

