/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.junit.Assert;
import org.junit.Test;

public class DescriptorPropertiesTest {
    private static final String ARRAY_KEY = "my-array";
    private static final String FIXED_INDEXED_PROPERTY_KEY = "my-fixed-indexed-property";
    private static final String PROPERTY_1_KEY = "property-1";
    private static final String PROPERTY_2_KEY = "property-2";

    @Test
    public void testEquals() {
        DescriptorProperties properties1 = new DescriptorProperties();
        properties1.putString("hello1", "12");
        properties1.putString("hello2", "13");
        properties1.putString("hello3", "14");
        DescriptorProperties properties2 = new DescriptorProperties();
        properties2.putString("hello1", "12");
        properties2.putString("hello2", "13");
        properties2.putString("hello3", "14");
        DescriptorProperties properties3 = new DescriptorProperties();
        properties3.putString("hello1", "12");
        properties3.putString("hello3", "14");
        properties3.putString("hello2", "13");
        Assert.assertEquals((Object)properties1, (Object)properties2);
        Assert.assertEquals((Object)properties1, (Object)properties3);
    }

    @Test
    public void testMissingArray() {
        DescriptorProperties properties = new DescriptorProperties();
        this.testArrayValidation(properties, 0, Integer.MAX_VALUE);
    }

    @Test
    public void testArrayValues() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString("my-array.0", "12");
        properties.putString("my-array.1", "42");
        properties.putString("my-array.2", "66");
        this.testArrayValidation(properties, 1, Integer.MAX_VALUE);
        Assert.assertEquals(Arrays.asList(12, 42, 66), (Object)properties.getArray(ARRAY_KEY, arg_0 -> ((DescriptorProperties)properties).getInt(arg_0)));
    }

    @Test
    public void testArraySingleValue() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString(ARRAY_KEY, "12");
        this.testArrayValidation(properties, 1, Integer.MAX_VALUE);
        Assert.assertEquals(Collections.singletonList(12), (Object)properties.getArray(ARRAY_KEY, arg_0 -> ((DescriptorProperties)properties).getInt(arg_0)));
    }

    @Test(expected=ValidationException.class)
    public void testArrayInvalidValues() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString("my-array.0", "12");
        properties.putString("my-array.1", "66");
        properties.putString("my-array.2", "INVALID");
        this.testArrayValidation(properties, 1, Integer.MAX_VALUE);
    }

    @Test(expected=ValidationException.class)
    public void testArrayInvalidSingleValue() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString(ARRAY_KEY, "INVALID");
        this.testArrayValidation(properties, 1, Integer.MAX_VALUE);
    }

    @Test(expected=ValidationException.class)
    public void testInvalidMissingArray() {
        DescriptorProperties properties = new DescriptorProperties();
        this.testArrayValidation(properties, 1, Integer.MAX_VALUE);
    }

    @Test(expected=ValidationException.class)
    public void testInvalidFixedIndexedProperties() {
        DescriptorProperties property = new DescriptorProperties();
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        list.add(Arrays.asList("1", "string"));
        list.add(Arrays.asList("INVALID", "string"));
        property.putIndexedFixedProperties(FIXED_INDEXED_PROPERTY_KEY, Arrays.asList(PROPERTY_1_KEY, PROPERTY_2_KEY), list);
        this.testFixedIndexedPropertiesValidation(property);
    }

    @Test
    public void testRemoveKeys() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString("hello1", "12");
        properties.putString("hello2", "13");
        properties.putString("hello3", "14");
        DescriptorProperties actual = properties.withoutKeys(Arrays.asList("hello1", "hello3"));
        DescriptorProperties expected = new DescriptorProperties();
        expected.putString("hello2", "13");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testPrefixedMap() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString("hello1", "12");
        properties.putString("hello2", "13");
        properties.putString("hello3", "14");
        Map actual = properties.asPrefixedMap("prefix.");
        DescriptorProperties expected = new DescriptorProperties();
        expected.putString("prefix.hello1", "12");
        expected.putString("prefix.hello2", "13");
        expected.putString("prefix.hello3", "14");
        Assert.assertEquals((Object)expected.asMap(), (Object)actual);
    }

    private void testArrayValidation(DescriptorProperties properties, int minLength, int maxLength) {
        Consumer<String> validator = key -> properties.validateInt(key, false);
        properties.validateArray(ARRAY_KEY, validator, minLength, maxLength);
    }

    private void testFixedIndexedPropertiesValidation(DescriptorProperties properties) {
        HashMap<String, Consumer<String>> validatorMap = new HashMap<String, Consumer<String>>();
        Consumer<String> validator1 = key -> properties.validateInt(key, false);
        validatorMap.put(PROPERTY_1_KEY, validator1);
        Consumer<String> validator2 = key -> properties.validateString(key, false);
        validatorMap.put(PROPERTY_2_KEY, validator2);
        properties.validateFixedIndexedProperties(FIXED_INDEXED_PROPERTY_KEY, false, validatorMap);
    }
}

