/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategiesTestBase;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.SpecificInputTypeStrategies;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.utils.TypeConversions;

class InputTypeStrategiesTest
extends InputTypeStrategiesTestBase {
    InputTypeStrategiesTest() {
    }

    @Override
    protected Stream<InputTypeStrategiesTestBase.TestSpec> testData() {
        return Stream.of(InputTypeStrategiesTestBase.TestSpec.forStrategy((InputTypeStrategy)InputTypeStrategies.WILDCARD).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.INT()}).expectSignature("f(*)").expectArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.INT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy((InputTypeStrategy)InputTypeStrategies.WILDCARD).calledWithArgumentTypes(new AbstractDataType[0]).expectSignature("f(*)").expectArgumentTypes(new AbstractDataType[0]), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.explicitSequence((DataType[])new DataType[]{(DataType)DataTypes.INT().bridgedTo(Integer.TYPE), DataTypes.BOOLEAN()})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.BOOLEAN()}).expectSignature("f(INT, BOOLEAN)").expectArgumentTypes(new AbstractDataType[]{DataTypes.INT().bridgedTo(Integer.TYPE), DataTypes.BOOLEAN()}), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"expected", (DataType)DataTypes.INT())})})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"actual", (DataType)DataTypes.INT())})}).expectSignature("f(ROW<`expected` INT>)").expectArgumentTypes(new AbstractDataType[]{DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"expected", (DataType)DataTypes.INT())})}), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.explicitSequence((String[])new String[]{"i", "s"}, (DataType[])new DataType[]{DataTypes.INT(), DataTypes.STRING()})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT()}).expectErrorMessage("Invalid input arguments. Expected signatures are:\nf(i INT, s STRING)"), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.explicitSequence((DataType[])new DataType[]{(DataType)DataTypes.BIGINT().notNull()})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BIGINT()}).expectErrorMessage("Unsupported argument type. Expected type 'BIGINT NOT NULL' but actual type was 'BIGINT'."), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.BIGINT()})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT()}).expectArgumentTypes(new AbstractDataType[]{DataTypes.BIGINT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.BIGINT()})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.STRING()}).expectErrorMessage("Unsupported argument type. Expected type 'BIGINT' but actual type was 'STRING'."), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.BIGINT(), DataTypes.BIGINT()})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BIGINT()}).expectErrorMessage("Invalid number of arguments. At least 2 arguments expected but 1 passed."), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.ANY})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BIGINT()}).expectSignature("f(<ANY>)").expectArgumentTypes(new AbstractDataType[]{DataTypes.BIGINT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.ANY})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BIGINT(), DataTypes.BIGINT()}).expectErrorMessage("Invalid number of arguments. At most 1 arguments expected but 2 passed."), InputTypeStrategiesTestBase.TestSpec.forStrategy("OR with bridging class", InputTypeStrategies.or((InputTypeStrategy[])new InputTypeStrategy[]{InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.STRING()}), InputTypeStrategies.explicitSequence((DataType[])new DataType[]{(DataType)DataTypes.INT().bridgedTo(Integer.TYPE)}), InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.BOOLEAN()})})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT()}).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.TINYINT()}).expectSignature("f(STRING)\nf(INT)\nf(BOOLEAN)").expectArgumentTypes(DataTypes.INT().bridgedTo(Integer.TYPE)), InputTypeStrategiesTestBase.TestSpec.forStrategy("OR with implicit casting", InputTypeStrategies.or((InputTypeStrategy[])new InputTypeStrategy[]{InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.TINYINT()}), InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.INT()}), InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.BIGINT()})})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.SMALLINT()}).expectArgumentTypes(new AbstractDataType[]{DataTypes.INT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("OR with implicit casting of null", InputTypeStrategies.or((InputTypeStrategy[])new InputTypeStrategy[]{InputTypeStrategies.explicitSequence((DataType[])new DataType[]{(DataType)DataTypes.STRING().notNull()}), InputTypeStrategies.explicitSequence((DataType[])new DataType[]{(DataType)DataTypes.INT().notNull()}), InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.BIGINT()})})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.NULL()}).expectArgumentTypes(new AbstractDataType[]{DataTypes.BIGINT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("OR with implicit casting using first match", InputTypeStrategies.or((InputTypeStrategy[])new InputTypeStrategy[]{InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.VARCHAR((int)20)}), InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.VARCHAR((int)10)})})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.VARCHAR((int)1)}).expectArgumentTypes(new AbstractDataType[]{DataTypes.VARCHAR((int)20)}), InputTypeStrategiesTestBase.TestSpec.forStrategy("OR with invalid implicit casting of null", InputTypeStrategies.or((InputTypeStrategy[])new InputTypeStrategy[]{InputTypeStrategies.explicitSequence((DataType[])new DataType[]{(DataType)DataTypes.STRING().notNull()}), InputTypeStrategies.explicitSequence((DataType[])new DataType[]{(DataType)DataTypes.INT().notNull()}), InputTypeStrategies.explicitSequence((DataType[])new DataType[]{(DataType)DataTypes.BIGINT().notNull()})})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.NULL()}).expectErrorMessage("Invalid input arguments. Expected signatures are:\nf(STRING NOT NULL)\nf(INT NOT NULL)\nf(BIGINT NOT NULL)"), InputTypeStrategiesTestBase.TestSpec.forStrategy("OR with invalid type", InputTypeStrategies.or((InputTypeStrategy[])new InputTypeStrategy[]{InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.INT()}), InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.STRING()})})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN()}).expectErrorMessage("Invalid input arguments. Expected signatures are:\nf(INT)\nf(STRING)"), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.INT(), DataTypes.BOOLEAN()})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN(), DataTypes.INT()}).expectErrorMessage("Invalid input arguments. Expected signatures are:\nf(INT, BOOLEAN)"), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.ANY, InputTypeStrategies.explicit((DataType)DataTypes.INT())})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN(), DataTypes.INT()}).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN(), DataTypes.TINYINT()}).expectArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN(), DataTypes.INT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.sequence((String[])new String[]{"any", "int"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.ANY, InputTypeStrategies.explicit((DataType)DataTypes.INT())})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.BOOLEAN()}).expectErrorMessage("Invalid input arguments. Expected signatures are:\nf(any <ANY>, int INT)"), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.or((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN()), InputTypeStrategies.explicit((DataType)DataTypes.INT())})})).expectSignature("f(INT, [BOOLEAN | INT])").calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.INT()}).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.TINYINT(), DataTypes.TINYINT()}).expectArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.INT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.or((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN()), InputTypeStrategies.explicit((DataType)DataTypes.STRING())})})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.BIGINT()}).expectErrorMessage("Invalid input arguments. Expected signatures are:\nf(INT, [BOOLEAN | STRING])"), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.LITERAL})).calledWithLiteralAt(0).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT()}).expectArgumentTypes(new AbstractDataType[]{DataTypes.INT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.and((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.LITERAL, InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), InputTypeStrategies.explicit((DataType)DataTypes.INT())})).calledWithLiteralAt(0).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.INT()}).expectSignature("f([<LITERAL NOT NULL> & STRING], INT)").expectArgumentTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.INT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.and((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.LITERAL_OR_NULL}), InputTypeStrategies.explicit((DataType)DataTypes.INT())})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.INT()}).expectErrorMessage("Invalid input arguments. Expected signatures are:\nf([STRING & <LITERAL>], INT)"), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.varyingSequence((String[])new String[]{"i", "s", "var"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN())})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.STRING(), DataTypes.BOOLEAN(), DataTypes.BOOLEAN(), DataTypes.BOOLEAN()}).expectArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.STRING(), DataTypes.BOOLEAN(), DataTypes.BOOLEAN(), DataTypes.BOOLEAN()}), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.varyingSequence((String[])new String[]{"var"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)DataTypes.BOOLEAN().bridgedTo(Boolean.TYPE)))})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN(), DataTypes.BOOLEAN(), DataTypes.BOOLEAN()}).expectSignature("f(var BOOLEAN...)").expectArgumentTypes(DataTypes.BOOLEAN().bridgedTo(Boolean.TYPE), DataTypes.BOOLEAN().bridgedTo(Boolean.TYPE), DataTypes.BOOLEAN().bridgedTo(Boolean.TYPE)), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.varyingSequence((String[])new String[]{"i", "s", "var"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN())})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.STRING()}).expectArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.STRING()}), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.varyingSequence((String[])new String[]{"i", "s", "var"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN())})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.STRING(), DataTypes.STRING()}).expectErrorMessage("Invalid input arguments. Expected signatures are:\nf(i INT, s STRING, var BOOLEAN...)"), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.varyingSequence((String[])new String[]{"i", "s", "var"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN())})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.BOOLEAN()}).expectErrorMessage("Unsupported argument type. Expected type 'STRING' but actual type was 'INT'."), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.varyingSequence((String[])new String[]{"i", "s", "var"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.or((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN()), InputTypeStrategies.explicit((DataType)DataTypes.INT())})})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.STRING(), DataTypes.INT(), DataTypes.BOOLEAN()}).expectArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.STRING(), DataTypes.INT(), DataTypes.BOOLEAN()}), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.varyingSequence((String[])new String[]{"i", "s", "var"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.or((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN()), InputTypeStrategies.explicit((DataType)DataTypes.INT())})})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}).expectErrorMessage("Invalid input arguments. Expected signatures are:\nf(i INT, s STRING, var [BOOLEAN | INT]...)"), InputTypeStrategiesTestBase.TestSpec.forStrategy((InputTypeStrategy)InputTypeStrategies.WILDCARD).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.NULL(), DataTypes.STRING(), DataTypes.NULL()}).expectSignature("f(*)").expectArgumentTypes(new AbstractDataType[]{DataTypes.NULL(), DataTypes.STRING(), DataTypes.NULL()}), InputTypeStrategiesTestBase.TestSpec.forStrategy((InputTypeStrategy)InputTypeStrategies.WILDCARD).typedArguments((DataType)DataTypes.INT().bridgedTo(Integer.TYPE), DataTypes.STRING(), DataTypes.BOOLEAN()).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.NULL(), DataTypes.STRING(), DataTypes.NULL()}).expectArgumentTypes(new AbstractDataType[]{DataTypes.INT().bridgedTo(Integer.TYPE), DataTypes.STRING(), DataTypes.BOOLEAN()}), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.OUTPUT_IF_NULL, InputTypeStrategies.OUTPUT_IF_NULL, InputTypeStrategies.OUTPUT_IF_NULL})).surroundingStrategy(InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.BOOLEAN()})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.NULL(), DataTypes.STRING(), DataTypes.NULL()}).expectSignature("f(<OUTPUT>, <OUTPUT>, <OUTPUT>)").expectArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN(), DataTypes.STRING(), DataTypes.BOOLEAN()}), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.or((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.OUTPUT_IF_NULL, InputTypeStrategies.explicit((DataType)DataTypes.INT())})})).surroundingStrategy(InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.BOOLEAN()})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.NULL()}).expectSignature("f([<OUTPUT> | INT])").expectArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN()}), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.BOOLEAN()})).surroundingStrategy((InputTypeStrategy)InputTypeStrategies.WILDCARD).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.NULL()}).expectSignature("f(BOOLEAN)").expectArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN()}), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.or((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.OUTPUT_IF_NULL, InputTypeStrategies.explicit((DataType)DataTypes.INT())})})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.NULL()}).expectSignature("f([<OUTPUT> | INT])").expectArgumentTypes(new AbstractDataType[]{DataTypes.INT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy((InputTypeStrategy)InputTypeStrategies.WILDCARD).typedArguments(DataTypes.INT(), DataTypes.STRING()).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.TINYINT(), DataTypes.STRING()}).expectSignature("f(INT, STRING)").expectArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.STRING()}), InputTypeStrategiesTestBase.TestSpec.forStrategy((InputTypeStrategy)InputTypeStrategies.WILDCARD).typedArguments(DataTypes.INT(), DataTypes.STRING()).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.STRING()}).expectErrorMessage("Invalid argument type at position 0. Data type INT expected but STRING passed."), InputTypeStrategiesTestBase.TestSpec.forStrategy((InputTypeStrategy)InputTypeStrategies.WILDCARD).namedArguments("i", "s").typedArguments(DataTypes.INT(), DataTypes.STRING()).expectSignature("f(i => INT, s => STRING)"), InputTypeStrategiesTestBase.TestSpec.forStrategy("Wildcard with count verifies arguments number", InputTypeStrategies.wildcardWithCount((ArgumentCount)ConstantArgumentCount.from((int)2))).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.STRING()}).expectErrorMessage("Invalid number of arguments. At least 2 arguments expected but 1 passed."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Array strategy infers a common type", SpecificInputTypeStrategies.ARRAY).expectSignature("f(<COMMON>, <COMMON>...)").calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT().notNull(), DataTypes.BIGINT().notNull(), DataTypes.DOUBLE(), DataTypes.DOUBLE().notNull()}).expectArgumentTypes(new AbstractDataType[]{DataTypes.DOUBLE(), DataTypes.DOUBLE(), DataTypes.DOUBLE(), DataTypes.DOUBLE()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Array strategy fails for no arguments", SpecificInputTypeStrategies.ARRAY).calledWithArgumentTypes(new AbstractDataType[0]).expectErrorMessage("Invalid number of arguments. At least 1 arguments expected but 0 passed."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Array strategy fails for null arguments", SpecificInputTypeStrategies.ARRAY).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.NULL()}).expectErrorMessage("Could not find a common type for arguments: [NULL]"), InputTypeStrategiesTestBase.TestSpec.forStrategy("Map strategy infers common types", SpecificInputTypeStrategies.MAP).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT().notNull(), DataTypes.DOUBLE(), DataTypes.BIGINT().notNull(), DataTypes.FLOAT().notNull()}).expectArgumentTypes(new AbstractDataType[]{DataTypes.BIGINT().notNull(), DataTypes.DOUBLE(), DataTypes.BIGINT().notNull(), DataTypes.DOUBLE()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Map strategy fails for no arguments", SpecificInputTypeStrategies.MAP).calledWithArgumentTypes(new AbstractDataType[0]).expectErrorMessage("Invalid number of arguments. At least 2 arguments expected but 0 passed."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Map strategy fails for an odd number of arguments", SpecificInputTypeStrategies.MAP).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BIGINT(), DataTypes.BIGINT(), DataTypes.BIGINT()}).expectErrorMessage("Invalid number of arguments. 3 arguments passed."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Cast strategy", SpecificInputTypeStrategies.CAST).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.BIGINT()}).calledWithLiteralAt(1, DataTypes.BIGINT()).expectSignature("f(<ANY>, <TYPE LITERAL>)").expectArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.BIGINT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Cast strategy for invalid target type", SpecificInputTypeStrategies.CAST).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()}).calledWithLiteralAt(1, DataTypes.DATE()).expectErrorMessage("Unsupported cast from 'BOOLEAN' to 'DATE'."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Logical type roots instead of concrete data types", InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.logical((LogicalTypeRoot)LogicalTypeRoot.VARCHAR), InputTypeStrategies.logical((LogicalTypeRoot)LogicalTypeRoot.DECIMAL, (boolean)true), InputTypeStrategies.logical((LogicalTypeRoot)LogicalTypeRoot.DECIMAL), InputTypeStrategies.logical((LogicalTypeRoot)LogicalTypeRoot.BOOLEAN), InputTypeStrategies.logical((LogicalTypeRoot)LogicalTypeRoot.INTEGER, (boolean)false), InputTypeStrategies.logical((LogicalTypeRoot)LogicalTypeRoot.INTEGER)})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.NULL(), DataTypes.INT(), DataTypes.DOUBLE(), DataTypes.BOOLEAN().notNull(), DataTypes.INT().notNull(), DataTypes.INT().notNull()}).expectSignature("f(<VARCHAR>, <DECIMAL NULL>, <DECIMAL>, <BOOLEAN>, <INTEGER NOT NULL>, <INTEGER>)").expectArgumentTypes(new AbstractDataType[]{DataTypes.VARCHAR((int)1), DataTypes.DECIMAL((int)10, (int)0), DataTypes.DECIMAL((int)30, (int)15), DataTypes.BOOLEAN().notNull(), DataTypes.INT().notNull(), DataTypes.INT().notNull()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Logical type roots with wrong implicit cast", InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.logical((LogicalTypeRoot)LogicalTypeRoot.VARCHAR)})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT()}).expectSignature("f(<VARCHAR>)").expectErrorMessage("Unsupported argument type. Expected type root 'VARCHAR' but actual type was 'INT'."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Logical type roots with wrong nullability", InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.logical((LogicalTypeRoot)LogicalTypeRoot.VARCHAR, (boolean)false)})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.VARCHAR((int)5)}).expectSignature("f(<VARCHAR NOT NULL>)").expectErrorMessage("Unsupported argument type. Expected nullable type of root 'VARCHAR' but actual type was 'VARCHAR(5)'."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Logical type family instead of concrete data types", InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.logical((LogicalTypeFamily)LogicalTypeFamily.CHARACTER_STRING, (boolean)true), InputTypeStrategies.logical((LogicalTypeFamily)LogicalTypeFamily.EXACT_NUMERIC), InputTypeStrategies.logical((LogicalTypeFamily)LogicalTypeFamily.APPROXIMATE_NUMERIC), InputTypeStrategies.logical((LogicalTypeFamily)LogicalTypeFamily.APPROXIMATE_NUMERIC), InputTypeStrategies.logical((LogicalTypeFamily)LogicalTypeFamily.APPROXIMATE_NUMERIC, (boolean)false)})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.NULL(), DataTypes.TINYINT(), DataTypes.INT(), DataTypes.BIGINT().notNull(), DataTypes.DECIMAL((int)10, (int)2).notNull()}).expectSignature("f(<CHARACTER_STRING NULL>, <EXACT_NUMERIC>, <APPROXIMATE_NUMERIC>, <APPROXIMATE_NUMERIC>, <APPROXIMATE_NUMERIC NOT NULL>)").expectArgumentTypes(new AbstractDataType[]{DataTypes.VARCHAR((int)1), DataTypes.TINYINT(), DataTypes.DOUBLE(), DataTypes.DOUBLE().notNull(), DataTypes.DOUBLE().notNull()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Logical type family with invalid type", InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.logical((LogicalTypeFamily)LogicalTypeFamily.EXACT_NUMERIC)})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.FLOAT()}).expectSignature("f(<EXACT_NUMERIC>)").expectErrorMessage("Unsupported argument type. Expected type of family 'EXACT_NUMERIC' but actual type was 'FLOAT'."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Constraint argument type strategy", InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.and((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN()), InputTypeStrategies.constraint((String)"%s must be nullable.", args -> ((DataType)args.get(0)).getLogicalType().isNullable())})})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN()}).expectSignature("f([BOOLEAN & <CONSTRAINT>])").expectArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Constraint argument type strategy invalid", InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.and((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)DataTypes.BOOLEAN().notNull())), InputTypeStrategies.constraint((String)"My constraint says %s must be nullable.", args -> ((DataType)args.get(0)).getLogicalType().isNullable())})})).calledWithArgumentTypes(DataTypes.BOOLEAN().notNull()).expectErrorMessage("My constraint says BOOLEAN NOT NULL must be nullable."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Composite type strategy with ROW", InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.COMPOSITE})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.BIGINT())})}).expectSignature("f(<COMPOSITE>)").expectArgumentTypes(new AbstractDataType[]{DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.BIGINT())})}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Composite type strategy with STRUCTURED type", InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.COMPOSITE})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.of(SimpleStructuredType.class).notNull()}).expectSignature("f(<COMPOSITE>)").expectArgumentTypes(new AbstractDataType[]{DataTypes.of(SimpleStructuredType.class).notNull()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Same named arguments for overloaded method.", InputTypeStrategies.or((InputTypeStrategy[])new InputTypeStrategy[]{InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())})})).namedArguments("sameName").calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BOOLEAN()}).expectErrorMessage("Invalid input arguments. Expected signatures are:\nf(STRING)\nf(INT)"), InputTypeStrategiesTestBase.TestSpec.forStrategy("Common argument type strategy", InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.COMMON_ARG, InputTypeStrategies.COMMON_ARG})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.BIGINT()}).expectSignature("f(<COMMON>, <COMMON>)").expectArgumentTypes(new AbstractDataType[]{DataTypes.BIGINT(), DataTypes.BIGINT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("ArrayElement argument type strategy", InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.logical((LogicalTypeRoot)LogicalTypeRoot.ARRAY), SpecificInputTypeStrategies.ARRAY_ELEMENT_ARG})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull())).notNull(), DataTypes.INT()}).expectSignature("f(<ARRAY>, <ARRAY ELEMENT>)").expectArgumentTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull())).notNull(), DataTypes.INT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{SpecificInputTypeStrategies.ARRAY_FULLY_COMPARABLE})).expectSignature("f(<ARRAY<COMPARABLE>>)").calledWithArgumentTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.ROW())}).expectErrorMessage("Invalid input arguments. Expected signatures are:\nf(<ARRAY<COMPARABLE>>)"), InputTypeStrategiesTestBase.TestSpec.forStrategy("Strategy fails if input argument type is not ARRAY", InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{SpecificInputTypeStrategies.ARRAY_FULLY_COMPARABLE})).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT()}).expectErrorMessage("Invalid input arguments. Expected signatures are:\nf(<ARRAY<COMPARABLE>>)"), InputTypeStrategiesTestBase.TestSpec.forStrategy("PROCTIME type strategy", SpecificInputTypeStrategies.windowTimeIndicator((TimestampKind)TimestampKind.PROCTIME)).calledWithArgumentTypes(new AbstractDataType[]{InputTypeStrategiesTest.timeIndicatorType(TimestampKind.PROCTIME)}).expectSignature("f(<WINDOW REFERENCE>)").expectArgumentTypes(new AbstractDataType[]{InputTypeStrategiesTest.timeIndicatorType(TimestampKind.PROCTIME)}), InputTypeStrategiesTestBase.TestSpec.forStrategy("PROCTIME type strategy on non time indicator", SpecificInputTypeStrategies.windowTimeIndicator((TimestampKind)TimestampKind.PROCTIME)).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BIGINT()}).expectErrorMessage("Reference to a rowtime or proctime window required."), InputTypeStrategiesTestBase.TestSpec.forStrategy("ROWTIME type strategy", SpecificInputTypeStrategies.windowTimeIndicator((TimestampKind)TimestampKind.ROWTIME)).calledWithArgumentTypes(new AbstractDataType[]{InputTypeStrategiesTest.timeIndicatorType(TimestampKind.ROWTIME)}).expectSignature("f(<WINDOW REFERENCE>)").expectArgumentTypes(new AbstractDataType[]{InputTypeStrategiesTest.timeIndicatorType(TimestampKind.ROWTIME)}), InputTypeStrategiesTestBase.TestSpec.forStrategy("ROWTIME type strategy on proctime indicator", SpecificInputTypeStrategies.windowTimeIndicator((TimestampKind)TimestampKind.ROWTIME)).calledWithArgumentTypes(new AbstractDataType[]{InputTypeStrategiesTest.timeIndicatorType(TimestampKind.PROCTIME)}).expectErrorMessage("A proctime window cannot provide a rowtime attribute."), InputTypeStrategiesTestBase.TestSpec.forStrategy("PROCTIME type strategy on rowtime indicator", SpecificInputTypeStrategies.windowTimeIndicator((TimestampKind)TimestampKind.PROCTIME)).calledWithArgumentTypes(new AbstractDataType[]{InputTypeStrategiesTest.timeIndicatorType(TimestampKind.ROWTIME)}).expectArgumentTypes(new AbstractDataType[]{InputTypeStrategiesTest.timeIndicatorType(TimestampKind.PROCTIME)}), InputTypeStrategiesTestBase.TestSpec.forStrategy("ROWTIME type strategy on long in batch mode", SpecificInputTypeStrategies.windowTimeIndicator((TimestampKind)TimestampKind.ROWTIME)).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.BIGINT()}).expectArgumentTypes(new AbstractDataType[]{DataTypes.BIGINT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("ROWTIME type strategy on non time attribute", SpecificInputTypeStrategies.windowTimeIndicator((TimestampKind)TimestampKind.ROWTIME)).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.SMALLINT()}).expectErrorMessage("Reference to a rowtime or proctime window required."), InputTypeStrategiesTestBase.TestSpec.forStrategy("PROCTIME type strategy on non time attribute", SpecificInputTypeStrategies.windowTimeIndicator((TimestampKind)TimestampKind.PROCTIME)).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.SMALLINT()}).expectErrorMessage("Reference to a rowtime or proctime window required."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Reinterpret_cast strategy", SpecificInputTypeStrategies.REINTERPRET_CAST).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.DATE(), DataTypes.BIGINT(), DataTypes.BOOLEAN().notNull()}).calledWithLiteralAt(1, DataTypes.BIGINT()).calledWithLiteralAt(2, true).expectSignature("f(<ANY>, <TYPE LITERAL>, <TRUE | FALSE>)").expectArgumentTypes(new AbstractDataType[]{DataTypes.DATE(), DataTypes.BIGINT(), DataTypes.BOOLEAN().notNull()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Reinterpret_cast strategy non literal overflow", SpecificInputTypeStrategies.REINTERPRET_CAST).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.DATE(), DataTypes.BIGINT(), DataTypes.BOOLEAN().notNull()}).calledWithLiteralAt(1, DataTypes.BIGINT()).expectErrorMessage("Not null boolean literal expected for overflow."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Reinterpret_cast strategy not supported cast", SpecificInputTypeStrategies.REINTERPRET_CAST).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.BIGINT(), DataTypes.BOOLEAN().notNull()}).calledWithLiteralAt(1, DataTypes.BIGINT()).calledWithLiteralAt(2, true).expectErrorMessage("Unsupported reinterpret cast from 'INT' to 'BIGINT'"));
    }

    private static DataType timeIndicatorType(TimestampKind timestampKind) {
        return TypeConversions.fromLogicalToDataType((LogicalType)new LocalZonedTimestampType(false, timestampKind, 3));
    }

    public static class SimpleStructuredType {
        public long f0;
    }
}

