/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.annotation.FunctionHints;
import org.apache.flink.table.annotation.InputGroup;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.annotation.ProcedureHints;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AsyncScalarFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.procedures.Procedure;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.TypeInferenceExtractor;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;
import org.apache.flink.types.Row;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class TypeInferenceExtractorTest {
    TypeInferenceExtractorTest() {
    }

    private static Stream<TestSpec> testData() {
        return Stream.concat(TypeInferenceExtractorTest.functionSpecs(), TypeInferenceExtractorTest.procedureSpecs());
    }

    private static Stream<TestSpec> functionSpecs() {
        return Stream.of(TestSpec.forScalarFunction(FullFunctionHint.class).expectNamedArguments("i", "s").expectTypedArguments(DataTypes.INT(), DataTypes.STRING()).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i", "s"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), TypeStrategies.explicit((DataType)DataTypes.BOOLEAN())), TestSpec.forScalarFunction(FullFunctionHints.class).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.BIGINT())), TestSpec.forScalarFunction(GlobalOutputFunctionHint.class).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forScalarFunction(InvalidSingleOutputFunctionHint.class).expectErrorMessage("Function hints that lead to ambiguous results are not allowed."), TestSpec.forScalarFunction(SplitFullFunctionHints.class).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.BIGINT())), TestSpec.forScalarFunction(InvalidFullOutputFunctionHint.class).expectErrorMessage("Function hints with same input definition but different result types are not allowed."), TestSpec.forScalarFunction(InvalidFullOutputFunctionWithArgNamesHint.class).expectErrorMessage("Function hints with same input definition but different result types are not allowed."), TestSpec.forScalarFunction(IncompleteFunctionHint.class).expectErrorMessage("Data type hint does neither specify a data type nor input group for use as function argument."), TestSpec.forScalarFunction(ComplexFunctionHint.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"myInt", "myAny"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), InputTypeStrategies.ANY}), TypeStrategies.explicit((DataType)DataTypes.BOOLEAN())), TestSpec.forScalarFunction(GlobalInputFunctionHints.class).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forScalarFunction(ZeroArgFunction.class).expectNamedArguments(new String[0]).expectTypedArguments(new DataType[0]).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[0], (ArgumentTypeStrategy[])new ArgumentTypeStrategy[0]), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forAsyncScalarFunction(ZeroArgFunctionAsync.class).expectNamedArguments(new String[0]).expectTypedArguments(new DataType[0]).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[0], (ArgumentTypeStrategy[])new ArgumentTypeStrategy[0]), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forScalarFunction(MixedArgFunction.class).expectNamedArguments("i", "d").expectTypedArguments((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE), DataTypes.DOUBLE()).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i", "d"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), InputTypeStrategies.explicit((DataType)DataTypes.DOUBLE())}), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forAsyncScalarFunction(MixedArgFunctionAsync.class).expectNamedArguments("i", "d").expectTypedArguments((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE), DataTypes.DOUBLE()).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i", "d"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), InputTypeStrategies.explicit((DataType)DataTypes.DOUBLE())}), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forScalarFunction(OverloadedFunction.class).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i", "d"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), InputTypeStrategies.explicit((DataType)DataTypes.DOUBLE())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"s"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.BIGINT().notNull()).bridgedTo(Long.TYPE)))), TestSpec.forAsyncScalarFunction(OverloadedFunctionAsync.class).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i", "d"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), InputTypeStrategies.explicit((DataType)DataTypes.DOUBLE())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"s"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), TypeStrategies.explicit((DataType)DataTypes.BIGINT())), TestSpec.forScalarFunction(VarArgFunction.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"i", "more"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forAsyncScalarFunction(VarArgFunctionAsync.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"i", "more"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forScalarFunction(VarArgWithByteFunction.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"bytes"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.TINYINT().notNull()).bridgedTo(Byte.TYPE)))}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forAsyncScalarFunction(VarArgWithByteFunctionAsync.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"bytes"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.TINYINT().notNull()).bridgedTo(Byte.TYPE)))}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forScalarFunction(ExtractWithOutputHintFunction.class).expectNamedArguments("i").expectTypedArguments(DataTypes.INT()).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forAsyncScalarFunction(ExtractWithOutputHintFunctionAsync.class).expectNamedArguments("i").expectTypedArguments(DataTypes.INT()).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forScalarFunction(ExtractWithInputHintFunction.class).expectNamedArguments("i", "b").expectTypedArguments(DataTypes.INT(), DataTypes.BOOLEAN()).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i", "b"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN())}), TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.DOUBLE().notNull()).bridgedTo(Double.TYPE)))), TestSpec.forAggregateFunction(InputDependentAccumulatorFunction.class).expectAccumulatorMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f", (DataType)DataTypes.BIGINT())}))).expectAccumulatorMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f", (DataType)DataTypes.STRING())}))).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.STRING())).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forAggregateFunction(AggregateFunctionWithManyAnnotations.class).expectNamedArguments("r").expectTypedArguments(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN())})).expectAccumulatorMapping(InputTypeStrategies.sequence((String[])new String[]{"r"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN())}))}), TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN())}))).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"r"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN())}))}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forTableFunction(OutputHintTableFunction.class).expectNamedArguments("i").expectTypedArguments((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))}), TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN())}))), TestSpec.forScalarFunction(InvalidMethodScalarFunction.class).expectErrorMessage("Considering all hints, the method should comply with the signature:\njava.lang.String eval(int[])"), TestSpec.forAsyncScalarFunction(InvalidMethodScalarFunctionAsync.class).expectErrorMessage("Considering all hints, the method should comply with the signature:\neval(java.util.concurrent.CompletableFuture, int[])"), TestSpec.forAggregateFunction(InvalidMethodAggregateFunction.class).expectErrorMessage("Considering all hints, the method should comply with the signature:\naccumulate(java.lang.Integer, int, boolean)"), TestSpec.forTableFunction(MissingMethodTableFunction.class).expectErrorMessage("Could not find a publicly accessible method named 'eval'."), TestSpec.forScalarFunction(NamedArgumentsScalarFunction.class), TestSpec.forScalarFunction(InputGroupScalarFunction.class).expectNamedArguments("o").expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"o"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.ANY}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forScalarFunction(VarArgInputGroupScalarFunction.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"o"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.ANY}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forScalarFunction("Scalar function with implicit overloading order", OrderedScalarFunction.class).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"l"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.BIGINT())), TestSpec.forScalarFunction("Scalar function with explicit overloading order by class annotations", OrderedScalarFunction2.class).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.BIGINT())).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forScalarFunction("Scalar function with explicit overloading order by method annotations", OrderedScalarFunction3.class).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.BIGINT())).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forTableFunction("A data type hint on the class is used instead of a function output hint", DataTypeHintOnTableFunctionClass.class).expectNamedArguments(new String[0]).expectTypedArguments(new DataType[0]).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[0], (ArgumentTypeStrategy[])new ArgumentTypeStrategy[0]), TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT())}))), TestSpec.forTableFunction("A data type hint on the method is used instead of a function output hint", DataTypeHintOnTableFunctionMethod.class).expectNamedArguments("i").expectTypedArguments(DataTypes.INT()).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT())}))), TestSpec.forTableFunction("Invalid data type hint on top of method and class", InvalidDataTypeHintOnTableFunction.class).expectErrorMessage("More than one data type hint found for output of function. Please use a function hint instead."), TestSpec.forScalarFunction("A data type hint on the method is used for enriching (not a function output hint)", DataTypeHintOnScalarFunction.class).expectNamedArguments(new String[0]).expectTypedArguments(new DataType[0]).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[0], (ArgumentTypeStrategy[])new ArgumentTypeStrategy[0]), TypeStrategies.explicit((DataType)((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT())}).bridgedTo(RowData.class)))), TestSpec.forAsyncScalarFunction("A data type hint on the method is used for enriching (not a function output hint)", DataTypeHintOnScalarFunctionAsync.class).expectNamedArguments(new String[0]).expectTypedArguments(new DataType[0]).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[0], (ArgumentTypeStrategy[])new ArgumentTypeStrategy[0]), TypeStrategies.explicit((DataType)((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT())}).bridgedTo(RowData.class)))), TestSpec.forScalarFunction("Scalar function with arguments hints", ArgumentHintScalarFunction.class).expectNamedArguments("f1", "f2").expectTypedArguments(DataTypes.STRING(), DataTypes.INT()).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"f1", "f2"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forScalarFunction("Scalar function with arguments hints missing type", ArgumentHintMissingTypeScalarFunction.class).expectErrorMessage("The type of the argument at position 0 is not set."), TestSpec.forScalarFunction("Scalar function with arguments hints all missing name", ArgumentHintMissingNameScalarFunction.class).expectTypedArguments(DataTypes.STRING(), DataTypes.INT()), TestSpec.forScalarFunction("Scalar function with arguments hints all missing partial name", ArgumentHintMissingPartialNameScalarFunction.class).expectErrorMessage("The argument name in function hint must be either fully set or not set at all."), TestSpec.forScalarFunction("Scalar function with arguments hints name conflict", ArgumentHintNameConflictScalarFunction.class).expectErrorMessage("Argument name conflict, there are at least two argument names that are the same."), TestSpec.forScalarFunction("Scalar function with arguments hints on method parameter", ArgumentHintOnParameterScalarFunction.class).expectNamedArguments("in1", "in2").expectTypedArguments(DataTypes.STRING(), DataTypes.INT()).expectOptionalArguments(false, false).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"in1", "in2"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forScalarFunction("Scalar function with arguments hints and inputs hints both defined", ArgumentsAndInputsScalarFunction.class).expectErrorMessage("Argument and input hints cannot be declared in the same function hint."), TestSpec.forScalarFunction("Scalar function with argument hint and dataType hint declared in the same parameter", ArgumentsHintAndDataTypeHintScalarFunction.class).expectErrorMessage("Argument and dataType hints cannot be declared in the same parameter at position 0."), TestSpec.forScalarFunction("An invalid scalar function that declare FunctionHint for both class and method in the same class.", InvalidFunctionHintOnClassAndMethod.class).expectErrorMessage("Argument and input hints cannot be declared in the same function hint."), TestSpec.forScalarFunction("A valid scalar class that declare FunctionHint for both class and method in the same class.", ValidFunctionHintOnClassAndMethod.class).expectNamedArguments("f1", "f2").expectTypedArguments(DataTypes.STRING(), DataTypes.INT()).expectOptionalArguments(true, true), TestSpec.forScalarFunction("The FunctionHint of the function conflicts with the method.", ScalarFunctionWithFunctionHintConflictMethod.class).expectErrorMessage("Considering all hints, the method should comply with the signature"), TestSpec.forScalarFunction("Scalar function with overloaded functions and arguments hint declared.", ArgumentsHintScalarFunctionWithOverloadedFunction.class), TestSpec.forScalarFunction("Scalar function with argument type not null but optional.", ArgumentHintNotNullTypeWithOptionalsScalarFunction.class).expectErrorMessage("Argument at position 0 is optional but its type doesn't accept null value."), TestSpec.forScalarFunction("Scalar function with arguments hint and variable length args", ArgumentHintVariableLengthScalarFunction.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"f1", "f2"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.STRING())));
    }

    private static Stream<TestSpec> procedureSpecs() {
        return Stream.of(TestSpec.forProcedure(FullProcedureHint.class).expectNamedArguments("i", "s").expectTypedArguments(DataTypes.INT(), DataTypes.STRING()).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i", "s"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), TypeStrategies.explicit((DataType)DataTypes.BOOLEAN())), TestSpec.forProcedure(FullProcedureHints.class).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.BIGINT())), TestSpec.forProcedure(GlobalOutputProcedureHint.class).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forProcedure(SplitFullProcedureHints.class).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.BIGINT())), TestSpec.forProcedure(ComplexProcedureHint.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"myInt", "myAny"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), InputTypeStrategies.ANY}), TypeStrategies.explicit((DataType)DataTypes.BOOLEAN())), TestSpec.forProcedure(GlobalInputProcedureHints.class).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forProcedure(ZeroArgProcedure.class).expectNamedArguments(new String[0]).expectTypedArguments(new DataType[0]).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[0], (ArgumentTypeStrategy[])new ArgumentTypeStrategy[0]), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forProcedure(MixedArgProcedure.class).expectNamedArguments("i", "d").expectTypedArguments((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE), DataTypes.DOUBLE()).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i", "d"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), InputTypeStrategies.explicit((DataType)DataTypes.DOUBLE())}), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forProcedure(OverloadedProcedure.class).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i", "d"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), InputTypeStrategies.explicit((DataType)DataTypes.DOUBLE())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"s"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.BIGINT().notNull()).bridgedTo(Long.TYPE)))), TestSpec.forProcedure(VarArgProcedure.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"i", "more"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forProcedure(VarArgWithByteProcedure.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"bytes"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.TINYINT().notNull()).bridgedTo(Byte.TYPE)))}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forProcedure(ExtractWithOutputHintProcedure.class).expectNamedArguments("i").expectTypedArguments(DataTypes.INT()).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forProcedure(ExtractWithInputHintProcedure.class).expectNamedArguments("i", "b").expectTypedArguments(DataTypes.INT(), DataTypes.BOOLEAN()).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i", "b"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN())}), TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.DOUBLE().notNull()).bridgedTo(Double.TYPE)))), TestSpec.forProcedure(NamedArgumentsProcedure.class), TestSpec.forProcedure(InputGroupProcedure.class).expectNamedArguments("o").expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"o"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.ANY}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forProcedure(VarArgInputGroupProcedure.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"o"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.ANY}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forProcedure("Procedure with implicit overloading order", OrderedProcedure.class).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"l"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.BIGINT())), TestSpec.forProcedure("Procedure with explicit overloading order by class annotations", OrderedProcedure2.class).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.BIGINT())).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forProcedure("Procedure with explicit overloading order by method annotations", OrderedProcedure3.class).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.BIGINT())).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forProcedure("A data type hint on the method is used for enriching (not a function output hint)", DataTypeHintOnProcedure.class).expectNamedArguments(new String[0]).expectTypedArguments(new DataType[0]).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[0], (ArgumentTypeStrategy[])new ArgumentTypeStrategy[0]), TypeStrategies.explicit((DataType)((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT())}).bridgedTo(RowData.class)))), TestSpec.forProcedure(InvalidSingleOutputProcedureHint.class).expectErrorMessage("Procedure hints that lead to ambiguous results are not allowed."), TestSpec.forProcedure(InvalidFullOutputProcedureHint.class).expectErrorMessage("Procedure hints with same input definition but different result types are not allowed."), TestSpec.forProcedure(InvalidFullOutputProcedureWithArgNamesHint.class).expectErrorMessage("Procedure hints with same input definition but different result types are not allowed."), TestSpec.forProcedure(IncompleteProcedureHint.class).expectErrorMessage("Data type hint does neither specify a data type nor input group for use as function argument."), TestSpec.forProcedure(InvalidMethodProcedure.class).expectErrorMessage("Considering all hints, the method should comply with the signature:\njava.lang.String[] call(_, int[])"), TestSpec.forProcedure(MissingMethodProcedure.class).expectErrorMessage("Could not find a publicly accessible method named 'call'."), TestSpec.forProcedure("Named arguments procedure with argument hint on method", ArgumentHintOnMethodProcedure.class).expectNamedArguments("f1", "f2").expectTypedArguments(DataTypes.STRING(), DataTypes.INT()).expectOptionalArguments(true, true).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"f1", "f2"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))), TestSpec.forProcedure("Named arguments procedure with argument hint on class", ArgumentHintOnClassProcedure.class).expectNamedArguments("f1", "f2").expectTypedArguments(DataTypes.STRING(), DataTypes.INT()).expectOptionalArguments(true, true).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"f1", "f2"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))), TestSpec.forProcedure("Named arguments procedure with argument hint on parameter", ArgumentHintOnParameterProcedure.class).expectNamedArguments("parameter_f1", "parameter_f2").expectTypedArguments(DataTypes.STRING(), (DataType)DataTypes.INT().bridgedTo(Integer.TYPE)).expectOptionalArguments(true, false).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"parameter_f1", "parameter_f2"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.explicit((DataType)((DataType)DataTypes.INT().bridgedTo(Integer.TYPE)))}), TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))), TestSpec.forProcedure("Named arguments procedure with argument hint on method and parameter", ArgumentHintOnMethodAndParameterProcedure.class).expectNamedArguments("local_f1", "local_f2").expectTypedArguments(DataTypes.STRING(), DataTypes.INT()).expectOptionalArguments(true, true).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"local_f1", "local_f2"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))), TestSpec.forProcedure("Named arguments procedure with argument hint on class and method", ArgumentHintOnClassAndMethodProcedure.class).expectNamedArguments("global_f1", "global_f2").expectTypedArguments(DataTypes.STRING(), DataTypes.INT()).expectOptionalArguments(false, false).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"global_f1", "global_f2"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))), TestSpec.forProcedure("Named arguments procedure with argument hint on class and method and parameter", ArgumentHintOnClassAndMethodAndParameterProcedure.class).expectNamedArguments("global_f1", "global_f2").expectTypedArguments(DataTypes.STRING(), DataTypes.INT()).expectOptionalArguments(false, false).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"global_f1", "global_f2"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))), TestSpec.forProcedure("Named arguments procedure with argument hint type not null but optional", ArgumentHintNotNullWithOptionalProcedure.class).expectErrorMessage("Argument at position 1 is optional but its type doesn't accept null value."), TestSpec.forProcedure("Named arguments procedure with argument name conflict", ArgumentHintNameConflictProcedure.class).expectErrorMessage("Argument name conflict, there are at least two argument names that are the same."), TestSpec.forProcedure("Named arguments procedure with optional type on primitive type", ArgumentHintOptionalOnPrimitiveParameterConflictProcedure.class).expectErrorMessage("Argument at position 1 is optional but a primitive type doesn't accept null value."));
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testArgumentNames(TestSpec testSpec) {
        if (testSpec.expectedArgumentNames != null) {
            Assertions.assertThat((Optional)testSpec.typeInferenceExtraction.get().getNamedArguments()).isEqualTo(Optional.of(testSpec.expectedArgumentNames));
        } else if (testSpec.expectedErrorMessage == null) {
            Assertions.assertThat((Optional)testSpec.typeInferenceExtraction.get().getNamedArguments()).isEqualTo(Optional.empty());
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testArgumentOptionals(TestSpec testSpec) {
        if (testSpec.expectedArgumentOptionals != null) {
            Assertions.assertThat((Optional)testSpec.typeInferenceExtraction.get().getOptionalArguments()).isEqualTo(Optional.of(testSpec.expectedArgumentOptionals));
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testArgumentTypes(TestSpec testSpec) {
        if (testSpec.expectedArgumentTypes != null) {
            Assertions.assertThat((Optional)testSpec.typeInferenceExtraction.get().getTypedArguments()).isEqualTo(Optional.of(testSpec.expectedArgumentTypes));
        } else if (testSpec.expectedErrorMessage == null) {
            Assertions.assertThat((Optional)testSpec.typeInferenceExtraction.get().getTypedArguments()).isEqualTo(Optional.empty());
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testInputTypeStrategy(TestSpec testSpec) {
        if (!testSpec.expectedOutputStrategies.isEmpty()) {
            Assertions.assertThat((Object)testSpec.typeInferenceExtraction.get().getInputTypeStrategy()).isEqualTo(testSpec.expectedOutputStrategies.keySet().stream().reduce((xva$0, xva$1) -> InputTypeStrategies.or((InputTypeStrategy[])new InputTypeStrategy[]{xva$0, xva$1})).orElseThrow(AssertionError::new));
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testAccumulatorTypeStrategy(TestSpec testSpec) {
        if (!testSpec.expectedAccumulatorStrategies.isEmpty()) {
            Assertions.assertThat((boolean)testSpec.typeInferenceExtraction.get().getAccumulatorTypeStrategy().isPresent()).isEqualTo(true);
            Assertions.assertThat(testSpec.typeInferenceExtraction.get().getAccumulatorTypeStrategy().get()).isEqualTo((Object)TypeStrategies.mapping(testSpec.expectedAccumulatorStrategies));
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testOutputTypeStrategy(TestSpec testSpec) {
        if (!testSpec.expectedOutputStrategies.isEmpty()) {
            Assertions.assertThat((Object)testSpec.typeInferenceExtraction.get().getOutputTypeStrategy()).isEqualTo((Object)TypeStrategies.mapping(testSpec.expectedOutputStrategies));
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testErrorMessage(TestSpec testSpec) {
        if (testSpec.expectedErrorMessage != null) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(testSpec.typeInferenceExtraction::get).isInstanceOf(ValidationException.class)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)testSpec.expectedErrorMessage)});
        } else {
            testSpec.typeInferenceExtraction.get();
        }
    }

    private static class ArgumentHintVariableLengthScalarFunction
    extends ScalarFunction {
        private ArgumentHintVariableLengthScalarFunction() {
        }

        @FunctionHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2")}, isVarArgs=true)
        public String eval(String f1, Integer ... f2) {
            return "";
        }
    }

    private static class ArgumentHintNotNullTypeWithOptionalsScalarFunction
    extends ScalarFunction {
        private ArgumentHintNotNullTypeWithOptionalsScalarFunction() {
        }

        @FunctionHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING NOT NULL"), name="f1", isOptional=true), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2", isOptional=true)})
        public String eval(String f1, Integer f2) {
            return "";
        }
    }

    private static class ArgumentsHintScalarFunctionWithOverloadedFunction
    extends ScalarFunction {
        private ArgumentsHintScalarFunctionWithOverloadedFunction() {
        }

        @FunctionHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2")})
        public String eval(String f1, Integer f2) {
            return "";
        }

        @FunctionHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1"), @ArgumentHint(type=@DataTypeHint(value="STRING"), name="f2")})
        public String eval(String f1, String f2) {
            return "";
        }
    }

    @FunctionHints(value={@FunctionHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2")}), @FunctionHint(argument={@ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2")})})
    private static class ScalarFunctionWithFunctionHintConflictMethod
    extends ScalarFunction {
        private ScalarFunctionWithFunctionHintConflictMethod() {
        }

        public String eval(String f1, Integer f2) {
            return "";
        }
    }

    @FunctionHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1", isOptional=true), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2", isOptional=true)})
    private static class ValidFunctionHintOnClassAndMethod
    extends ScalarFunction {
        private ValidFunctionHintOnClassAndMethod() {
        }

        @FunctionHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2")})
        public String eval(String f1, Integer f2) {
            return "";
        }
    }

    @FunctionHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2")})
    private static class InvalidFunctionHintOnClassAndMethod
    extends ScalarFunction {
        private InvalidFunctionHintOnClassAndMethod() {
        }

        @FunctionHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2")}, input={@DataTypeHint(value="STRING"), @DataTypeHint(value="INTEGER")})
        public String eval(String f1, Integer f2) {
            return "";
        }
    }

    private static class ArgumentsHintAndDataTypeHintScalarFunction
    extends ScalarFunction {
        private ArgumentsHintAndDataTypeHintScalarFunction() {
        }

        public String eval(@DataTypeHint(value="STRING") @ArgumentHint(name="f1", type=@DataTypeHint(value="STRING")) String f1, @ArgumentHint(name="f2", type=@DataTypeHint(value="INTEGER")) Integer f2) {
            return "";
        }
    }

    private static class ArgumentsAndInputsScalarFunction
    extends ScalarFunction {
        private ArgumentsAndInputsScalarFunction() {
        }

        @FunctionHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2")}, input={@DataTypeHint(value="STRING"), @DataTypeHint(value="INTEGER")})
        public String eval(String f1, Integer f2) {
            return "";
        }
    }

    private static class ArgumentHintOnParameterScalarFunction
    extends ScalarFunction {
        private ArgumentHintOnParameterScalarFunction() {
        }

        public String eval(@ArgumentHint(type=@DataTypeHint(value="STRING"), name="in1") String f1, @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="in2") Integer f2) {
            return "";
        }
    }

    private static class ArgumentHintNameConflictScalarFunction
    extends ScalarFunction {
        private ArgumentHintNameConflictScalarFunction() {
        }

        @FunctionHint(argument={@ArgumentHint(name="in1", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="in1", type=@DataTypeHint(value="INTEGER"))})
        public String eval(String f1, Integer f2) {
            return "";
        }
    }

    private static class ArgumentHintMissingPartialNameScalarFunction
    extends ScalarFunction {
        private ArgumentHintMissingPartialNameScalarFunction() {
        }

        @FunctionHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="in1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"))})
        public String eval(String f1, Integer f2) {
            return "";
        }
    }

    private static class ArgumentHintMissingNameScalarFunction
    extends ScalarFunction {
        private ArgumentHintMissingNameScalarFunction() {
        }

        @FunctionHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING")), @ArgumentHint(type=@DataTypeHint(value="INTEGER"))})
        public String eval(String f1, Integer f2) {
            return "";
        }
    }

    private static class ArgumentHintMissingTypeScalarFunction
    extends ScalarFunction {
        private ArgumentHintMissingTypeScalarFunction() {
        }

        @FunctionHint(argument={@ArgumentHint(name="f1"), @ArgumentHint(name="f2")})
        public String eval(String f1, Integer f2) {
            return "";
        }
    }

    private static class ArgumentHintScalarFunction
    extends ScalarFunction {
        private ArgumentHintScalarFunction() {
        }

        @FunctionHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2")})
        public String eval(String f1, Integer f2) {
            return "";
        }
    }

    private static class DataTypeHintOnScalarFunctionAsync
    extends AsyncScalarFunction {
        private DataTypeHintOnScalarFunctionAsync() {
        }

        public void eval(@DataTypeHint(value="ROW<i INT>") CompletableFuture<RowData> f) {
        }
    }

    @FunctionHint(output=@DataTypeHint(value="STRING"))
    private static class InvalidMethodScalarFunctionAsync
    extends AsyncScalarFunction {
        private InvalidMethodScalarFunctionAsync() {
        }

        public void eval(CompletableFuture<Long> f, int[] i) {
        }
    }

    @FunctionHint(output=@DataTypeHint(value="INT"))
    private static class ExtractWithOutputHintFunctionAsync
    extends AsyncScalarFunction {
        private ExtractWithOutputHintFunctionAsync() {
        }

        public void eval(CompletableFuture<Object> f, Integer i) {
        }
    }

    private static class VarArgWithByteFunctionAsync
    extends AsyncScalarFunction {
        private VarArgWithByteFunctionAsync() {
        }

        public void eval(CompletableFuture<String> f, byte ... bytes) {
        }
    }

    private static class VarArgFunctionAsync
    extends AsyncScalarFunction {
        private VarArgFunctionAsync() {
        }

        public void eval(CompletableFuture<String> f, int i, int ... more) {
        }
    }

    private static class OverloadedFunctionAsync
    extends AsyncScalarFunction {
        private OverloadedFunctionAsync() {
        }

        public void eval(CompletableFuture<Integer> f, int i, Double d) {
        }

        public void eval(CompletableFuture<Long> f, String s) {
        }
    }

    private static class MixedArgFunctionAsync
    extends AsyncScalarFunction {
        private MixedArgFunctionAsync() {
        }

        public void eval(CompletableFuture<Integer> f, int i, Double d) {
        }
    }

    private static class ZeroArgFunctionAsync
    extends AsyncScalarFunction {
        private ZeroArgFunctionAsync() {
        }

        public void eval(CompletableFuture<Integer> f) {
        }
    }

    private static class ArgumentHintOptionalOnPrimitiveParameterConflictProcedure
    implements Procedure {
        private ArgumentHintOptionalOnPrimitiveParameterConflictProcedure() {
        }

        @ProcedureHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1", isOptional=true), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2", isOptional=true)})
        public int[] call(Object procedureContext, String f1, int f2) {
            return null;
        }
    }

    private static class ArgumentHintNameConflictProcedure
    implements Procedure {
        private ArgumentHintNameConflictProcedure() {
        }

        @ProcedureHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1", isOptional=true), @ArgumentHint(type=@DataTypeHint(value="INTEGER NOT NULL"), name="f1", isOptional=true)})
        public int[] call(Object procedureContext, String f1, Integer f2) {
            return null;
        }
    }

    private static class ArgumentHintNotNullWithOptionalProcedure
    implements Procedure {
        private ArgumentHintNotNullWithOptionalProcedure() {
        }

        @ProcedureHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1", isOptional=true), @ArgumentHint(type=@DataTypeHint(value="INTEGER NOT NULL"), name="f2", isOptional=true)})
        public int[] call(Object procedureContext, String f1, Integer f2) {
            return null;
        }
    }

    @ProcedureHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="global_f1", isOptional=false), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="global_f2", isOptional=false)})
    private static class ArgumentHintOnClassAndMethodAndParameterProcedure
    implements Procedure {
        private ArgumentHintOnClassAndMethodAndParameterProcedure() {
        }

        @ProcedureHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="local_f1", isOptional=true), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="local_f2", isOptional=true)})
        public int[] call(Object procedureContext, @ArgumentHint(type=@DataTypeHint(value="STRING"), name="parameter_f1", isOptional=false) String f1, Integer f2) {
            return null;
        }
    }

    private static class ArgumentHintOnMethodAndParameterProcedure
    implements Procedure {
        private ArgumentHintOnMethodAndParameterProcedure() {
        }

        @ProcedureHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="local_f1", isOptional=true), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="local_f2", isOptional=true)})
        public int[] call(Object procedureContext, @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="parameter_f1", isOptional=true) String f1, @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="parameter_f2", isOptional=false) Integer f2) {
            return null;
        }
    }

    @ProcedureHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="global_f1", isOptional=false), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="global_f2", isOptional=false)})
    private static class ArgumentHintOnClassAndMethodProcedure
    implements Procedure {
        private ArgumentHintOnClassAndMethodProcedure() {
        }

        @ProcedureHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="local_f1", isOptional=true), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="local_f2", isOptional=true)})
        public int[] call(Object procedureContext, String f1, Integer f2) {
            return null;
        }
    }

    private static class ArgumentHintOnParameterProcedure
    implements Procedure {
        private ArgumentHintOnParameterProcedure() {
        }

        public int[] call(Object procedureContext, @ArgumentHint(type=@DataTypeHint(value="STRING"), name="parameter_f1", isOptional=true) String f1, @ArgumentHint(type=@DataTypeHint(value="INT"), name="parameter_f2", isOptional=false) int f2) {
            return null;
        }
    }

    @ProcedureHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1", isOptional=true), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2", isOptional=true)})
    private static class ArgumentHintOnClassProcedure
    implements Procedure {
        private ArgumentHintOnClassProcedure() {
        }

        public int[] call(Object procedureContext, String f1, Integer f2) {
            return null;
        }
    }

    private static class ArgumentHintOnMethodProcedure
    implements Procedure {
        private ArgumentHintOnMethodProcedure() {
        }

        @ProcedureHint(argument={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1", isOptional=true), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2", isOptional=true)})
        public int[] call(Object procedureContext, String f1, Integer f2) {
            return null;
        }
    }

    private static class MissingMethodProcedure
    implements Procedure {
        private MissingMethodProcedure() {
        }

        public int[] call1(Object procedureContext) {
            return null;
        }
    }

    private static class DataTypeHintOnProcedure
    implements Procedure {
        private DataTypeHintOnProcedure() {
        }

        @DataTypeHint(value="ROW<i INT>")
        public RowData[] call(Object procedureContext) {
            return null;
        }
    }

    private static class OrderedProcedure3
    implements Procedure {
        private OrderedProcedure3() {
        }

        @ProcedureHints(value={@ProcedureHint(input={@DataTypeHint(value="BIGINT")}, output=@DataTypeHint(value="BIGINT")), @ProcedureHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT"))})
        public Number[] call(Object procedureContext, Number n) {
            return null;
        }
    }

    @ProcedureHints(value={@ProcedureHint(input={@DataTypeHint(value="BIGINT")}, output=@DataTypeHint(value="BIGINT")), @ProcedureHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT"))})
    private static class OrderedProcedure2
    implements Procedure {
        private OrderedProcedure2() {
        }

        public Number[] call(Object procedureContext, Number n) {
            return null;
        }
    }

    private static class OrderedProcedure
    implements Procedure {
        private OrderedProcedure() {
        }

        public Long[] call(Object procedureContext, Long l) {
            return null;
        }

        public Integer[] call(Object procedureContext, Integer i) {
            return null;
        }
    }

    private static class VarArgInputGroupProcedure
    implements Procedure {
        private VarArgInputGroupProcedure() {
        }

        public String[] call(Object procedureContext, Object ... o) {
            return null;
        }
    }

    private static class InputGroupProcedure
    implements Procedure {
        private InputGroupProcedure() {
        }

        public String[] call(Object procedureContext, @DataTypeHint(inputGroup=InputGroup.ANY) Object o) {
            return null;
        }
    }

    private static class NamedArgumentsProcedure
    implements Procedure {
        private NamedArgumentsProcedure() {
        }

        public Integer[] call(Object procedureContext, int n) {
            return null;
        }

        public Integer[] call(Object procedureContext, long n) {
            return null;
        }

        public Integer[] call(Object procedureContext, @DataTypeHint(value="DECIMAL(10, 2)") Object n) {
            return null;
        }
    }

    @ProcedureHint(output=@DataTypeHint(value="STRING"))
    private static class InvalidMethodProcedure
    implements Procedure {
        private InvalidMethodProcedure() {
        }

        public Long[] call(Object procedureContext, int[] i) {
            return null;
        }
    }

    @ProcedureHint(input={@DataTypeHint(value="INT"), @DataTypeHint(value="BOOLEAN")}, argumentNames={"i", "b"})
    private static class ExtractWithInputHintProcedure
    implements Procedure {
        private ExtractWithInputHintProcedure() {
        }

        public double[] call(Object procedureContext, Object ... o) {
            return new double[]{0.0};
        }
    }

    @ProcedureHint(output=@DataTypeHint(value="INT"))
    private static class ExtractWithOutputHintProcedure
    implements Procedure {
        private ExtractWithOutputHintProcedure() {
        }

        public Object[] call(Object procedureContext, Integer i) {
            return null;
        }
    }

    private static class VarArgWithByteProcedure
    implements Procedure {
        private VarArgWithByteProcedure() {
        }

        public String[] call(Object procedureContext, byte ... bytes) {
            return null;
        }
    }

    private static class VarArgProcedure
    implements Procedure {
        private VarArgProcedure() {
        }

        public String[] call(Object procedureContext, int i, int ... more) {
            return null;
        }
    }

    private static class OverloadedProcedure
    implements Procedure {
        private OverloadedProcedure() {
        }

        public Integer[] call(Object procedureContext, int i, Double d) {
            return null;
        }

        public long[] call(Object procedureContext, String s) {
            return null;
        }
    }

    private static class MixedArgProcedure
    implements Procedure {
        private MixedArgProcedure() {
        }

        public Integer[] call(Object procedureContext, int i, Double d) {
            return null;
        }
    }

    private static class ZeroArgProcedure
    implements Procedure {
        private ZeroArgProcedure() {
        }

        public Integer[] call(Object procedureContext) {
            return null;
        }
    }

    @ProcedureHints(value={@ProcedureHint(input={@DataTypeHint(value="INT")}), @ProcedureHint(input={@DataTypeHint(value="BIGINT")})})
    private static class GlobalInputProcedureHints
    implements Procedure {
        private GlobalInputProcedureHints() {
        }

        @ProcedureHint(output=@DataTypeHint(value="INT"))
        public Integer[] call(Object procedureContext, Number n) {
            return null;
        }
    }

    @ProcedureHint(input={@DataTypeHint(value="INT"), @DataTypeHint}, output=@DataTypeHint(value="BOOLEAN"))
    private static class IncompleteProcedureHint
    implements Procedure {
        private IncompleteProcedureHint() {
        }

        public Boolean[] call(Object procedureContext, Integer i1, Integer i2) {
            return null;
        }
    }

    @ProcedureHint(input={@DataTypeHint(value="INT")})
    private static class InvalidLocalOutputProcedureHint
    implements Procedure {
        private InvalidLocalOutputProcedureHint() {
        }

        @ProcedureHint(output=@DataTypeHint(value="INT"))
        public Integer[] call(Object procedureContext, Integer n) {
            return null;
        }

        @ProcedureHint(output=@DataTypeHint(value="STRING"))
        public Integer[] call(Object procedureContext, String n) {
            return null;
        }
    }

    @ProcedureHint(input={@DataTypeHint(value="INT")}, argumentNames={"a"}, output=@DataTypeHint(value="INT"))
    private static class InvalidFullOutputProcedureWithArgNamesHint
    implements Procedure {
        private InvalidFullOutputProcedureWithArgNamesHint() {
        }

        @ProcedureHint(input={@DataTypeHint(value="INT")}, argumentNames={"b"}, output=@DataTypeHint(value="BIGINT"))
        public Number[] call(Object procedureContext, Integer i) {
            return null;
        }
    }

    @ProcedureHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT"))
    private static class InvalidFullOutputProcedureHint
    implements Procedure {
        private InvalidFullOutputProcedureHint() {
        }

        @ProcedureHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="BIGINT"))
        public Number[] call(Object procedureContext, Integer i) {
            return null;
        }
    }

    @ProcedureHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT"))
    private static class SplitFullProcedureHints
    implements Procedure {
        private SplitFullProcedureHints() {
        }

        @ProcedureHint(input={@DataTypeHint(value="BIGINT")}, output=@DataTypeHint(value="BIGINT"))
        public Number[] call(Object procedureContext, Number n) {
            return null;
        }
    }

    @ProcedureHint(output=@DataTypeHint(value="INT"))
    private static class InvalidSingleOutputProcedureHint
    implements Procedure {
        private InvalidSingleOutputProcedureHint() {
        }

        @ProcedureHint(output=@DataTypeHint(value="TINYINT"))
        public Integer call(Object procedureContext, Number n) {
            return null;
        }
    }

    @ProcedureHint(output=@DataTypeHint(value="INT"))
    private static class GlobalOutputProcedureHint
    implements Procedure {
        private GlobalOutputProcedureHint() {
        }

        @ProcedureHint(input={@DataTypeHint(value="INT")})
        public Integer[] call(Object procedureContext, Integer n) {
            return null;
        }

        @ProcedureHint(input={@DataTypeHint(value="STRING")})
        public Integer[] call(Object procedureContext, String n) {
            return null;
        }
    }

    @ProcedureHints(value={@ProcedureHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT")), @ProcedureHint(input={@DataTypeHint(value="BIGINT")}, output=@DataTypeHint(value="BIGINT"))})
    private static class FullProcedureHints
    implements Procedure {
        private FullProcedureHints() {
        }

        public Number[] call(Object procedureContext, Number n) {
            return null;
        }
    }

    private static class ComplexProcedureHint
    implements Procedure {
        private ComplexProcedureHint() {
        }

        @ProcedureHint(input={@DataTypeHint(value="ARRAY<INT>"), @DataTypeHint(inputGroup=InputGroup.ANY)}, argumentNames={"myInt", "myAny"}, output=@DataTypeHint(value="BOOLEAN"), isVarArgs=true)
        public Boolean[] call(Object procedureContext, Object ... o) {
            return null;
        }
    }

    @ProcedureHint(input={@DataTypeHint(value="INT"), @DataTypeHint(value="STRING")}, argumentNames={"i", "s"}, output=@DataTypeHint(value="BOOLEAN"))
    private static class FullProcedureHint
    implements Procedure {
        private FullProcedureHint() {
        }

        public Boolean[] call(Object procedureContext, Integer i, String s) {
            return null;
        }
    }

    private static class DataTypeHintOnScalarFunction
    extends ScalarFunction {
        private DataTypeHintOnScalarFunction() {
        }

        @DataTypeHint(value="ROW<i INT>")
        public RowData eval() {
            return null;
        }
    }

    @DataTypeHint(value="ROW<i BOOLEAN>")
    private static class InvalidDataTypeHintOnTableFunction
    extends TableFunction<Row> {
        private InvalidDataTypeHintOnTableFunction() {
        }

        @DataTypeHint(value="ROW<i INT>")
        public void eval(Integer i) {
        }
    }

    private static class DataTypeHintOnTableFunctionMethod
    extends TableFunction<Row> {
        private DataTypeHintOnTableFunctionMethod() {
        }

        @DataTypeHint(value="ROW<i INT>")
        public void eval(Integer i) {
        }
    }

    @DataTypeHint(value="ROW<i INT>")
    private static class DataTypeHintOnTableFunctionClass
    extends TableFunction<Row> {
        private DataTypeHintOnTableFunctionClass() {
        }

        public void eval() {
        }
    }

    private static class OrderedScalarFunction3
    extends ScalarFunction {
        private OrderedScalarFunction3() {
        }

        @FunctionHints(value={@FunctionHint(input={@DataTypeHint(value="BIGINT")}, output=@DataTypeHint(value="BIGINT")), @FunctionHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT"))})
        public Number eval(Number n) {
            return n;
        }
    }

    @FunctionHints(value={@FunctionHint(input={@DataTypeHint(value="BIGINT")}, output=@DataTypeHint(value="BIGINT")), @FunctionHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT"))})
    private static class OrderedScalarFunction2
    extends ScalarFunction {
        private OrderedScalarFunction2() {
        }

        public Number eval(Number n) {
            return n;
        }
    }

    private static class OrderedScalarFunction
    extends ScalarFunction {
        private OrderedScalarFunction() {
        }

        public Long eval(Long l) {
            return l;
        }

        public Integer eval(Integer i) {
            return i;
        }
    }

    private static class VarArgInputGroupScalarFunction
    extends ScalarFunction {
        private VarArgInputGroupScalarFunction() {
        }

        public String eval(Object ... o) {
            return Arrays.toString(o);
        }
    }

    private static class InputGroupScalarFunction
    extends ScalarFunction {
        private InputGroupScalarFunction() {
        }

        public String eval(@DataTypeHint(inputGroup=InputGroup.ANY) Object o) {
            return o.toString();
        }
    }

    private static class NamedArgumentsScalarFunction
    extends ScalarFunction {
        private NamedArgumentsScalarFunction() {
        }

        public Integer eval(int n) {
            return null;
        }

        public Integer eval(long n) {
            return null;
        }

        public Integer eval(@DataTypeHint(value="DECIMAL(10, 2)") Object n) {
            return null;
        }
    }

    private static class MissingMethodTableFunction
    extends TableFunction<String> {
        private MissingMethodTableFunction() {
        }
    }

    @FunctionHint(accumulator=@DataTypeHint(value="INT"))
    private static class InvalidMethodAggregateFunction
    extends AggregateFunction<String, Boolean> {
        private InvalidMethodAggregateFunction() {
        }

        public void accumulate(Boolean acc, int a, boolean b) {
        }

        public String getValue(Boolean accumulator) {
            return null;
        }

        public Boolean createAccumulator() {
            return null;
        }
    }

    @FunctionHint(output=@DataTypeHint(value="STRING"))
    private static class InvalidMethodScalarFunction
    extends ScalarFunction {
        private InvalidMethodScalarFunction() {
        }

        public Long eval(int[] i) {
            return null;
        }
    }

    @FunctionHint(output=@DataTypeHint(value="ROW<i INT, b BOOLEAN>"))
    private static class OutputHintTableFunction
    extends TableFunction<Row> {
        private OutputHintTableFunction() {
        }

        public void eval(int i) {
        }
    }

    @FunctionHint(output=@DataTypeHint(value="STRING"))
    private static class AggregateFunctionWithManyAnnotations
    extends AggregateFunction<String, Row> {
        private AggregateFunctionWithManyAnnotations() {
        }

        @FunctionHint(accumulator=@DataTypeHint(value="ROW<b BOOLEAN>"))
        public void accumulate(Row accumulator, @DataTypeHint(value="ROW<i INT, b BOOLEAN>") Row r) {
        }

        public String getValue(Row accumulator) {
            return null;
        }

        public Row createAccumulator() {
            return null;
        }
    }

    @FunctionHints(value={@FunctionHint(input={@DataTypeHint(value="BIGINT")}, accumulator=@DataTypeHint(value="ROW<f BIGINT>")), @FunctionHint(input={@DataTypeHint(value="STRING")}, accumulator=@DataTypeHint(value="ROW<f STRING>"))})
    private static class InputDependentAccumulatorFunction
    extends AggregateFunction<String, Row> {
        private InputDependentAccumulatorFunction() {
        }

        public void accumulate(Row accumulator, Object o) {
        }

        public String getValue(Row accumulator) {
            return null;
        }

        public Row createAccumulator() {
            return null;
        }
    }

    @FunctionHint(input={@DataTypeHint(value="INT"), @DataTypeHint(value="BOOLEAN")}, argumentNames={"i", "b"})
    private static class ExtractWithInputHintFunction
    extends ScalarFunction {
        private ExtractWithInputHintFunction() {
        }

        public double eval(Object ... o) {
            return 0.0;
        }
    }

    @FunctionHint(output=@DataTypeHint(value="INT"))
    private static class ExtractWithOutputHintFunction
    extends ScalarFunction {
        private ExtractWithOutputHintFunction() {
        }

        public Object eval(Integer i) {
            return null;
        }
    }

    private static class VarArgWithByteFunction
    extends ScalarFunction {
        private VarArgWithByteFunction() {
        }

        public String eval(byte ... bytes) {
            return null;
        }
    }

    private static class VarArgFunction
    extends ScalarFunction {
        private VarArgFunction() {
        }

        public String eval(int i, int ... more) {
            return null;
        }
    }

    private static class OverloadedFunction
    extends ScalarFunction {
        private OverloadedFunction() {
        }

        public Integer eval(int i, Double d) {
            return null;
        }

        public long eval(String s) {
            return 0L;
        }
    }

    private static class MixedArgFunction
    extends ScalarFunction {
        private MixedArgFunction() {
        }

        public Integer eval(int i, Double d) {
            return null;
        }
    }

    private static class ZeroArgFunction
    extends ScalarFunction {
        private ZeroArgFunction() {
        }

        public Integer eval() {
            return null;
        }
    }

    @FunctionHints(value={@FunctionHint(input={@DataTypeHint(value="INT")}), @FunctionHint(input={@DataTypeHint(value="BIGINT")})})
    private static class GlobalInputFunctionHints
    extends ScalarFunction {
        private GlobalInputFunctionHints() {
        }

        @FunctionHint(output=@DataTypeHint(value="INT"))
        public Integer eval(Number n) {
            return null;
        }
    }

    @FunctionHint(input={@DataTypeHint(value="INT"), @DataTypeHint}, output=@DataTypeHint(value="BOOLEAN"))
    private static class IncompleteFunctionHint
    extends ScalarFunction {
        private IncompleteFunctionHint() {
        }

        public Boolean eval(Integer i1, Integer i2) {
            return null;
        }
    }

    @FunctionHint(input={@DataTypeHint(value="INT")})
    private static class InvalidLocalOutputFunctionHint
    extends ScalarFunction {
        private InvalidLocalOutputFunctionHint() {
        }

        @FunctionHint(output=@DataTypeHint(value="INT"))
        public Integer eval(Integer n) {
            return null;
        }

        @FunctionHint(output=@DataTypeHint(value="STRING"))
        public Integer eval(String n) {
            return null;
        }
    }

    @FunctionHint(input={@DataTypeHint(value="INT")}, argumentNames={"a"}, output=@DataTypeHint(value="INT"))
    private static class InvalidFullOutputFunctionWithArgNamesHint
    extends ScalarFunction {
        private InvalidFullOutputFunctionWithArgNamesHint() {
        }

        @FunctionHint(input={@DataTypeHint(value="INT")}, argumentNames={"b"}, output=@DataTypeHint(value="BIGINT"))
        public Number eval(Integer i) {
            return null;
        }
    }

    @FunctionHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT"))
    private static class InvalidFullOutputFunctionHint
    extends ScalarFunction {
        private InvalidFullOutputFunctionHint() {
        }

        @FunctionHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="BIGINT"))
        public Number eval(Integer i) {
            return null;
        }
    }

    @FunctionHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT"))
    private static class SplitFullFunctionHints
    extends ScalarFunction {
        private SplitFullFunctionHints() {
        }

        @FunctionHint(input={@DataTypeHint(value="BIGINT")}, output=@DataTypeHint(value="BIGINT"))
        public Number eval(Number n) {
            return null;
        }
    }

    @FunctionHint(output=@DataTypeHint(value="INT"))
    private static class InvalidSingleOutputFunctionHint
    extends ScalarFunction {
        private InvalidSingleOutputFunctionHint() {
        }

        @FunctionHint(output=@DataTypeHint(value="TINYINT"))
        public Integer eval(Number n) {
            return null;
        }
    }

    @FunctionHint(output=@DataTypeHint(value="INT"))
    private static class GlobalOutputFunctionHint
    extends ScalarFunction {
        private GlobalOutputFunctionHint() {
        }

        @FunctionHint(input={@DataTypeHint(value="INT")})
        public Integer eval(Integer n) {
            return null;
        }

        @FunctionHint(input={@DataTypeHint(value="STRING")})
        public Integer eval(String n) {
            return null;
        }
    }

    @FunctionHints(value={@FunctionHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT")), @FunctionHint(input={@DataTypeHint(value="BIGINT")}, output=@DataTypeHint(value="BIGINT"))})
    private static class FullFunctionHints
    extends ScalarFunction {
        private FullFunctionHints() {
        }

        public Number eval(Number n) {
            return null;
        }
    }

    private static class ComplexFunctionHint
    extends ScalarFunction {
        private ComplexFunctionHint() {
        }

        @FunctionHint(input={@DataTypeHint(value="ARRAY<INT>"), @DataTypeHint(inputGroup=InputGroup.ANY)}, argumentNames={"myInt", "myAny"}, output=@DataTypeHint(value="BOOLEAN"), isVarArgs=true)
        public Boolean eval(Object ... o) {
            return null;
        }
    }

    @FunctionHint(input={@DataTypeHint(value="INT"), @DataTypeHint(value="STRING")}, argumentNames={"i", "s"}, output=@DataTypeHint(value="BOOLEAN"))
    private static class FullFunctionHint
    extends ScalarFunction {
        private FullFunctionHint() {
        }

        public Boolean eval(Integer i, String s) {
            return null;
        }
    }

    static class TestSpec {
        private final String description;
        final Supplier<TypeInference> typeInferenceExtraction;
        @Nullable
        List<String> expectedArgumentNames;
        @Nullable
        List<Boolean> expectedArgumentOptionals;
        @Nullable
        List<DataType> expectedArgumentTypes;
        Map<InputTypeStrategy, TypeStrategy> expectedAccumulatorStrategies;
        Map<InputTypeStrategy, TypeStrategy> expectedOutputStrategies;
        @Nullable
        String expectedErrorMessage;

        private TestSpec(String description, Supplier<TypeInference> typeInferenceExtraction) {
            this.description = description;
            this.typeInferenceExtraction = typeInferenceExtraction;
            this.expectedAccumulatorStrategies = new LinkedHashMap<InputTypeStrategy, TypeStrategy>();
            this.expectedOutputStrategies = new LinkedHashMap<InputTypeStrategy, TypeStrategy>();
        }

        static TestSpec forScalarFunction(Class<? extends ScalarFunction> function) {
            return TestSpec.forScalarFunction(null, function);
        }

        static TestSpec forScalarFunction(String description, Class<? extends ScalarFunction> function) {
            return new TestSpec(description == null ? function.getSimpleName() : description, () -> TypeInferenceExtractor.forScalarFunction((DataTypeFactory)new DataTypeFactoryMock(), (Class)function));
        }

        static TestSpec forAsyncScalarFunction(Class<? extends AsyncScalarFunction> function) {
            return TestSpec.forAsyncScalarFunction(null, function);
        }

        static TestSpec forAsyncScalarFunction(String description, Class<? extends AsyncScalarFunction> function) {
            return new TestSpec(description == null ? function.getSimpleName() : description, () -> TypeInferenceExtractor.forAsyncScalarFunction((DataTypeFactory)new DataTypeFactoryMock(), (Class)function));
        }

        static TestSpec forAggregateFunction(Class<? extends AggregateFunction<?, ?>> function) {
            return new TestSpec(function.getSimpleName(), () -> TypeInferenceExtractor.forAggregateFunction((DataTypeFactory)new DataTypeFactoryMock(), (Class)function));
        }

        static TestSpec forTableFunction(Class<? extends TableFunction<?>> function) {
            return TestSpec.forTableFunction(null, function);
        }

        static TestSpec forTableFunction(String description, Class<? extends TableFunction<?>> function) {
            return new TestSpec(description == null ? function.getSimpleName() : description, () -> TypeInferenceExtractor.forTableFunction((DataTypeFactory)new DataTypeFactoryMock(), (Class)function));
        }

        static TestSpec forTableAggregateFunction(Class<? extends TableAggregateFunction<?, ?>> function) {
            return new TestSpec(function.getSimpleName(), () -> TypeInferenceExtractor.forTableAggregateFunction((DataTypeFactory)new DataTypeFactoryMock(), (Class)function));
        }

        static TestSpec forProcedure(Class<? extends Procedure> procedure) {
            return TestSpec.forProcedure(null, procedure);
        }

        static TestSpec forProcedure(@Nullable String description, Class<? extends Procedure> procedure) {
            return new TestSpec(description == null ? procedure.getSimpleName() : description, () -> TypeInferenceExtractor.forProcedure((DataTypeFactory)new DataTypeFactoryMock(), (Class)procedure));
        }

        TestSpec expectNamedArguments(String ... expectedArgumentNames) {
            this.expectedArgumentNames = Arrays.asList(expectedArgumentNames);
            return this;
        }

        TestSpec expectOptionalArguments(Boolean ... expectedArgumentOptionals) {
            this.expectedArgumentOptionals = Arrays.asList(expectedArgumentOptionals);
            return this;
        }

        TestSpec expectTypedArguments(DataType ... expectedArgumentTypes) {
            this.expectedArgumentTypes = Arrays.asList(expectedArgumentTypes);
            return this;
        }

        TestSpec expectAccumulatorMapping(InputTypeStrategy validator, TypeStrategy accumulatorStrategy) {
            this.expectedAccumulatorStrategies.put(validator, accumulatorStrategy);
            return this;
        }

        TestSpec expectOutputMapping(InputTypeStrategy validator, TypeStrategy outputStrategy) {
            this.expectedOutputStrategies.put(validator, outputStrategy);
            return this;
        }

        TestSpec expectErrorMessage(String expectedErrorMessage) {
            this.expectedErrorMessage = expectedErrorMessage;
            return this;
        }

        public String toString() {
            return this.description;
        }
    }
}

