/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.types.DataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ProjectionTest {
    ProjectionTest() {
    }

    @Test
    void testTopLevelProject() {
        Assertions.assertThat((Object)Projection.of((int[])new int[]{2, 1}).project(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f2", (DataType)DataTypes.INT())}))).isEqualTo((Object)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f2", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())}));
    }

    @Test
    void testNestedProject() {
        DataType thirdLevelRow = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"c0", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"c1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"c2", (DataType)DataTypes.INT())});
        DataType secondLevelRow = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"b0", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"b1", (DataType)thirdLevelRow), DataTypes.FIELD((String)"b2", (DataType)DataTypes.INT())});
        DataType topLevelRow = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"a1", (DataType)secondLevelRow), DataTypes.FIELD((String)"a1_b1_c0", (DataType)DataTypes.INT())});
        Assertions.assertThat((Object)Projection.of((int[][])new int[][]{{0}, {1, 1, 0}}).project(topLevelRow)).isEqualTo((Object)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"a1_b1_c0", (DataType)DataTypes.BOOLEAN())}));
        Assertions.assertThat((Object)Projection.of((int[][])new int[][]{{1, 1}, {0}}).project(topLevelRow)).isEqualTo((Object)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a1_b1", (DataType)thirdLevelRow), DataTypes.FIELD((String)"a0", (DataType)DataTypes.INT())}));
        Assertions.assertThat((Object)Projection.of((int[][])new int[][]{{1, 1, 2}, {1, 1, 1}, {1, 1, 0}}).project(topLevelRow)).isEqualTo((Object)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a1_b1_c2", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"a1_b1_c1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"a1_b1_c0", (DataType)DataTypes.BOOLEAN())}));
        Assertions.assertThat((Object)Projection.of((int[][])new int[][]{{1, 1, 0}, {2}}).project(topLevelRow)).isEqualTo((Object)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a1_b1_c0", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"a1_b1_c0_$0", (DataType)DataTypes.INT())}));
    }

    @Test
    void testIsNested() {
        Assertions.assertThat((boolean)Projection.of((int[])new int[]{2, 1}).isNested()).isFalse();
        Assertions.assertThat((boolean)Projection.of((int[][])new int[][]{{1}, {3}}).isNested()).isFalse();
        Assertions.assertThat((boolean)Projection.of((int[][])new int[][]{{1}, {1, 2}, {3}}).isNested()).isTrue();
    }

    @Test
    void testDifference() {
        Assertions.assertThat((Object)Projection.of((int[])new int[]{4, 1, 0, 3, 2}).difference(Projection.of((int[])new int[]{4, 2}))).isEqualTo((Object)Projection.of((int[])new int[]{1, 0, 2}));
        Assertions.assertThat((Object)Projection.of((int[][])new int[][]{{4}, {1, 3}, {0}, {3, 1}, {2}}).difference(Projection.of((int[])new int[]{4, 2}))).isEqualTo((Object)Projection.of((int[][])new int[][]{{1, 3}, {0}, {2, 1}}));
        Assertions.assertThatThrownBy(() -> Projection.of((int[])new int[]{1, 2, 3, 4}).difference(Projection.of((int[][])new int[][]{{2}, {3, 4}}))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testComplement() {
        Assertions.assertThat((Object)Projection.of((int[])new int[]{4, 1, 2}).complement(5)).isEqualTo((Object)Projection.of((int[])new int[]{0, 3}));
        Assertions.assertThat((Object)Projection.of((int[][])new int[][]{{4}, {1}, {2}}).complement(5)).isEqualTo((Object)Projection.of((int[])new int[]{0, 3}));
        Assertions.assertThatThrownBy(() -> Projection.of((int[][])new int[][]{{4}, {1, 3}, {2}}).complement(10)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testToTopLevelIndexes() {
        Assertions.assertThat((int[])Projection.of((int[])new int[]{1, 2, 3, 4}).toTopLevelIndexes()).isEqualTo((Object)new int[]{1, 2, 3, 4});
        Assertions.assertThat((int[])Projection.of((int[][])new int[][]{{4}, {1}, {2}}).toTopLevelIndexes()).isEqualTo((Object)new int[]{4, 1, 2});
        Assertions.assertThatThrownBy(() -> Projection.of((int[][])new int[][]{{4}, {1, 3}, {2}}).toTopLevelIndexes()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testToNestedIndexes() {
        Assertions.assertThat((int[][])Projection.of((int[])new int[]{1, 2, 3, 4}).toNestedIndexes()).isEqualTo((Object)new int[][]{{1}, {2}, {3}, {4}});
        Assertions.assertThat((int[][])Projection.of((int[][])new int[][]{{4}, {1, 3}, {2}}).toNestedIndexes()).isEqualTo((Object)new int[][]{{4}, {1, 3}, {2}});
    }

    @Test
    void testEquals() {
        Assertions.assertThat((Object)Projection.of((int[][])new int[][]{{1}, {2}, {3}})).isEqualTo((Object)Projection.of((int[])new int[]{1, 2, 3}));
    }
}

