/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector.source;

import java.io.IOException;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.connector.source.TestManagedIterableSourceSplit;

public class TestManagedFileSourceSplitSerializer
implements SimpleVersionedSerializer<TestManagedIterableSourceSplit> {
    private static final int VERSION = 1;

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(TestManagedIterableSourceSplit split) throws IOException {
        DataOutputSerializer out = new DataOutputSerializer(64);
        out.writeUTF(split.splitId());
        Path.serializeToDataOutputView((Path)split.getFilePath(), (DataOutputView)out);
        byte[] result = out.getCopyOfBuffer();
        out.clear();
        return result;
    }

    public TestManagedIterableSourceSplit deserialize(int version, byte[] serialized) throws IOException {
        if (version == 1) {
            DataInputDeserializer in = new DataInputDeserializer(serialized);
            String id = in.readUTF();
            Path result = Path.deserializeFromDataInputView((DataInputView)in);
            Path path = result == null ? new Path() : result;
            return new TestManagedIterableSourceSplit(id, path);
        }
        throw new IOException(String.format("Unknown version %d", version));
    }
}

