/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector.source;

import java.util.ArrayList;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.table.connector.source.CompactPartitions;
import org.apache.flink.table.connector.source.TestManagedFileSourceReader;
import org.apache.flink.table.connector.source.TestManagedFileSourceSplitEnumerator;
import org.apache.flink.table.connector.source.TestManagedFileSourceSplitSerializer;
import org.apache.flink.table.connector.source.TestManagedIterableSourceSplit;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.utils.PartitionPathUtils;

public class TestManagedSource
implements Source<RowData, TestManagedIterableSourceSplit, Void> {
    private static final long serialVersionUID = 1L;
    private final CompactPartitions partitions;

    public TestManagedSource(CompactPartitions partitions) {
        this.partitions = partitions;
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public SourceReader<RowData, TestManagedIterableSourceSplit> createReader(SourceReaderContext readerContext) {
        return new TestManagedFileSourceReader(readerContext);
    }

    public SplitEnumerator<TestManagedIterableSourceSplit, Void> createEnumerator(SplitEnumeratorContext<TestManagedIterableSourceSplit> enumContext) {
        ArrayList<TestManagedIterableSourceSplit> splits = new ArrayList<TestManagedIterableSourceSplit>();
        this.partitions.getCompactPartitions().forEach(partition -> partition.getFileEntries().forEach(fileEntry -> splits.add(new TestManagedIterableSourceSplit(PartitionPathUtils.generatePartitionPath(partition.getResolvedPartitionSpec()), new Path(fileEntry)))));
        return new TestManagedFileSourceSplitEnumerator(enumContext, splits);
    }

    public SplitEnumerator<TestManagedIterableSourceSplit, Void> restoreEnumerator(SplitEnumeratorContext<TestManagedIterableSourceSplit> enumContext, Void checkpoint) {
        throw new UnsupportedOperationException();
    }

    public SimpleVersionedSerializer<TestManagedIterableSourceSplit> getSplitSerializer() {
        return new TestManagedFileSourceSplitSerializer();
    }

    public SimpleVersionedSerializer<Void> getEnumeratorCheckpointSerializer() {
        return null;
    }
}

