/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeInferenceUtil;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.inference.utils.CallContextMock;
import org.apache.flink.table.types.inference.utils.FunctionDefinitionMock;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class InputTypeStrategiesTestBase {
    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testStrategy(TestSpec testSpec) {
        if (testSpec.expectedSignature != null) {
            Assertions.assertThat((String)this.generateSignature(testSpec)).isEqualTo(testSpec.expectedSignature);
        }
        for (List actualArgumentTypes : testSpec.actualArgumentTypes) {
            if (testSpec.expectedErrorMessage != null) {
                Assertions.assertThatThrownBy(() -> this.runTypeInference(actualArgumentTypes, testSpec)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)testSpec.expectedErrorMessage)});
                continue;
            }
            if (testSpec.expectedArgumentTypes == null) continue;
            Assertions.assertThat((List)this.runTypeInference(actualArgumentTypes, testSpec).getExpectedArgumentTypes()).isEqualTo((Object)testSpec.expectedArgumentTypes);
        }
    }

    protected abstract Stream<TestSpec> testData();

    private String generateSignature(TestSpec testSpec) {
        FunctionDefinitionMock functionDefinitionMock = new FunctionDefinitionMock();
        functionDefinitionMock.functionKind = FunctionKind.SCALAR;
        return TypeInferenceUtil.generateSignature((TypeInference)this.createTypeInference(testSpec), (String)"f", (FunctionDefinition)functionDefinitionMock);
    }

    private TypeInferenceUtil.Result runTypeInference(List<DataType> actualArgumentTypes, TestSpec testSpec) {
        TypeInferenceUtil.SurroundingInfo surroundingInfo;
        FunctionDefinitionMock functionDefinitionMock = new FunctionDefinitionMock();
        functionDefinitionMock.functionKind = FunctionKind.SCALAR;
        CallContextMock callContextMock = new CallContextMock();
        callContextMock.typeFactory = new DataTypeFactoryMock();
        callContextMock.functionDefinition = functionDefinitionMock;
        callContextMock.argumentDataTypes = actualArgumentTypes;
        callContextMock.argumentLiterals = IntStream.range(0, actualArgumentTypes.size()).mapToObj(i -> testSpec.literalPos != null && i == testSpec.literalPos).collect(Collectors.toList());
        callContextMock.argumentValues = IntStream.range(0, actualArgumentTypes.size()).mapToObj(i -> testSpec.literalPos != null && i == testSpec.literalPos ? Optional.ofNullable(testSpec.literalValue) : Optional.empty()).collect(Collectors.toList());
        callContextMock.argumentNulls = IntStream.range(0, actualArgumentTypes.size()).mapToObj(i -> false).collect(Collectors.toList());
        callContextMock.name = "f";
        callContextMock.outputDataType = Optional.empty();
        if (testSpec.surroundingStrategy != null) {
            TypeInference outerTypeInference = TypeInference.newBuilder().inputTypeStrategy(testSpec.surroundingStrategy).outputTypeStrategy(TypeStrategies.MISSING).build();
            surroundingInfo = TypeInferenceUtil.SurroundingInfo.of((String)"f_outer", (FunctionDefinition)functionDefinitionMock, (TypeInference)outerTypeInference, (int)1, (int)0, (boolean)callContextMock.isGroupedAggregation);
        } else {
            surroundingInfo = null;
        }
        return TypeInferenceUtil.runTypeInference((TypeInference)this.createTypeInference(testSpec), (CallContext)callContextMock, surroundingInfo);
    }

    private TypeInference createTypeInference(TestSpec testSpec) {
        TypeInference.Builder builder = TypeInference.newBuilder().inputTypeStrategy(testSpec.strategy).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.BOOLEAN()));
        if (testSpec.namedArguments != null) {
            builder.namedArguments(testSpec.namedArguments);
        }
        if (testSpec.typedArguments != null) {
            builder.typedArguments(testSpec.typedArguments);
        }
        return builder.build();
    }

    protected static class TestSpec {
        @Nullable
        private final String description;
        private final InputTypeStrategy strategy;
        @Nullable
        private List<String> namedArguments;
        @Nullable
        private List<DataType> typedArguments;
        private List<List<DataType>> actualArgumentTypes = new ArrayList<List<DataType>>();
        @Nullable
        private Integer literalPos;
        @Nullable
        private Object literalValue;
        @Nullable
        private InputTypeStrategy surroundingStrategy;
        @Nullable
        private String expectedSignature;
        @Nullable
        private List<DataType> expectedArgumentTypes;
        @Nullable
        private String expectedErrorMessage;

        private TestSpec(@Nullable String description, InputTypeStrategy strategy) {
            this.description = description;
            this.strategy = strategy;
        }

        public static TestSpec forStrategy(InputTypeStrategy strategy) {
            return new TestSpec(null, strategy);
        }

        public static TestSpec forStrategy(String description, InputTypeStrategy strategy) {
            return new TestSpec(description, strategy);
        }

        public TestSpec namedArguments(String ... names) {
            this.namedArguments = Arrays.asList(names);
            return this;
        }

        public TestSpec typedArguments(DataType ... dataTypes) {
            this.typedArguments = Arrays.asList(dataTypes);
            return this;
        }

        public TestSpec surroundingStrategy(InputTypeStrategy surroundingStrategy) {
            this.surroundingStrategy = surroundingStrategy;
            return this;
        }

        public TestSpec calledWithArgumentTypes(AbstractDataType<?> ... dataTypes) {
            this.actualArgumentTypes.add(this.resolveDataTypes(dataTypes));
            return this;
        }

        public TestSpec calledWithLiteralAt(int pos) {
            this.literalPos = pos;
            return this;
        }

        public TestSpec calledWithLiteralAt(int pos, Object value) {
            this.literalPos = pos;
            this.literalValue = value;
            return this;
        }

        public TestSpec expectSignature(String signature) {
            this.expectedSignature = signature;
            return this;
        }

        public TestSpec expectArgumentTypes(AbstractDataType<?> ... dataTypes) {
            this.expectedArgumentTypes = this.resolveDataTypes(dataTypes);
            return this;
        }

        public TestSpec expectErrorMessage(String expectedErrorMessage) {
            this.expectedErrorMessage = expectedErrorMessage;
            return this;
        }

        private List<DataType> resolveDataTypes(AbstractDataType<?>[] dataTypes) {
            DataTypeFactoryMock factoryMock = new DataTypeFactoryMock();
            return Arrays.stream(dataTypes).map(factoryMock::createDataType).collect(Collectors.toList());
        }

        public String toString() {
            return this.description != null ? this.description : this.strategy.getClass().getSimpleName();
        }
    }
}

