/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.annotation.FunctionHints;
import org.apache.flink.table.annotation.InputGroup;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.TypeInferenceExtractor;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;
import org.apache.flink.types.Row;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class TypeInferenceExtractorTest {
    TypeInferenceExtractorTest() {
    }

    private static Stream<TestSpec> testData() {
        return Stream.of(TestSpec.forScalarFunction(FullFunctionHint.class).expectNamedArguments("i", "s").expectTypedArguments(DataTypes.INT(), DataTypes.STRING()).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i", "s"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), TypeStrategies.explicit((DataType)DataTypes.BOOLEAN())), TestSpec.forScalarFunction(FullFunctionHints.class).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.BIGINT())), TestSpec.forScalarFunction(GlobalOutputFunctionHint.class).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forScalarFunction(InvalidSingleOutputFunctionHint.class).expectErrorMessage("Function hints that lead to ambiguous results are not allowed."), TestSpec.forScalarFunction(SplitFullFunctionHints.class).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.BIGINT())), TestSpec.forScalarFunction(InvalidFullOutputFunctionHint.class).expectErrorMessage("Function hints with same input definition but different result types are not allowed."), TestSpec.forScalarFunction(InvalidFullOutputFunctionWithArgNamesHint.class).expectErrorMessage("Function hints with same input definition but different result types are not allowed."), TestSpec.forScalarFunction(IncompleteFunctionHint.class).expectErrorMessage("Data type hint does neither specify a data type nor input group for use as function argument."), TestSpec.forScalarFunction(ComplexFunctionHint.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"myInt", "myAny"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), InputTypeStrategies.ANY}), TypeStrategies.explicit((DataType)DataTypes.BOOLEAN())), TestSpec.forScalarFunction(GlobalInputFunctionHints.class).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forScalarFunction(ZeroArgFunction.class).expectNamedArguments(new String[0]).expectTypedArguments(new DataType[0]).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[0], (ArgumentTypeStrategy[])new ArgumentTypeStrategy[0]), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forScalarFunction(MixedArgFunction.class).expectNamedArguments("i", "d").expectTypedArguments((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE), DataTypes.DOUBLE()).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i", "d"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), InputTypeStrategies.explicit((DataType)DataTypes.DOUBLE())}), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forScalarFunction(OverloadedFunction.class).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i", "d"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), InputTypeStrategies.explicit((DataType)DataTypes.DOUBLE())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"s"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.BIGINT().notNull()).bridgedTo(Long.TYPE)))), TestSpec.forScalarFunction(VarArgFunction.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"i", "more"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forScalarFunction(VarArgWithByteFunction.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"bytes"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.TINYINT().notNull()).bridgedTo(Byte.TYPE)))}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forScalarFunction(ExtractWithOutputHintFunction.class).expectNamedArguments("i").expectTypedArguments(DataTypes.INT()).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forScalarFunction(ExtractWithInputHintFunction.class).expectNamedArguments("i", "b").expectTypedArguments(DataTypes.INT(), DataTypes.BOOLEAN()).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i", "b"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN())}), TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.DOUBLE().notNull()).bridgedTo(Double.TYPE)))), TestSpec.forAggregateFunction(InputDependentAccumulatorFunction.class).expectAccumulatorMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f", (DataType)DataTypes.BIGINT())}))).expectAccumulatorMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f", (DataType)DataTypes.STRING())}))).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.STRING())).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forAggregateFunction(AggregateFunctionWithManyAnnotations.class).expectNamedArguments("r").expectTypedArguments(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN())})).expectAccumulatorMapping(InputTypeStrategies.sequence((String[])new String[]{"r"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN())}))}), TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN())}))).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"r"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN())}))}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forTableFunction(OutputHintTableFunction.class).expectNamedArguments("i").expectTypedArguments((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))}), TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN())}))), TestSpec.forScalarFunction(InvalidMethodScalarFunction.class).expectErrorMessage("Considering all hints, the method should comply with the signature:\njava.lang.String eval(int[])"), TestSpec.forAggregateFunction(InvalidMethodAggregateFunction.class).expectErrorMessage("Considering all hints, the method should comply with the signature:\naccumulate(java.lang.Integer, int, boolean)"), TestSpec.forTableFunction(MissingMethodTableFunction.class).expectErrorMessage("Could not find a publicly accessible method named 'eval'."), TestSpec.forScalarFunction(NamedArgumentsScalarFunction.class).expectNamedArguments("n"), TestSpec.forScalarFunction(InputGroupScalarFunction.class).expectNamedArguments("o").expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"o"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.ANY}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forScalarFunction(VarArgInputGroupScalarFunction.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"o"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.ANY}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forScalarFunction("Scalar function with implicit overloading order", OrderedScalarFunction.class).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"l"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.BIGINT())), TestSpec.forScalarFunction("Scalar function with explicit overloading order by class annotations", OrderedScalarFunction2.class).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.BIGINT())).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forScalarFunction("Scalar function with explicit overloading order by method annotations", OrderedScalarFunction3.class).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.BIGINT())).expectOutputMapping(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forTableFunction("A data type hint on the class is used instead of a function output hint", DataTypeHintOnTableFunctionClass.class).expectNamedArguments(new String[0]).expectTypedArguments(new DataType[0]).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[0], (ArgumentTypeStrategy[])new ArgumentTypeStrategy[0]), TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT())}))), TestSpec.forTableFunction("A data type hint on the method is used instead of a function output hint", DataTypeHintOnTableFunctionMethod.class).expectNamedArguments("i").expectTypedArguments(DataTypes.INT()).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT())}))), TestSpec.forTableFunction("Invalid data type hint on top of method and class", InvalidDataTypeHintOnTableFunction.class).expectErrorMessage("More than one data type hint found for output of function. Please use a function hint instead."), TestSpec.forScalarFunction("A data type hint on the method is used for enriching (not a function output hint)", DataTypeHintOnScalarFunction.class).expectNamedArguments(new String[0]).expectTypedArguments(new DataType[0]).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[0], (ArgumentTypeStrategy[])new ArgumentTypeStrategy[0]), TypeStrategies.explicit((DataType)((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT())}).bridgedTo(RowData.class)))));
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testArgumentNames(TestSpec testSpec) {
        if (testSpec.expectedArgumentNames != null) {
            Assertions.assertThat((Optional)testSpec.typeInferenceExtraction.get().getNamedArguments()).isEqualTo(Optional.of(testSpec.expectedArgumentNames));
        } else if (testSpec.expectedErrorMessage == null) {
            Assertions.assertThat((Optional)testSpec.typeInferenceExtraction.get().getNamedArguments()).isEqualTo(Optional.empty());
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testArgumentTypes(TestSpec testSpec) {
        if (testSpec.expectedArgumentTypes != null) {
            Assertions.assertThat((Optional)testSpec.typeInferenceExtraction.get().getTypedArguments()).isEqualTo(Optional.of(testSpec.expectedArgumentTypes));
        } else if (testSpec.expectedErrorMessage == null) {
            Assertions.assertThat((Optional)testSpec.typeInferenceExtraction.get().getTypedArguments()).isEqualTo(Optional.empty());
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testInputTypeStrategy(TestSpec testSpec) {
        if (!testSpec.expectedOutputStrategies.isEmpty()) {
            Assertions.assertThat((Object)testSpec.typeInferenceExtraction.get().getInputTypeStrategy()).isEqualTo(testSpec.expectedOutputStrategies.keySet().stream().reduce((xva$0, xva$1) -> InputTypeStrategies.or((InputTypeStrategy[])new InputTypeStrategy[]{xva$0, xva$1})).orElseThrow(AssertionError::new));
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testAccumulatorTypeStrategy(TestSpec testSpec) {
        if (!testSpec.expectedAccumulatorStrategies.isEmpty()) {
            Assertions.assertThat((boolean)testSpec.typeInferenceExtraction.get().getAccumulatorTypeStrategy().isPresent()).isEqualTo(true);
            Assertions.assertThat(testSpec.typeInferenceExtraction.get().getAccumulatorTypeStrategy().get()).isEqualTo((Object)TypeStrategies.mapping(testSpec.expectedAccumulatorStrategies));
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testOutputTypeStrategy(TestSpec testSpec) {
        if (!testSpec.expectedOutputStrategies.isEmpty()) {
            Assertions.assertThat((Object)testSpec.typeInferenceExtraction.get().getOutputTypeStrategy()).isEqualTo((Object)TypeStrategies.mapping(testSpec.expectedOutputStrategies));
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testErrorMessage(TestSpec testSpec) {
        if (testSpec.expectedErrorMessage != null) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(testSpec.typeInferenceExtraction::get).isInstanceOf(ValidationException.class)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)testSpec.expectedErrorMessage)});
        } else {
            testSpec.typeInferenceExtraction.get();
        }
    }

    private static class DataTypeHintOnScalarFunction
    extends ScalarFunction {
        private DataTypeHintOnScalarFunction() {
        }

        @DataTypeHint(value="ROW<i INT>")
        public RowData eval() {
            return null;
        }
    }

    @DataTypeHint(value="ROW<i BOOLEAN>")
    private static class InvalidDataTypeHintOnTableFunction
    extends TableFunction<Row> {
        private InvalidDataTypeHintOnTableFunction() {
        }

        @DataTypeHint(value="ROW<i INT>")
        public void eval(Integer i) {
        }
    }

    private static class DataTypeHintOnTableFunctionMethod
    extends TableFunction<Row> {
        private DataTypeHintOnTableFunctionMethod() {
        }

        @DataTypeHint(value="ROW<i INT>")
        public void eval(Integer i) {
        }
    }

    @DataTypeHint(value="ROW<i INT>")
    private static class DataTypeHintOnTableFunctionClass
    extends TableFunction<Row> {
        private DataTypeHintOnTableFunctionClass() {
        }

        public void eval() {
        }
    }

    private static class OrderedScalarFunction3
    extends ScalarFunction {
        private OrderedScalarFunction3() {
        }

        @FunctionHints(value={@FunctionHint(input={@DataTypeHint(value="BIGINT")}, output=@DataTypeHint(value="BIGINT")), @FunctionHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT"))})
        public Number eval(Number n) {
            return n;
        }
    }

    @FunctionHints(value={@FunctionHint(input={@DataTypeHint(value="BIGINT")}, output=@DataTypeHint(value="BIGINT")), @FunctionHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT"))})
    private static class OrderedScalarFunction2
    extends ScalarFunction {
        private OrderedScalarFunction2() {
        }

        public Number eval(Number n) {
            return n;
        }
    }

    private static class OrderedScalarFunction
    extends ScalarFunction {
        private OrderedScalarFunction() {
        }

        public Long eval(Long l) {
            return l;
        }

        public Integer eval(Integer i) {
            return i;
        }
    }

    private static class VarArgInputGroupScalarFunction
    extends ScalarFunction {
        private VarArgInputGroupScalarFunction() {
        }

        public String eval(Object ... o) {
            return Arrays.toString(o);
        }
    }

    private static class InputGroupScalarFunction
    extends ScalarFunction {
        private InputGroupScalarFunction() {
        }

        public String eval(@DataTypeHint(inputGroup=InputGroup.ANY) Object o) {
            return o.toString();
        }
    }

    private static class NamedArgumentsScalarFunction
    extends ScalarFunction {
        private NamedArgumentsScalarFunction() {
        }

        public Integer eval(int n) {
            return null;
        }

        public Integer eval(long n) {
            return null;
        }

        public Integer eval(@DataTypeHint(value="DECIMAL(10, 2)") Object n) {
            return null;
        }
    }

    private static class MissingMethodTableFunction
    extends TableFunction<String> {
        private MissingMethodTableFunction() {
        }
    }

    @FunctionHint(accumulator=@DataTypeHint(value="INT"))
    private static class InvalidMethodAggregateFunction
    extends AggregateFunction<String, Boolean> {
        private InvalidMethodAggregateFunction() {
        }

        public void accumulate(Boolean acc, int a, boolean b) {
        }

        public String getValue(Boolean accumulator) {
            return null;
        }

        public Boolean createAccumulator() {
            return null;
        }
    }

    @FunctionHint(output=@DataTypeHint(value="STRING"))
    private static class InvalidMethodScalarFunction
    extends ScalarFunction {
        private InvalidMethodScalarFunction() {
        }

        public Long eval(int[] i) {
            return null;
        }
    }

    @FunctionHint(output=@DataTypeHint(value="ROW<i INT, b BOOLEAN>"))
    private static class OutputHintTableFunction
    extends TableFunction<Row> {
        private OutputHintTableFunction() {
        }

        public void eval(int i) {
        }
    }

    @FunctionHint(output=@DataTypeHint(value="STRING"))
    private static class AggregateFunctionWithManyAnnotations
    extends AggregateFunction<String, Row> {
        private AggregateFunctionWithManyAnnotations() {
        }

        @FunctionHint(accumulator=@DataTypeHint(value="ROW<b BOOLEAN>"))
        public void accumulate(Row accumulator, @DataTypeHint(value="ROW<i INT, b BOOLEAN>") Row r) {
        }

        public String getValue(Row accumulator) {
            return null;
        }

        public Row createAccumulator() {
            return null;
        }
    }

    @FunctionHints(value={@FunctionHint(input={@DataTypeHint(value="BIGINT")}, accumulator=@DataTypeHint(value="ROW<f BIGINT>")), @FunctionHint(input={@DataTypeHint(value="STRING")}, accumulator=@DataTypeHint(value="ROW<f STRING>"))})
    private static class InputDependentAccumulatorFunction
    extends AggregateFunction<String, Row> {
        private InputDependentAccumulatorFunction() {
        }

        public void accumulate(Row accumulator, Object o) {
        }

        public String getValue(Row accumulator) {
            return null;
        }

        public Row createAccumulator() {
            return null;
        }
    }

    @FunctionHint(input={@DataTypeHint(value="INT"), @DataTypeHint(value="BOOLEAN")}, argumentNames={"i", "b"})
    private static class ExtractWithInputHintFunction
    extends ScalarFunction {
        private ExtractWithInputHintFunction() {
        }

        public double eval(Object ... o) {
            return 0.0;
        }
    }

    @FunctionHint(output=@DataTypeHint(value="INT"))
    private static class ExtractWithOutputHintFunction
    extends ScalarFunction {
        private ExtractWithOutputHintFunction() {
        }

        public Object eval(Integer i) {
            return null;
        }
    }

    private static class VarArgWithByteFunction
    extends ScalarFunction {
        private VarArgWithByteFunction() {
        }

        public String eval(byte ... bytes) {
            return null;
        }
    }

    private static class VarArgFunction
    extends ScalarFunction {
        private VarArgFunction() {
        }

        public String eval(int i, int ... more) {
            return null;
        }
    }

    private static class OverloadedFunction
    extends ScalarFunction {
        private OverloadedFunction() {
        }

        public Integer eval(int i, Double d) {
            return null;
        }

        public long eval(String s) {
            return 0L;
        }
    }

    private static class MixedArgFunction
    extends ScalarFunction {
        private MixedArgFunction() {
        }

        public Integer eval(int i, Double d) {
            return null;
        }
    }

    private static class ZeroArgFunction
    extends ScalarFunction {
        private ZeroArgFunction() {
        }

        public Integer eval() {
            return null;
        }
    }

    @FunctionHints(value={@FunctionHint(input={@DataTypeHint(value="INT")}), @FunctionHint(input={@DataTypeHint(value="BIGINT")})})
    private static class GlobalInputFunctionHints
    extends ScalarFunction {
        private GlobalInputFunctionHints() {
        }

        @FunctionHint(output=@DataTypeHint(value="INT"))
        public Integer eval(Number n) {
            return null;
        }
    }

    @FunctionHint(input={@DataTypeHint(value="INT"), @DataTypeHint}, output=@DataTypeHint(value="BOOLEAN"))
    private static class IncompleteFunctionHint
    extends ScalarFunction {
        private IncompleteFunctionHint() {
        }

        public Boolean eval(Integer i1, Integer i2) {
            return null;
        }
    }

    @FunctionHint(input={@DataTypeHint(value="INT")})
    private static class InvalidLocalOutputFunctionHint
    extends ScalarFunction {
        private InvalidLocalOutputFunctionHint() {
        }

        @FunctionHint(output=@DataTypeHint(value="INT"))
        public Integer eval(Integer n) {
            return null;
        }

        @FunctionHint(output=@DataTypeHint(value="STRING"))
        public Integer eval(String n) {
            return null;
        }
    }

    @FunctionHint(input={@DataTypeHint(value="INT")}, argumentNames={"a"}, output=@DataTypeHint(value="INT"))
    private static class InvalidFullOutputFunctionWithArgNamesHint
    extends ScalarFunction {
        private InvalidFullOutputFunctionWithArgNamesHint() {
        }

        @FunctionHint(input={@DataTypeHint(value="INT")}, argumentNames={"b"}, output=@DataTypeHint(value="BIGINT"))
        public Number eval(Integer i) {
            return null;
        }
    }

    @FunctionHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT"))
    private static class InvalidFullOutputFunctionHint
    extends ScalarFunction {
        private InvalidFullOutputFunctionHint() {
        }

        @FunctionHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="BIGINT"))
        public Number eval(Integer i) {
            return null;
        }
    }

    @FunctionHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT"))
    private static class SplitFullFunctionHints
    extends ScalarFunction {
        private SplitFullFunctionHints() {
        }

        @FunctionHint(input={@DataTypeHint(value="BIGINT")}, output=@DataTypeHint(value="BIGINT"))
        public Number eval(Number n) {
            return null;
        }
    }

    @FunctionHint(output=@DataTypeHint(value="INT"))
    private static class InvalidSingleOutputFunctionHint
    extends ScalarFunction {
        private InvalidSingleOutputFunctionHint() {
        }

        @FunctionHint(output=@DataTypeHint(value="TINYINT"))
        public Integer eval(Number n) {
            return null;
        }
    }

    @FunctionHint(output=@DataTypeHint(value="INT"))
    private static class GlobalOutputFunctionHint
    extends ScalarFunction {
        private GlobalOutputFunctionHint() {
        }

        @FunctionHint(input={@DataTypeHint(value="INT")})
        public Integer eval(Integer n) {
            return null;
        }

        @FunctionHint(input={@DataTypeHint(value="STRING")})
        public Integer eval(String n) {
            return null;
        }
    }

    @FunctionHints(value={@FunctionHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT")), @FunctionHint(input={@DataTypeHint(value="BIGINT")}, output=@DataTypeHint(value="BIGINT"))})
    private static class FullFunctionHints
    extends ScalarFunction {
        private FullFunctionHints() {
        }

        public Number eval(Number n) {
            return null;
        }
    }

    private static class ComplexFunctionHint
    extends ScalarFunction {
        private ComplexFunctionHint() {
        }

        @FunctionHint(input={@DataTypeHint(value="ARRAY<INT>"), @DataTypeHint(inputGroup=InputGroup.ANY)}, argumentNames={"myInt", "myAny"}, output=@DataTypeHint(value="BOOLEAN"), isVarArgs=true)
        public Boolean eval(Object ... o) {
            return null;
        }
    }

    @FunctionHint(input={@DataTypeHint(value="INT"), @DataTypeHint(value="STRING")}, argumentNames={"i", "s"}, output=@DataTypeHint(value="BOOLEAN"))
    private static class FullFunctionHint
    extends ScalarFunction {
        private FullFunctionHint() {
        }

        public Boolean eval(Integer i, String s) {
            return null;
        }
    }

    static class TestSpec {
        private final String description;
        final Supplier<TypeInference> typeInferenceExtraction;
        @Nullable
        List<String> expectedArgumentNames;
        @Nullable
        List<DataType> expectedArgumentTypes;
        Map<InputTypeStrategy, TypeStrategy> expectedAccumulatorStrategies;
        Map<InputTypeStrategy, TypeStrategy> expectedOutputStrategies;
        @Nullable
        String expectedErrorMessage;

        private TestSpec(String description, Supplier<TypeInference> typeInferenceExtraction) {
            this.description = description;
            this.typeInferenceExtraction = typeInferenceExtraction;
            this.expectedAccumulatorStrategies = new LinkedHashMap<InputTypeStrategy, TypeStrategy>();
            this.expectedOutputStrategies = new LinkedHashMap<InputTypeStrategy, TypeStrategy>();
        }

        static TestSpec forScalarFunction(Class<? extends ScalarFunction> function) {
            return TestSpec.forScalarFunction(null, function);
        }

        static TestSpec forScalarFunction(String description, Class<? extends ScalarFunction> function) {
            return new TestSpec(description == null ? function.getSimpleName() : description, () -> TypeInferenceExtractor.forScalarFunction((DataTypeFactory)new DataTypeFactoryMock(), (Class)function));
        }

        static TestSpec forAggregateFunction(Class<? extends AggregateFunction<?, ?>> function) {
            return new TestSpec(function.getSimpleName(), () -> TypeInferenceExtractor.forAggregateFunction((DataTypeFactory)new DataTypeFactoryMock(), (Class)function));
        }

        static TestSpec forTableFunction(Class<? extends TableFunction<?>> function) {
            return TestSpec.forTableFunction(null, function);
        }

        static TestSpec forTableFunction(String description, Class<? extends TableFunction<?>> function) {
            return new TestSpec(description == null ? function.getSimpleName() : description, () -> TypeInferenceExtractor.forTableFunction((DataTypeFactory)new DataTypeFactoryMock(), (Class)function));
        }

        static TestSpec forTableAggregateFunction(Class<? extends TableAggregateFunction<?, ?>> function) {
            return new TestSpec(function.getSimpleName(), () -> TypeInferenceExtractor.forTableAggregateFunction((DataTypeFactory)new DataTypeFactoryMock(), (Class)function));
        }

        TestSpec expectNamedArguments(String ... expectedArgumentNames) {
            this.expectedArgumentNames = Arrays.asList(expectedArgumentNames);
            return this;
        }

        TestSpec expectTypedArguments(DataType ... expectedArgumentTypes) {
            this.expectedArgumentTypes = Arrays.asList(expectedArgumentTypes);
            return this;
        }

        TestSpec expectAccumulatorMapping(InputTypeStrategy validator, TypeStrategy accumulatorStrategy) {
            this.expectedAccumulatorStrategies.put(validator, accumulatorStrategy);
            return this;
        }

        TestSpec expectOutputMapping(InputTypeStrategy validator, TypeStrategy outputStrategy) {
            this.expectedOutputStrategies.put(validator, outputStrategy);
            return this;
        }

        TestSpec expectErrorMessage(String expectedErrorMessage) {
            this.expectedErrorMessage = expectedErrorMessage;
            return this;
        }

        public String toString() {
            return this.description;
        }
    }
}

