/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.List;
import java.util.Map;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBase;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBinary;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBoolean;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDate;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDouble;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataLong;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataString;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.catalog.stats.Date;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.plan.stats.TableStats;
import org.assertj.core.api.Assertions;

public class CatalogTestUtil {
    public static void checkEquals(CatalogTable t1, CatalogTable t2) {
        Assertions.assertThat((Comparable)t2.getTableKind()).isEqualTo((Object)t1.getTableKind());
        Assertions.assertThat((Object)t2.getSchema()).isEqualTo((Object)t1.getSchema());
        Assertions.assertThat((String)t2.getComment()).isEqualTo(t1.getComment());
        Assertions.assertThat((List)t2.getPartitionKeys()).isEqualTo((Object)t1.getPartitionKeys());
        Assertions.assertThat((boolean)t2.isPartitioned()).isEqualTo(t1.isPartitioned());
        if (CatalogTestUtil.isHiveTable(t1.getOptions())) {
            Assertions.assertThat((boolean)t2.getOptions().keySet().stream().noneMatch(k -> k.startsWith("flink."))).isTrue();
            Assertions.assertThat((boolean)t2.getOptions().entrySet().containsAll(t1.getOptions().entrySet())).isTrue();
        } else {
            Assertions.assertThat((Map)t2.getOptions()).isEqualTo((Object)t1.getOptions());
        }
    }

    public static void checkEquals(CatalogView v1, CatalogView v2) {
        Assertions.assertThat((Comparable)v2.getTableKind()).isEqualTo((Object)v1.getTableKind());
        Assertions.assertThat((Object)v1.getSchema()).isEqualTo((Object)v1.getSchema());
        Assertions.assertThat((String)v2.getComment()).isEqualTo(v1.getComment());
        Assertions.assertThat((String)v2.getOriginalQuery()).isEqualTo(v1.getOriginalQuery());
        Assertions.assertThat((String)v2.getExpandedQuery()).isEqualTo(v1.getExpandedQuery());
        if (CatalogTestUtil.isHiveTable(v1.getOptions())) {
            Assertions.assertThat((boolean)v2.getOptions().keySet().stream().noneMatch(k -> k.startsWith("flink."))).isTrue();
            Assertions.assertThat((boolean)v2.getOptions().entrySet().containsAll(v1.getOptions().entrySet())).isTrue();
        } else {
            Assertions.assertThat((Map)v2.getOptions()).isEqualTo((Object)v1.getOptions());
        }
    }

    public static void checkEquals(CatalogPartition p1, CatalogPartition p2) {
        Assertions.assertThat(p2.getClass()).isEqualTo(p1.getClass());
        Assertions.assertThat((String)p2.getComment()).isEqualTo(p1.getComment());
        if (CatalogTestUtil.isHiveTable(p1.getProperties())) {
            Assertions.assertThat((boolean)p2.getProperties().entrySet().containsAll(p1.getProperties().entrySet())).isTrue();
        } else {
            Assertions.assertThat((Map)p2.getProperties()).isEqualTo((Object)p1.getProperties());
        }
    }

    public static void checkEquals(TableStats ts1, TableStats ts2) {
        Assertions.assertThat((long)ts2.getRowCount()).isEqualTo(ts1.getRowCount());
        Assertions.assertThat((Map)ts2.getColumnStats()).hasSize(ts1.getColumnStats().size());
    }

    public static void checkEquals(CatalogDatabase d1, CatalogDatabase d2) {
        Assertions.assertThat(d2.getClass()).isEqualTo(d1.getClass());
        Assertions.assertThat((String)d2.getComment()).isEqualTo(d1.getComment());
        Assertions.assertThat((boolean)d2.getProperties().entrySet().containsAll(d1.getProperties().entrySet())).isTrue();
    }

    static void checkEquals(CatalogTableStatistics ts1, CatalogTableStatistics ts2) {
        Assertions.assertThat((long)ts2.getRowCount()).isEqualTo(ts1.getRowCount());
        Assertions.assertThat((int)ts2.getFileCount()).isEqualTo(ts1.getFileCount());
        Assertions.assertThat((long)ts2.getTotalSize()).isEqualTo(ts1.getTotalSize());
        Assertions.assertThat((long)ts2.getRawDataSize()).isEqualTo(ts1.getRawDataSize());
        Assertions.assertThat((Map)ts2.getProperties()).isEqualTo((Object)ts1.getProperties());
    }

    static void checkEquals(CatalogColumnStatistics cs1, CatalogColumnStatistics cs2) {
        CatalogTestUtil.checkEquals(cs1.getColumnStatisticsData(), cs2.getColumnStatisticsData());
        Assertions.assertThat((Map)cs2.getProperties()).isEqualTo((Object)cs1.getProperties());
    }

    private static void checkEquals(Map<String, CatalogColumnStatisticsDataBase> m1, Map<String, CatalogColumnStatisticsDataBase> m2) {
        Assertions.assertThat(m2).hasSize(m1.size());
        for (Map.Entry<String, CatalogColumnStatisticsDataBase> entry : m2.entrySet()) {
            Assertions.assertThat(m1).containsKey((Object)entry.getKey());
            CatalogTestUtil.checkEquals(m2.get(entry.getKey()), entry.getValue());
        }
    }

    private static void checkEquals(CatalogColumnStatisticsDataBase v1, CatalogColumnStatisticsDataBase v2) {
        Assertions.assertThat(v2.getClass()).isEqualTo(v1.getClass());
        if (v1 instanceof CatalogColumnStatisticsDataBoolean) {
            CatalogTestUtil.checkEquals((CatalogColumnStatisticsDataBoolean)v1, (CatalogColumnStatisticsDataBoolean)v2);
        } else if (v1 instanceof CatalogColumnStatisticsDataLong) {
            CatalogTestUtil.checkEquals((CatalogColumnStatisticsDataLong)v1, (CatalogColumnStatisticsDataLong)v2);
        } else if (v1 instanceof CatalogColumnStatisticsDataBinary) {
            CatalogTestUtil.checkEquals((CatalogColumnStatisticsDataBinary)v1, (CatalogColumnStatisticsDataBinary)v2);
        } else if (v1 instanceof CatalogColumnStatisticsDataDate) {
            CatalogTestUtil.checkEquals((CatalogColumnStatisticsDataDate)v1, (CatalogColumnStatisticsDataDate)v2);
        } else if (v1 instanceof CatalogColumnStatisticsDataString) {
            CatalogTestUtil.checkEquals((CatalogColumnStatisticsDataString)v1, (CatalogColumnStatisticsDataString)v2);
        } else if (v1 instanceof CatalogColumnStatisticsDataDouble) {
            CatalogTestUtil.checkEquals((CatalogColumnStatisticsDataDouble)v1, (CatalogColumnStatisticsDataDouble)v2);
        }
    }

    private static void checkEquals(CatalogColumnStatisticsDataBoolean v1, CatalogColumnStatisticsDataBoolean v2) {
        Assertions.assertThat((Long)v2.getFalseCount()).isEqualTo((Object)v1.getFalseCount());
        Assertions.assertThat((Long)v2.getTrueCount()).isEqualTo((Object)v1.getTrueCount());
        Assertions.assertThat((Long)v2.getNullCount()).isEqualTo((Object)v1.getNullCount());
        Assertions.assertThat((Map)v2.getProperties()).isEqualTo((Object)v1.getProperties());
    }

    private static void checkEquals(CatalogColumnStatisticsDataLong v1, CatalogColumnStatisticsDataLong v2) {
        Assertions.assertThat((Long)v2.getMin()).isEqualTo((Object)v1.getMin());
        Assertions.assertThat((Long)v2.getMax()).isEqualTo((Object)v1.getMax());
        Assertions.assertThat((Long)v2.getNdv()).isEqualTo((Object)v1.getNdv());
        Assertions.assertThat((Long)v2.getNullCount()).isEqualTo((Object)v1.getNullCount());
        Assertions.assertThat((Map)v2.getProperties()).isEqualTo((Object)v1.getProperties());
    }

    private static void checkEquals(CatalogColumnStatisticsDataDouble v1, CatalogColumnStatisticsDataDouble v2) {
        Assertions.assertThat((Double)v2.getMin()).isCloseTo(v1.getMin(), Assertions.within((Double)0.05));
        Assertions.assertThat((Double)v2.getMax()).isCloseTo(v1.getMax(), Assertions.within((Double)0.05));
        Assertions.assertThat((Long)v2.getNdv()).isEqualTo((Object)v1.getNdv());
        Assertions.assertThat((Long)v2.getNullCount()).isEqualTo((Object)v1.getNullCount());
        Assertions.assertThat((Map)v2.getProperties()).isEqualTo((Object)v1.getProperties());
    }

    private static void checkEquals(CatalogColumnStatisticsDataString v1, CatalogColumnStatisticsDataString v2) {
        Assertions.assertThat((Long)v2.getMaxLength()).isEqualTo((Object)v1.getMaxLength());
        Assertions.assertThat((Double)v2.getAvgLength()).isCloseTo(v1.getAvgLength(), Assertions.within((Double)0.05));
        Assertions.assertThat((Long)v2.getNdv()).isEqualTo((Object)v1.getNdv());
        Assertions.assertThat((Long)v2.getNullCount()).isEqualTo((Object)v1.getNullCount());
        Assertions.assertThat((Map)v2.getProperties()).isEqualTo((Object)v1.getProperties());
    }

    private static void checkEquals(CatalogColumnStatisticsDataBinary v1, CatalogColumnStatisticsDataBinary v2) {
        Assertions.assertThat((Long)v2.getMaxLength()).isEqualTo((Object)v1.getMaxLength());
        Assertions.assertThat((Double)v2.getAvgLength()).isCloseTo(v1.getAvgLength(), Assertions.within((Double)0.05));
        Assertions.assertThat((Long)v2.getNullCount()).isEqualTo((Object)v1.getNullCount());
        Assertions.assertThat((Map)v2.getProperties()).isEqualTo((Object)v1.getProperties());
    }

    private static void checkEquals(CatalogColumnStatisticsDataDate v1, CatalogColumnStatisticsDataDate v2) {
        CatalogTestUtil.checkEquals(v1.getMin(), v2.getMin());
        CatalogTestUtil.checkEquals(v1.getMax(), v2.getMax());
        Assertions.assertThat((Long)v2.getNdv()).isEqualTo((Object)v1.getNdv());
        Assertions.assertThat((Long)v2.getNullCount()).isEqualTo((Object)v1.getNullCount());
        Assertions.assertThat((Map)v2.getProperties()).isEqualTo((Object)v1.getProperties());
    }

    private static void checkEquals(Date v1, Date v2) {
        Assertions.assertThat((long)v2.getDaysSinceEpoch()).isEqualTo(v1.getDaysSinceEpoch());
    }

    private static boolean isHiveTable(Map<String, String> properties) {
        return "hive".equalsIgnoreCase(properties.get(FactoryUtil.CONNECTOR.key()));
    }
}

