/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TableSchemaUtilsTest {
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @Test
    public void testBuilderWithGivenSchema() {
        TableSchema oriSchema = TableSchema.builder().field("a", (DataType)DataTypes.INT().notNull()).field("b", DataTypes.STRING()).field("c", DataTypes.INT(), "a + 1").field("t", DataTypes.TIMESTAMP((int)3)).primaryKey("ct1", new String[]{"a"}).watermark("t", "t", DataTypes.TIMESTAMP((int)3)).build();
        TableSchema newSchema = TableSchemaUtils.builderWithGivenSchema((TableSchema)oriSchema).build();
        Assert.assertEquals((Object)oriSchema, (Object)newSchema);
    }

    @Test
    public void testDropConstraint() {
        TableSchema originalSchema = TableSchema.builder().field("a", (DataType)DataTypes.INT().notNull()).field("b", DataTypes.STRING()).field("c", DataTypes.INT(), "a + 1").field("t", DataTypes.TIMESTAMP((int)3)).primaryKey("ct1", new String[]{"a"}).watermark("t", "t", DataTypes.TIMESTAMP((int)3)).build();
        TableSchema newSchema = TableSchemaUtils.dropConstraint((TableSchema)originalSchema, (String)"ct1");
        TableSchema expectedSchema = TableSchema.builder().field("a", (DataType)DataTypes.INT().notNull()).field("b", DataTypes.STRING()).field("c", DataTypes.INT(), "a + 1").field("t", DataTypes.TIMESTAMP((int)3)).watermark("t", "t", DataTypes.TIMESTAMP((int)3)).build();
        Assert.assertEquals((Object)expectedSchema, (Object)newSchema);
        this.exceptionRule.expect(ValidationException.class);
        this.exceptionRule.expectMessage("Constraint ct2 to drop does not exist");
        TableSchemaUtils.dropConstraint((TableSchema)originalSchema, (String)"ct2");
    }

    @Test
    public void testInvalidProjectSchema() {
        TableSchema schema = TableSchema.builder().field("a", (DataType)DataTypes.INT().notNull()).field("b", DataTypes.STRING()).field("c", DataTypes.INT(), "a + 1").field("t", DataTypes.TIMESTAMP((int)3)).primaryKey("ct1", new String[]{"a"}).watermark("t", "t", DataTypes.TIMESTAMP((int)3)).build();
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage("Projection is only supported for physical columns.");
        int[][] projectedFields = new int[][]{{1}};
        TableSchemaUtils.projectSchema((TableSchema)schema, (int[][])projectedFields);
    }

    @Test
    public void testProjectSchema() {
        TableSchema schema = TableSchema.builder().field("a", (DataType)DataTypes.INT().notNull()).field("b", DataTypes.STRING()).field("t", DataTypes.TIMESTAMP((int)3)).primaryKey(new String[]{"a"}).watermark("t", "t", DataTypes.TIMESTAMP((int)3)).build();
        int[][] projectedFields = new int[][]{{2}, {0}};
        TableSchema projected = TableSchemaUtils.projectSchema((TableSchema)schema, (int[][])projectedFields);
        TableSchema expected = TableSchema.builder().field("t", DataTypes.TIMESTAMP((int)3)).field("a", (DataType)DataTypes.INT().notNull()).build();
        Assert.assertEquals((Object)expected, (Object)projected);
    }

    @Test
    public void testProjectSchemaWithNameConflict() {
        TableSchema schema = TableSchema.builder().field("a", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.STRING())})).field("f0", DataTypes.STRING()).build();
        int[][] projectedFields = new int[][]{{0, 0}, {1}};
        TableSchema projected = TableSchemaUtils.projectSchema((TableSchema)schema, (int[][])projectedFields);
        TableSchema expected = TableSchema.builder().field("a_f0", DataTypes.STRING()).field("f0", DataTypes.STRING()).build();
        Assert.assertEquals((Object)expected, (Object)projected);
    }
}

