/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.DescriptorValidator;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;
import org.junit.Test;

public abstract class DescriptorTestBase {
    protected abstract List<Descriptor> descriptors();

    protected abstract List<Map<String, String>> properties();

    protected abstract DescriptorValidator validator();

    @Test
    public void testValidation() {
        List<Descriptor> descriptors = this.descriptors();
        List<Map<String, String>> properties = this.properties();
        Preconditions.checkArgument((descriptors.size() == properties.size() ? 1 : 0) != 0);
        for (int i = 0; i < descriptors.size(); ++i) {
            this.verifyProperties(descriptors.get(i), properties.get(i));
        }
    }

    protected void verifyProperties(Descriptor descriptor, Map<String, String> expected) {
        Assert.assertEquals(expected, (Object)descriptor.toProperties());
        DescriptorProperties properties = new DescriptorProperties();
        properties.putProperties(expected);
        this.validator().validate(properties);
    }

    protected void addPropertyAndVerify(Descriptor descriptor, String property, String newValue) {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putProperties(descriptor.toProperties());
        DescriptorProperties copy = properties.withoutKeys(Collections.singletonList(property));
        copy.putString(property, newValue);
        this.validator().validate(copy);
    }

    protected void removePropertyAndVerify(Descriptor descriptor, String property) {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putProperties(descriptor.toProperties());
        DescriptorProperties copy = properties.withoutKeys(Collections.singletonList(property));
        this.validator().validate(copy);
    }
}

