/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeInferenceUtil;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.inference.utils.CallContextMock;
import org.apache.flink.table.types.inference.utils.FunctionDefinitionMock;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class InputTypeStrategiesTestBase {
    @Parameterized.Parameter
    public TestSpec testSpec;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testStrategy() {
        if (this.testSpec.expectedSignature != null) {
            Assert.assertThat((Object)this.generateSignature(), (Matcher)CoreMatchers.equalTo((Object)this.testSpec.expectedSignature));
        }
        if (this.testSpec.expectedErrorMessage != null) {
            this.thrown.expect(ValidationException.class);
            this.thrown.expectCause(FlinkMatchers.containsCause((Throwable)new ValidationException(this.testSpec.expectedErrorMessage)));
        }
        for (List actualArgumentTypes : this.testSpec.actualArgumentTypes) {
            TypeInferenceUtil.Result result = this.runTypeInference(actualArgumentTypes);
            if (this.testSpec.expectedArgumentTypes == null) continue;
            Assert.assertThat((Object)result.getExpectedArgumentTypes(), (Matcher)CoreMatchers.equalTo((Object)this.testSpec.expectedArgumentTypes));
        }
    }

    private String generateSignature() {
        FunctionDefinitionMock functionDefinitionMock = new FunctionDefinitionMock();
        functionDefinitionMock.functionKind = FunctionKind.SCALAR;
        return TypeInferenceUtil.generateSignature((TypeInference)this.createTypeInference(), (String)"f", (FunctionDefinition)functionDefinitionMock);
    }

    private TypeInferenceUtil.Result runTypeInference(List<DataType> actualArgumentTypes) {
        TypeInferenceUtil.SurroundingInfo surroundingInfo;
        FunctionDefinitionMock functionDefinitionMock = new FunctionDefinitionMock();
        functionDefinitionMock.functionKind = FunctionKind.SCALAR;
        CallContextMock callContextMock = new CallContextMock();
        callContextMock.typeFactory = new DataTypeFactoryMock();
        callContextMock.functionDefinition = functionDefinitionMock;
        callContextMock.argumentDataTypes = actualArgumentTypes;
        callContextMock.argumentLiterals = IntStream.range(0, actualArgumentTypes.size()).mapToObj(i -> this.testSpec.literalPos != null && i == this.testSpec.literalPos).collect(Collectors.toList());
        callContextMock.argumentValues = IntStream.range(0, actualArgumentTypes.size()).mapToObj(i -> this.testSpec.literalPos != null && i == this.testSpec.literalPos ? Optional.ofNullable(this.testSpec.literalValue) : Optional.empty()).collect(Collectors.toList());
        callContextMock.argumentNulls = IntStream.range(0, actualArgumentTypes.size()).mapToObj(i -> false).collect(Collectors.toList());
        callContextMock.name = "f";
        callContextMock.outputDataType = Optional.empty();
        if (this.testSpec.surroundingStrategy != null) {
            TypeInference outerTypeInference = TypeInference.newBuilder().inputTypeStrategy(this.testSpec.surroundingStrategy).outputTypeStrategy(TypeStrategies.MISSING).build();
            surroundingInfo = TypeInferenceUtil.SurroundingInfo.of((String)"f_outer", (FunctionDefinition)functionDefinitionMock, (TypeInference)outerTypeInference, (int)1, (int)0, (boolean)callContextMock.isGroupedAggregation);
        } else {
            surroundingInfo = null;
        }
        return TypeInferenceUtil.runTypeInference((TypeInference)this.createTypeInference(), (CallContext)callContextMock, surroundingInfo);
    }

    private TypeInference createTypeInference() {
        TypeInference.Builder builder = TypeInference.newBuilder().inputTypeStrategy(this.testSpec.strategy).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.BOOLEAN()));
        if (this.testSpec.namedArguments != null) {
            builder.namedArguments(this.testSpec.namedArguments);
        }
        if (this.testSpec.typedArguments != null) {
            builder.typedArguments(this.testSpec.typedArguments);
        }
        return builder.build();
    }

    protected static class TestSpec {
        @Nullable
        private final String description;
        private final InputTypeStrategy strategy;
        @Nullable
        private List<String> namedArguments;
        @Nullable
        private List<DataType> typedArguments;
        private List<List<DataType>> actualArgumentTypes = new ArrayList<List<DataType>>();
        @Nullable
        private Integer literalPos;
        @Nullable
        private Object literalValue;
        @Nullable
        private InputTypeStrategy surroundingStrategy;
        @Nullable
        private String expectedSignature;
        @Nullable
        private List<DataType> expectedArgumentTypes;
        @Nullable
        private String expectedErrorMessage;

        private TestSpec(@Nullable String description, InputTypeStrategy strategy) {
            this.description = description;
            this.strategy = strategy;
        }

        static TestSpec forStrategy(InputTypeStrategy strategy) {
            return new TestSpec(null, strategy);
        }

        static TestSpec forStrategy(String description, InputTypeStrategy strategy) {
            return new TestSpec(description, strategy);
        }

        TestSpec namedArguments(String ... names) {
            this.namedArguments = Arrays.asList(names);
            return this;
        }

        TestSpec typedArguments(DataType ... dataTypes) {
            this.typedArguments = Arrays.asList(dataTypes);
            return this;
        }

        TestSpec surroundingStrategy(InputTypeStrategy surroundingStrategy) {
            this.surroundingStrategy = surroundingStrategy;
            return this;
        }

        TestSpec calledWithArgumentTypes(AbstractDataType<?> ... dataTypes) {
            this.actualArgumentTypes.add(this.resolveDataTypes(dataTypes));
            return this;
        }

        TestSpec calledWithLiteralAt(int pos) {
            this.literalPos = pos;
            return this;
        }

        TestSpec calledWithLiteralAt(int pos, Object value) {
            this.literalPos = pos;
            this.literalValue = value;
            return this;
        }

        TestSpec expectSignature(String signature) {
            this.expectedSignature = signature;
            return this;
        }

        TestSpec expectArgumentTypes(AbstractDataType<?> ... dataTypes) {
            this.expectedArgumentTypes = this.resolveDataTypes(dataTypes);
            return this;
        }

        TestSpec expectErrorMessage(String expectedErrorMessage) {
            this.expectedErrorMessage = expectedErrorMessage;
            return this;
        }

        private List<DataType> resolveDataTypes(AbstractDataType<?>[] dataTypes) {
            DataTypeFactoryMock factoryMock = new DataTypeFactoryMock();
            return Arrays.stream(dataTypes).map(factoryMock::createDataType).collect(Collectors.toList());
        }

        public String toString() {
            return this.description != null ? this.description : this.strategy.getClass().getSimpleName();
        }
    }
}

