/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeVisitor;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.inference.TypeTransformation;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeDefaultVisitor;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;
import org.apache.flink.table.types.utils.DataTypeDefaultVisitor;
import org.apache.flink.table.types.utils.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;

@Internal
public final class DataTypeUtils {
    public static DataType projectRow(DataType dataType, int[][] indexPaths) {
        ArrayList<RowType.RowField> updatedFields = new ArrayList<RowType.RowField>();
        ArrayList<DataType> updatedChildren = new ArrayList<DataType>();
        HashSet<String> nameDomain = new HashSet<String>();
        int duplicateCount = 0;
        for (int[] indexPath : indexPaths) {
            DataType fieldType = dataType.getChildren().get(indexPath[0]);
            LogicalType fieldLogicalType = fieldType.getLogicalType();
            StringBuilder builder = new StringBuilder(((RowType)dataType.getLogicalType()).getFieldNames().get(indexPath[0]));
            for (int index = 1; index < indexPath.length; ++index) {
                Preconditions.checkArgument((boolean)LogicalTypeChecks.hasRoot(fieldLogicalType, LogicalTypeRoot.ROW), (Object)"Row data type expected.");
                RowType rowtype = (RowType)fieldLogicalType;
                builder.append("_").append(rowtype.getFieldNames().get(indexPath[index]));
                fieldLogicalType = rowtype.getFields().get(indexPath[index]).getType();
                fieldType = fieldType.getChildren().get(indexPath[index]);
            }
            String path = builder.toString();
            while (nameDomain.contains(path)) {
                path = builder.append("_$").append(duplicateCount++).toString();
            }
            updatedFields.add(new RowType.RowField(path, fieldLogicalType));
            updatedChildren.add(fieldType);
            nameDomain.add(path);
        }
        return new FieldsDataType(new RowType(dataType.getLogicalType().isNullable(), updatedFields), dataType.getConversionClass(), updatedChildren);
    }

    /*
     * Exception decompiling
     */
    public static DataType projectRow(DataType dataType, int[] indices) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static DataType stripRowPrefix(DataType dataType, String prefix) {
        Preconditions.checkArgument((boolean)LogicalTypeChecks.hasRoot(dataType.getLogicalType(), LogicalTypeRoot.ROW), (Object)"Row data type expected.");
        RowType rowType = (RowType)dataType.getLogicalType();
        List<String> newFieldNames = rowType.getFieldNames().stream().map(s -> {
            if (s.startsWith(prefix)) {
                return s.substring(prefix.length());
            }
            return s;
        }).collect(Collectors.toList());
        RowType newRowType = LogicalTypeUtils.renameRowFields(rowType, newFieldNames);
        return new FieldsDataType(newRowType, dataType.getConversionClass(), dataType.getChildren());
    }

    public static DataType appendRowFields(DataType dataType, List<DataTypes.Field> fields) {
        Preconditions.checkArgument((boolean)LogicalTypeChecks.hasRoot(dataType.getLogicalType(), LogicalTypeRoot.ROW), (Object)"Row data type expected.");
        if (fields.size() == 0) {
            return dataType;
        }
        RowType rowType = (RowType)dataType.getLogicalType();
        List<RowType.RowField> newFields = Stream.concat(rowType.getFields().stream(), fields.stream().map(f -> new RowType.RowField(f.getName(), f.getDataType().getLogicalType(), f.getDescription().orElse(null)))).collect(Collectors.toList());
        RowType newRowType = new RowType(rowType.isNullable(), newFields);
        List<DataType> newFieldDataTypes = Stream.concat(dataType.getChildren().stream(), fields.stream().map(DataTypes.Field::getDataType)).collect(Collectors.toList());
        return new FieldsDataType(newRowType, dataType.getConversionClass(), newFieldDataTypes);
    }

    public static DataType toInternalDataType(LogicalType logicalType) {
        DataType defaultDataType = TypeConversions.fromLogicalToDataType(logicalType);
        return DataTypeUtils.toInternalDataType(defaultDataType);
    }

    public static DataType toInternalDataType(DataType dataType) {
        return (DataType)dataType.bridgedTo(LogicalTypeUtils.toInternalConversionClass(dataType.getLogicalType()));
    }

    public static boolean isInternal(DataType dataType) {
        Class<?> clazz = ExtractionUtils.primitiveToWrapper(dataType.getConversionClass());
        return clazz == LogicalTypeUtils.toInternalConversionClass(dataType.getLogicalType());
    }

    public static DataType replaceLogicalType(DataType dataType, LogicalType replacement) {
        return (DataType)LogicalTypeDataTypeConverter.toDataType(replacement).bridgedTo(dataType.getConversionClass());
    }

    public static DataType removeTimeAttribute(DataType dataType) {
        LogicalType type = dataType.getLogicalType();
        if (LogicalTypeChecks.hasFamily(type, LogicalTypeFamily.TIMESTAMP)) {
            return DataTypeUtils.replaceLogicalType(dataType, LogicalTypeUtils.removeTimeAttributes(type));
        }
        return dataType;
    }

    public static DataType transform(DataType typeToTransform, TypeTransformation ... transformations) {
        return DataTypeUtils.transform(null, typeToTransform, transformations);
    }

    public static DataType transform(@Nullable DataTypeFactory factory, DataType typeToTransform, TypeTransformation ... transformations) {
        Preconditions.checkArgument((transformations.length > 0 ? 1 : 0) != 0, (Object)"transformations should not be empty.");
        DataType newType = typeToTransform;
        for (TypeTransformation transformation : transformations) {
            newType = newType.accept(new DataTypeTransformer(factory, transformation));
        }
        return newType;
    }

    public static ResolvedSchema expandCompositeTypeToSchema(DataType dataType) {
        if (dataType instanceof FieldsDataType) {
            return DataTypeUtils.expandCompositeType((FieldsDataType)dataType);
        }
        if (dataType.getLogicalType() instanceof LegacyTypeInformationType && dataType.getLogicalType().getTypeRoot() == LogicalTypeRoot.STRUCTURED_TYPE) {
            return DataTypeUtils.expandLegacyCompositeType(dataType);
        }
        throw new IllegalArgumentException("Expected a composite type");
    }

    public static Optional<DataType> getField(DataType compositeType, int index) {
        ResolvedSchema tableSchema = DataTypeUtils.expandCompositeTypeToSchema(compositeType);
        return tableSchema.getColumn(index).map(Column::getDataType);
    }

    public static Optional<DataType> getField(DataType compositeType, String name) {
        ResolvedSchema resolvedSchema = DataTypeUtils.expandCompositeTypeToSchema(compositeType);
        return resolvedSchema.getColumn(name).map(Column::getDataType);
    }

    public static List<DataType> flattenToDataTypes(DataType dataType) {
        LogicalType type = dataType.getLogicalType();
        if (LogicalTypeChecks.hasRoot(type, LogicalTypeRoot.DISTINCT_TYPE)) {
            return DataTypeUtils.flattenToDataTypes(dataType.getChildren().get(0));
        }
        if (LogicalTypeChecks.isCompositeType(type)) {
            return dataType.getChildren();
        }
        return Collections.singletonList(dataType);
    }

    public static List<String> flattenToNames(DataType dataType) {
        return DataTypeUtils.flattenToNames(dataType, Collections.emptyList());
    }

    public static List<String> flattenToNames(DataType dataType, List<String> existingNames) {
        LogicalType type = dataType.getLogicalType();
        if (LogicalTypeChecks.hasRoot(type, LogicalTypeRoot.DISTINCT_TYPE)) {
            return DataTypeUtils.flattenToNames(dataType.getChildren().get(0), existingNames);
        }
        if (LogicalTypeChecks.isCompositeType(type)) {
            return LogicalTypeChecks.getFieldNames(type);
        }
        return Collections.singletonList(LogicalTypeUtils.getAtomicName(existingNames));
    }

    public static void validateInputDataType(DataType dataType) {
        dataType.accept(DataTypeInputClassValidator.INSTANCE);
    }

    public static void validateOutputDataType(DataType dataType) {
        dataType.accept(DataTypeOutputClassValidator.INSTANCE);
    }

    public static DataType createProctimeDataType() {
        return new AtomicDataType(new LocalZonedTimestampType(true, TimestampKind.PROCTIME, 3));
    }

    private DataTypeUtils() {
    }

    private static ResolvedSchema expandCompositeType(FieldsDataType dataType) {
        final DataType[] fieldDataTypes = dataType.getChildren().toArray(new DataType[0]);
        return dataType.getLogicalType().accept(new LogicalTypeDefaultVisitor<ResolvedSchema>(){

            @Override
            public ResolvedSchema visit(RowType rowType) {
                return DataTypeUtils.expandCompositeType(rowType, fieldDataTypes);
            }

            @Override
            public ResolvedSchema visit(StructuredType structuredType) {
                return DataTypeUtils.expandCompositeType(structuredType, fieldDataTypes);
            }

            @Override
            public ResolvedSchema visit(DistinctType distinctType) {
                return distinctType.getSourceType().accept(this);
            }

            @Override
            protected ResolvedSchema defaultMethod(LogicalType logicalType) {
                throw new IllegalArgumentException("Expected a composite type");
            }
        });
    }

    private static ResolvedSchema expandLegacyCompositeType(DataType dataType) {
        CompositeType compositeType = (CompositeType)((LegacyTypeInformationType)dataType.getLogicalType()).getTypeInformation();
        String[] fieldNames = compositeType.getFieldNames();
        DataType[] fieldTypes = (DataType[])Arrays.stream(fieldNames).map(arg_0 -> ((CompositeType)compositeType).getTypeAt(arg_0)).map(TypeConversions::fromLegacyInfoToDataType).toArray(DataType[]::new);
        return ResolvedSchema.physical(fieldNames, fieldTypes);
    }

    private static ResolvedSchema expandCompositeType(LogicalType compositeType, DataType[] fieldDataTypes) {
        String[] fieldNames = LogicalTypeChecks.getFieldNames(compositeType).toArray(new String[0]);
        return ResolvedSchema.physical(fieldNames, fieldDataTypes);
    }

    private static /* synthetic */ int[][] lambda$projectRow$1(int x$0) {
        return new int[x$0][];
    }

    private static class DataTypeTransformer
    implements DataTypeVisitor<DataType> {
        @Nullable
        private final DataTypeFactory factory;
        private final TypeTransformation transformation;

        private DataTypeTransformer(@Nullable DataTypeFactory factory, TypeTransformation transformation) {
            this.factory = factory;
            this.transformation = transformation;
        }

        @Override
        public DataType visit(AtomicDataType atomicDataType) {
            return this.transformation.transform(this.factory, atomicDataType);
        }

        @Override
        public DataType visit(CollectionDataType collectionDataType) {
            LogicalType newLogicalType;
            DataType newElementType = collectionDataType.getElementDataType().accept(this);
            LogicalType logicalType = collectionDataType.getLogicalType();
            if (logicalType instanceof ArrayType) {
                newLogicalType = new ArrayType(logicalType.isNullable(), newElementType.getLogicalType());
            } else if (logicalType instanceof MultisetType) {
                newLogicalType = new MultisetType(logicalType.isNullable(), newElementType.getLogicalType());
            } else {
                throw new UnsupportedOperationException("Unsupported logical type : " + logicalType);
            }
            return this.transformation.transform(this.factory, new CollectionDataType(newLogicalType, collectionDataType.getConversionClass(), newElementType));
        }

        @Override
        public DataType visit(FieldsDataType fieldsDataType) {
            LogicalType newLogicalType;
            List<DataType> newDataTypes = fieldsDataType.getChildren().stream().map(dt -> dt.accept(this)).collect(Collectors.toList());
            LogicalType logicalType = fieldsDataType.getLogicalType();
            if (logicalType instanceof RowType) {
                List<RowType.RowField> oldFields = ((RowType)logicalType).getFields();
                List<RowType.RowField> newFields = IntStream.range(0, oldFields.size()).mapToObj(i -> new RowType.RowField(((RowType.RowField)oldFields.get(i)).getName(), ((DataType)newDataTypes.get(i)).getLogicalType(), ((RowType.RowField)oldFields.get(i)).getDescription().orElse(null))).collect(Collectors.toList());
                newLogicalType = new RowType(logicalType.isNullable(), newFields);
            } else if (logicalType instanceof StructuredType) {
                StructuredType structuredType = (StructuredType)logicalType;
                if (structuredType.getSuperType().isPresent()) {
                    throw new UnsupportedOperationException("Hierarchies of structured types are not supported yet.");
                }
                List<StructuredType.StructuredAttribute> oldAttributes = structuredType.getAttributes();
                List<StructuredType.StructuredAttribute> newAttributes = IntStream.range(0, oldAttributes.size()).mapToObj(i -> new StructuredType.StructuredAttribute(((StructuredType.StructuredAttribute)oldAttributes.get(i)).getName(), ((DataType)newDataTypes.get(i)).getLogicalType(), ((StructuredType.StructuredAttribute)oldAttributes.get(i)).getDescription().orElse(null))).collect(Collectors.toList());
                StructuredType.Builder builder = this.createStructuredBuilder(structuredType);
                builder.attributes(newAttributes);
                builder.setNullable(structuredType.isNullable());
                builder.setFinal(structuredType.isFinal());
                builder.setInstantiable(structuredType.isInstantiable());
                builder.comparision(structuredType.getComparision());
                structuredType.getDescription().ifPresent(builder::description);
                newLogicalType = builder.build();
            } else {
                throw new UnsupportedOperationException("Unsupported logical type : " + logicalType);
            }
            return this.transformation.transform(this.factory, new FieldsDataType(newLogicalType, fieldsDataType.getConversionClass(), newDataTypes));
        }

        @Override
        public DataType visit(KeyValueDataType keyValueDataType) {
            DataType newKeyType = keyValueDataType.getKeyDataType().accept(this);
            DataType newValueType = keyValueDataType.getValueDataType().accept(this);
            LogicalType logicalType = keyValueDataType.getLogicalType();
            if (!(logicalType instanceof MapType)) {
                throw new UnsupportedOperationException("Unsupported logical type : " + logicalType);
            }
            MapType newLogicalType = new MapType(logicalType.isNullable(), newKeyType.getLogicalType(), newValueType.getLogicalType());
            return this.transformation.transform(this.factory, new KeyValueDataType(newLogicalType, keyValueDataType.getConversionClass(), newKeyType, newValueType));
        }

        private StructuredType.Builder createStructuredBuilder(StructuredType structuredType) {
            Optional<ObjectIdentifier> identifier = structuredType.getObjectIdentifier();
            Optional<Class<?>> implementationClass = structuredType.getImplementationClass();
            if (identifier.isPresent() && implementationClass.isPresent()) {
                return StructuredType.newBuilder(identifier.get(), implementationClass.get());
            }
            if (identifier.isPresent()) {
                return StructuredType.newBuilder(identifier.get());
            }
            if (implementationClass.isPresent()) {
                return StructuredType.newBuilder(implementationClass.get());
            }
            throw new IllegalArgumentException("Invalid structured type.");
        }
    }

    private static class DataTypeOutputClassValidator
    extends DataTypeDefaultVisitor<Void> {
        private static final DataTypeOutputClassValidator INSTANCE = new DataTypeOutputClassValidator();

        private DataTypeOutputClassValidator() {
        }

        @Override
        protected Void defaultMethod(DataType dataType) {
            if (!dataType.getLogicalType().supportsOutputConversion(dataType.getConversionClass())) {
                throw new ValidationException(String.format("Data type '%s' does not support an output conversion to class '%s'.", dataType, dataType.getConversionClass().getName()));
            }
            dataType.getChildren().forEach(child -> child.accept(this));
            return null;
        }
    }

    private static class DataTypeInputClassValidator
    extends DataTypeDefaultVisitor<Void> {
        private static final DataTypeInputClassValidator INSTANCE = new DataTypeInputClassValidator();

        private DataTypeInputClassValidator() {
        }

        @Override
        protected Void defaultMethod(DataType dataType) {
            if (!dataType.getLogicalType().supportsInputConversion(dataType.getConversionClass())) {
                throw new ValidationException(String.format("Data type '%s' does not support an input conversion from class '%s'.", dataType, dataType.getConversionClass().getName()));
            }
            dataType.getChildren().forEach(child -> child.accept(this));
            return null;
        }
    }
}

