/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeDefaultVisitor;

@Internal
public final class LogicalTypeChecks {
    private static final TimestampKindExtractor TIMESTAMP_KIND_EXTRACTOR = new TimestampKindExtractor();
    private static final LengthExtractor LENGTH_EXTRACTOR = new LengthExtractor();
    private static final PrecisionExtractor PRECISION_EXTRACTOR = new PrecisionExtractor();
    private static final ScaleExtractor SCALE_EXTRACTOR = new ScaleExtractor();
    private static final YearPrecisionExtractor YEAR_PRECISION_EXTRACTOR = new YearPrecisionExtractor();
    private static final DayPrecisionExtractor DAY_PRECISION_EXTRACTOR = new DayPrecisionExtractor();
    private static final FractionalPrecisionExtractor FRACTIONAL_PRECISION_EXTRACTOR = new FractionalPrecisionExtractor();
    private static final SingleFieldIntervalExtractor SINGLE_FIELD_INTERVAL_EXTRACTOR = new SingleFieldIntervalExtractor();
    private static final FieldCountExtractor FIELD_COUNT_EXTRACTOR = new FieldCountExtractor();
    private static final FieldNamesExtractor FIELD_NAMES_EXTRACTOR = new FieldNamesExtractor();

    public static boolean hasRoot(LogicalType logicalType, LogicalTypeRoot typeRoot) {
        return logicalType.getTypeRoot() == typeRoot;
    }

    public static boolean hasNested(LogicalType logicalType, Predicate<LogicalType> predicate) {
        NestedTypeSearcher typeSearcher = new NestedTypeSearcher(predicate);
        return logicalType.accept(typeSearcher).isPresent();
    }

    public static boolean hasLegacyTypes(LogicalType logicalType) {
        return LogicalTypeChecks.hasNested(logicalType, t -> t instanceof LegacyTypeInformationType);
    }

    public static boolean hasFamily(LogicalType logicalType, LogicalTypeFamily family) {
        return logicalType.getTypeRoot().getFamilies().contains((Object)family);
    }

    public static boolean isTimeAttribute(LogicalType logicalType) {
        return logicalType.accept(TIMESTAMP_KIND_EXTRACTOR) != TimestampKind.REGULAR;
    }

    public static boolean isRowtimeAttribute(LogicalType logicalType) {
        return logicalType.accept(TIMESTAMP_KIND_EXTRACTOR) == TimestampKind.ROWTIME;
    }

    public static boolean isProctimeAttribute(LogicalType logicalType) {
        return logicalType.accept(TIMESTAMP_KIND_EXTRACTOR) == TimestampKind.PROCTIME;
    }

    public static boolean isCompositeType(LogicalType logicalType) {
        if (logicalType instanceof DistinctType) {
            return LogicalTypeChecks.isCompositeType(((DistinctType)logicalType).getSourceType());
        }
        LogicalTypeRoot typeRoot = logicalType.getTypeRoot();
        return typeRoot == LogicalTypeRoot.STRUCTURED_TYPE || typeRoot == LogicalTypeRoot.ROW;
    }

    public static int getLength(LogicalType logicalType) {
        return logicalType.accept(LENGTH_EXTRACTOR);
    }

    public static boolean hasLength(LogicalType logicalType, int length) {
        return LogicalTypeChecks.getLength(logicalType) == length;
    }

    public static int getPrecision(LogicalType logicalType) {
        return logicalType.accept(PRECISION_EXTRACTOR);
    }

    public static boolean hasPrecision(LogicalType logicalType, int precision) {
        return LogicalTypeChecks.getPrecision(logicalType) == precision;
    }

    public static int getScale(LogicalType logicalType) {
        return logicalType.accept(SCALE_EXTRACTOR);
    }

    public static boolean hasScale(LogicalType logicalType, int scale) {
        return LogicalTypeChecks.getScale(logicalType) == scale;
    }

    public static int getYearPrecision(LogicalType logicalType) {
        return logicalType.accept(YEAR_PRECISION_EXTRACTOR);
    }

    public static boolean hasYearPrecision(LogicalType logicalType, int yearPrecision) {
        return LogicalTypeChecks.getYearPrecision(logicalType) == yearPrecision;
    }

    public static int getDayPrecision(LogicalType logicalType) {
        return logicalType.accept(DAY_PRECISION_EXTRACTOR);
    }

    public static boolean hasDayPrecision(LogicalType logicalType, int yearPrecision) {
        return LogicalTypeChecks.getDayPrecision(logicalType) == yearPrecision;
    }

    public static int getFractionalPrecision(LogicalType logicalType) {
        return logicalType.accept(FRACTIONAL_PRECISION_EXTRACTOR);
    }

    public static boolean hasFractionalPrecision(LogicalType logicalType, int fractionalPrecision) {
        return LogicalTypeChecks.getFractionalPrecision(logicalType) == fractionalPrecision;
    }

    public static boolean isSingleFieldInterval(LogicalType logicalType) {
        return logicalType.accept(SINGLE_FIELD_INTERVAL_EXTRACTOR);
    }

    public static int getFieldCount(LogicalType logicalType) {
        return logicalType.accept(FIELD_COUNT_EXTRACTOR);
    }

    public static List<String> getFieldNames(LogicalType logicalType) {
        return logicalType.accept(FIELD_NAMES_EXTRACTOR);
    }

    public static List<LogicalType> getFieldTypes(LogicalType logicalType) {
        if (logicalType instanceof DistinctType) {
            return LogicalTypeChecks.getFieldTypes(((DistinctType)logicalType).getSourceType());
        }
        return logicalType.getChildren();
    }

    public static boolean hasWellDefinedString(LogicalType logicalType) {
        if (logicalType instanceof DistinctType) {
            return LogicalTypeChecks.hasWellDefinedString(((DistinctType)logicalType).getSourceType());
        }
        switch (logicalType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    private LogicalTypeChecks() {
    }

    private static class NestedTypeSearcher
    extends LogicalTypeDefaultVisitor<Optional<LogicalType>> {
        private final Predicate<LogicalType> predicate;

        private NestedTypeSearcher(Predicate<LogicalType> predicate) {
            this.predicate = predicate;
        }

        @Override
        protected Optional<LogicalType> defaultMethod(LogicalType logicalType) {
            if (this.predicate.test(logicalType)) {
                return Optional.of(logicalType);
            }
            for (LogicalType child : logicalType.getChildren()) {
                Optional<LogicalType> foundType = child.accept(this);
                if (!foundType.isPresent()) continue;
                return foundType;
            }
            return Optional.empty();
        }
    }

    private static class FieldNamesExtractor
    extends Extractor<List<String>> {
        private FieldNamesExtractor() {
        }

        @Override
        public List<String> visit(RowType rowType) {
            return rowType.getFieldNames();
        }

        @Override
        public List<String> visit(StructuredType structuredType) {
            ArrayList<String> fieldNames = new ArrayList<String>();
            structuredType.getSuperType().map(superType -> superType.accept(this)).ifPresent(fieldNames::addAll);
            structuredType.getAttributes().stream().map(StructuredType.StructuredAttribute::getName).forEach(fieldNames::add);
            return fieldNames;
        }

        @Override
        public List<String> visit(DistinctType distinctType) {
            return distinctType.getSourceType().accept(this);
        }

        @Override
        protected List<String> defaultMethod(LogicalType logicalType) {
            if (LogicalTypeChecks.hasRoot(logicalType, LogicalTypeRoot.STRUCTURED_TYPE)) {
                return Arrays.asList(((CompositeType)((LegacyTypeInformationType)logicalType).getTypeInformation()).getFieldNames());
            }
            return (List)super.defaultMethod(logicalType);
        }
    }

    private static class FieldCountExtractor
    extends Extractor<Integer> {
        private FieldCountExtractor() {
        }

        @Override
        public Integer visit(RowType rowType) {
            return rowType.getFieldCount();
        }

        @Override
        public Integer visit(StructuredType structuredType) {
            int fieldCount = 0;
            StructuredType currentType = structuredType;
            while (currentType != null) {
                fieldCount += currentType.getAttributes().size();
                currentType = currentType.getSuperType().orElse(null);
            }
            return fieldCount;
        }

        @Override
        public Integer visit(DistinctType distinctType) {
            return distinctType.getSourceType().accept(this);
        }

        @Override
        protected Integer defaultMethod(LogicalType logicalType) {
            if (LogicalTypeChecks.hasRoot(logicalType, LogicalTypeRoot.STRUCTURED_TYPE)) {
                return ((LegacyTypeInformationType)logicalType).getTypeInformation().getArity();
            }
            return 1;
        }
    }

    private static class SingleFieldIntervalExtractor
    extends Extractor<Boolean> {
        private SingleFieldIntervalExtractor() {
        }

        @Override
        public Boolean visit(YearMonthIntervalType yearMonthIntervalType) {
            switch (yearMonthIntervalType.getResolution()) {
                case YEAR: 
                case MONTH: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Boolean visit(DayTimeIntervalType dayTimeIntervalType) {
            switch (dayTimeIntervalType.getResolution()) {
                case DAY: 
                case HOUR: 
                case MINUTE: 
                case SECOND: {
                    return true;
                }
            }
            return false;
        }
    }

    private static class TimestampKindExtractor
    extends Extractor<TimestampKind> {
        private TimestampKindExtractor() {
        }

        @Override
        public TimestampKind visit(TimestampType timestampType) {
            return timestampType.getKind();
        }

        @Override
        public TimestampKind visit(ZonedTimestampType zonedTimestampType) {
            return zonedTimestampType.getKind();
        }

        @Override
        public TimestampKind visit(LocalZonedTimestampType localZonedTimestampType) {
            return localZonedTimestampType.getKind();
        }
    }

    private static class FractionalPrecisionExtractor
    extends Extractor<Integer> {
        private FractionalPrecisionExtractor() {
        }

        @Override
        public Integer visit(DayTimeIntervalType dayTimeIntervalType) {
            return dayTimeIntervalType.getFractionalPrecision();
        }
    }

    private static class DayPrecisionExtractor
    extends Extractor<Integer> {
        private DayPrecisionExtractor() {
        }

        @Override
        public Integer visit(DayTimeIntervalType dayTimeIntervalType) {
            return dayTimeIntervalType.getDayPrecision();
        }
    }

    private static class YearPrecisionExtractor
    extends Extractor<Integer> {
        private YearPrecisionExtractor() {
        }

        @Override
        public Integer visit(YearMonthIntervalType yearMonthIntervalType) {
            return yearMonthIntervalType.getYearPrecision();
        }
    }

    private static class ScaleExtractor
    extends Extractor<Integer> {
        private ScaleExtractor() {
        }

        @Override
        public Integer visit(DecimalType decimalType) {
            return decimalType.getScale();
        }

        @Override
        public Integer visit(TinyIntType tinyIntType) {
            return 0;
        }

        @Override
        public Integer visit(SmallIntType smallIntType) {
            return 0;
        }

        @Override
        public Integer visit(IntType intType) {
            return 0;
        }

        @Override
        public Integer visit(BigIntType bigIntType) {
            return 0;
        }
    }

    private static class PrecisionExtractor
    extends Extractor<Integer> {
        private PrecisionExtractor() {
        }

        @Override
        public Integer visit(DecimalType decimalType) {
            return decimalType.getPrecision();
        }

        @Override
        public Integer visit(TinyIntType tinyIntType) {
            return 3;
        }

        @Override
        public Integer visit(SmallIntType smallIntType) {
            return 5;
        }

        @Override
        public Integer visit(IntType intType) {
            return 10;
        }

        @Override
        public Integer visit(BigIntType bigIntType) {
            return 19;
        }

        @Override
        public Integer visit(FloatType floatType) {
            return 7;
        }

        @Override
        public Integer visit(DoubleType doubleType) {
            return 15;
        }

        @Override
        public Integer visit(TimeType timeType) {
            return timeType.getPrecision();
        }

        @Override
        public Integer visit(TimestampType timestampType) {
            return timestampType.getPrecision();
        }

        @Override
        public Integer visit(ZonedTimestampType zonedTimestampType) {
            return zonedTimestampType.getPrecision();
        }

        @Override
        public Integer visit(LocalZonedTimestampType localZonedTimestampType) {
            return localZonedTimestampType.getPrecision();
        }
    }

    private static class LengthExtractor
    extends Extractor<Integer> {
        private LengthExtractor() {
        }

        @Override
        public Integer visit(CharType charType) {
            return charType.getLength();
        }

        @Override
        public Integer visit(VarCharType varCharType) {
            return varCharType.getLength();
        }

        @Override
        public Integer visit(BinaryType binaryType) {
            return binaryType.getLength();
        }

        @Override
        public Integer visit(VarBinaryType varBinaryType) {
            return varBinaryType.getLength();
        }
    }

    private static class Extractor<T>
    extends LogicalTypeDefaultVisitor<T> {
        private Extractor() {
        }

        @Override
        protected T defaultMethod(LogicalType logicalType) {
            throw new IllegalArgumentException(String.format("Invalid use of extractor %s. Called on logical type: %s", this.getClass().getName(), logicalType));
        }
    }
}

