/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.tsextractors;

import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.ResolvedFieldReference;
import org.apache.flink.table.sources.tsextractors.TimestampExtractor;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public final class TimestampExtractorUtils {
    public static ResolvedFieldReference[] getAccessedFields(TimestampExtractor timestampExtractor, DataType physicalInputType, Function<String, String> nameRemapping) {
        Function<String, ResolvedFieldReference> fieldMapping;
        if (LogicalTypeChecks.isCompositeType(physicalInputType.getLogicalType())) {
            TableSchema schema = DataTypeUtils.expandCompositeTypeToSchema(physicalInputType);
            fieldMapping = arg -> TimestampExtractorUtils.mapToResolvedField(nameRemapping, schema, arg);
        } else {
            fieldMapping = arg -> new ResolvedFieldReference((String)arg, TypeConversions.fromDataTypeToLegacyInfo(physicalInputType), 0);
        }
        return TimestampExtractorUtils.getAccessedFields(timestampExtractor, fieldMapping);
    }

    private static ResolvedFieldReference[] getAccessedFields(TimestampExtractor timestampExtractor, Function<String, ResolvedFieldReference> fieldMapping) {
        return (ResolvedFieldReference[])Arrays.stream(timestampExtractor.getArgumentFields()).map(fieldMapping).toArray(ResolvedFieldReference[]::new);
    }

    private static ResolvedFieldReference mapToResolvedField(Function<String, String> nameRemapping, TableSchema schema, String arg) {
        String remappedName = nameRemapping.apply(arg);
        int idx = IntStream.range(0, schema.getFieldCount()).filter(i -> schema.getFieldName(i).get().equals(remappedName)).findFirst().orElseThrow(() -> new ValidationException(String.format("Field %s does not exist", remappedName)));
        TypeInformation<?> dataType = TypeConversions.fromDataTypeToLegacyInfo(schema.getTableColumn(idx).get().getType());
        return new ResolvedFieldReference(remappedName, dataType, idx);
    }

    private TimestampExtractorUtils() {
    }
}

