/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.utils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeVisitor;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.inference.TypeTransformation;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeDefaultVisitor;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;
import org.apache.flink.table.types.utils.LogicalTypeDataTypeConverter;
import org.apache.flink.util.Preconditions;

@Internal
public final class DataTypeUtils {
    public static boolean isInternal(DataType dataType) {
        Class<?> clazz = ExtractionUtils.primitiveToWrapper(dataType.getConversionClass());
        return clazz == LogicalTypeUtils.toInternalConversionClass(dataType.getLogicalType());
    }

    public static DataType replaceLogicalType(DataType dataType, LogicalType replacement) {
        return (DataType)LogicalTypeDataTypeConverter.toDataType(replacement).bridgedTo(dataType.getConversionClass());
    }

    public static DataType transform(DataType typeToTransform, TypeTransformation ... transformations) {
        Preconditions.checkArgument((transformations.length > 0 ? 1 : 0) != 0, (Object)"transformations should not be empty.");
        DataType newType = typeToTransform;
        for (TypeTransformation transformation : transformations) {
            newType = newType.accept(new DataTypeTransformer(transformation));
        }
        return newType;
    }

    public static TableSchema expandCompositeTypeToSchema(DataType dataType) {
        if (dataType instanceof FieldsDataType) {
            return DataTypeUtils.expandCompositeType((FieldsDataType)dataType);
        }
        if (dataType.getLogicalType() instanceof LegacyTypeInformationType && dataType.getLogicalType().getTypeRoot() == LogicalTypeRoot.STRUCTURED_TYPE) {
            return DataTypeUtils.expandLegacyCompositeType(dataType);
        }
        throw new IllegalArgumentException("Expected a composite type");
    }

    private DataTypeUtils() {
    }

    private static TableSchema expandCompositeType(FieldsDataType dataType) {
        final DataType[] fieldDataTypes = dataType.getChildren().toArray(new DataType[0]);
        return dataType.getLogicalType().accept(new LogicalTypeDefaultVisitor<TableSchema>(){

            @Override
            public TableSchema visit(RowType rowType) {
                return DataTypeUtils.expandCompositeType(rowType, fieldDataTypes);
            }

            @Override
            public TableSchema visit(StructuredType structuredType) {
                return DataTypeUtils.expandCompositeType(structuredType, fieldDataTypes);
            }

            @Override
            public TableSchema visit(DistinctType distinctType) {
                return distinctType.getSourceType().accept(this);
            }

            @Override
            protected TableSchema defaultMethod(LogicalType logicalType) {
                throw new IllegalArgumentException("Expected a composite type");
            }
        });
    }

    private static TableSchema expandLegacyCompositeType(DataType dataType) {
        CompositeType compositeType = (CompositeType)((LegacyTypeInformationType)dataType.getLogicalType()).getTypeInformation();
        String[] fieldNames = compositeType.getFieldNames();
        TypeInformation[] fieldTypes = (TypeInformation[])Arrays.stream(fieldNames).map(arg_0 -> ((CompositeType)compositeType).getTypeAt(arg_0)).toArray(TypeInformation[]::new);
        return new TableSchema(fieldNames, fieldTypes);
    }

    private static TableSchema expandCompositeType(LogicalType compositeType, DataType[] fieldDataTypes) {
        String[] fieldNames = LogicalTypeChecks.getFieldNames(compositeType).toArray(new String[0]);
        return TableSchema.builder().fields(fieldNames, fieldDataTypes).build();
    }

    private static class DataTypeTransformer
    implements DataTypeVisitor<DataType> {
        private final TypeTransformation transformation;

        private DataTypeTransformer(TypeTransformation transformation) {
            this.transformation = transformation;
        }

        @Override
        public DataType visit(AtomicDataType atomicDataType) {
            return this.transformation.transform(atomicDataType);
        }

        @Override
        public DataType visit(CollectionDataType collectionDataType) {
            LogicalType newLogicalType;
            DataType newElementType = collectionDataType.getElementDataType().accept(this);
            LogicalType logicalType = collectionDataType.getLogicalType();
            if (logicalType instanceof ArrayType) {
                newLogicalType = new ArrayType(logicalType.isNullable(), newElementType.getLogicalType());
            } else if (logicalType instanceof MultisetType) {
                newLogicalType = new MultisetType(logicalType.isNullable(), newElementType.getLogicalType());
            } else {
                throw new UnsupportedOperationException("Unsupported logical type : " + logicalType);
            }
            return this.transformation.transform(new CollectionDataType(newLogicalType, newElementType));
        }

        @Override
        public DataType visit(FieldsDataType fieldsDataType) {
            List<DataType> newFields = fieldsDataType.getChildren().stream().map(dt -> dt.accept(this)).collect(Collectors.toList());
            LogicalType logicalType = fieldsDataType.getLogicalType();
            if (!(logicalType instanceof RowType)) {
                throw new UnsupportedOperationException("Unsupported logical type : " + logicalType);
            }
            List<RowType.RowField> oldFields = ((RowType)logicalType).getFields();
            List<RowType.RowField> newRowFields = IntStream.range(0, oldFields.size()).mapToObj(i -> new RowType.RowField(((RowType.RowField)oldFields.get(i)).getName(), ((DataType)newFields.get(i)).getLogicalType(), ((RowType.RowField)oldFields.get(i)).getDescription().orElse(null))).collect(Collectors.toList());
            RowType newLogicalType = new RowType(logicalType.isNullable(), newRowFields);
            return this.transformation.transform(new FieldsDataType((LogicalType)newLogicalType, newFields));
        }

        @Override
        public DataType visit(KeyValueDataType keyValueDataType) {
            DataType newKeyType = keyValueDataType.getKeyDataType().accept(this);
            DataType newValueType = keyValueDataType.getValueDataType().accept(this);
            LogicalType logicalType = keyValueDataType.getLogicalType();
            if (!(logicalType instanceof MapType)) {
                throw new UnsupportedOperationException("Unsupported logical type : " + logicalType);
            }
            MapType newLogicalType = new MapType(logicalType.isNullable(), newKeyType.getLogicalType(), newValueType.getLogicalType());
            return this.transformation.transform(new KeyValueDataType(newLogicalType, newKeyType, newValueType));
        }
    }
}

