/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.TableSymbol;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class SymbolType<T extends TableSymbol>
extends LogicalType {
    private static final String FORMAT = "SYMBOL('%s')";
    private final Class<T> symbolClass;

    public SymbolType(boolean isNullable, Class<T> symbolClass) {
        super(isNullable, LogicalTypeRoot.SYMBOL);
        this.symbolClass = (Class)Preconditions.checkNotNull(symbolClass, (String)"Symbol class must not be null.");
    }

    public SymbolType(Class<T> symbolClass) {
        this(true, symbolClass);
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new SymbolType<T>(isNullable, this.symbolClass);
    }

    @Override
    public String asSummaryString() {
        return this.withNullability(FORMAT, this.symbolClass.getName());
    }

    @Override
    public String asSerializableString() {
        throw new TableException("A symbol type has no serializable string representation.");
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        return this.symbolClass.equals(clazz);
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        return this.symbolClass.equals(clazz);
    }

    @Override
    public Class<?> getDefaultConversion() {
        return this.symbolClass;
    }

    @Override
    public List<LogicalType> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SymbolType that = (SymbolType)o;
        return this.symbolClass.equals(that.symbolClass);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.symbolClass);
    }
}

