/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.types.logical.LogicalTypeFamily;

@PublicEvolving
public enum LogicalTypeRoot {
    CHAR(LogicalTypeFamily.PREDEFINED, LogicalTypeFamily.CHARACTER_STRING),
    VARCHAR(LogicalTypeFamily.PREDEFINED, LogicalTypeFamily.CHARACTER_STRING),
    BOOLEAN(LogicalTypeFamily.PREDEFINED, new LogicalTypeFamily[0]),
    BINARY(LogicalTypeFamily.PREDEFINED, LogicalTypeFamily.BINARY_STRING),
    VARBINARY(LogicalTypeFamily.PREDEFINED, LogicalTypeFamily.BINARY_STRING),
    DECIMAL(LogicalTypeFamily.PREDEFINED, LogicalTypeFamily.NUMERIC, LogicalTypeFamily.EXACT_NUMERIC),
    TINYINT(LogicalTypeFamily.PREDEFINED, LogicalTypeFamily.NUMERIC, LogicalTypeFamily.EXACT_NUMERIC),
    SMALLINT(LogicalTypeFamily.PREDEFINED, LogicalTypeFamily.NUMERIC, LogicalTypeFamily.EXACT_NUMERIC),
    INTEGER(LogicalTypeFamily.PREDEFINED, LogicalTypeFamily.NUMERIC, LogicalTypeFamily.EXACT_NUMERIC),
    BIGINT(LogicalTypeFamily.PREDEFINED, LogicalTypeFamily.NUMERIC, LogicalTypeFamily.EXACT_NUMERIC),
    FLOAT(LogicalTypeFamily.PREDEFINED, LogicalTypeFamily.NUMERIC, LogicalTypeFamily.APPROXIMATE_NUMERIC),
    DOUBLE(LogicalTypeFamily.PREDEFINED, LogicalTypeFamily.NUMERIC, LogicalTypeFamily.APPROXIMATE_NUMERIC),
    DATE(LogicalTypeFamily.PREDEFINED, LogicalTypeFamily.DATETIME),
    TIME_WITHOUT_TIME_ZONE(LogicalTypeFamily.PREDEFINED, LogicalTypeFamily.DATETIME, LogicalTypeFamily.TIME),
    TIMESTAMP_WITHOUT_TIME_ZONE(LogicalTypeFamily.PREDEFINED, LogicalTypeFamily.DATETIME, LogicalTypeFamily.TIMESTAMP),
    TIMESTAMP_WITH_TIME_ZONE(LogicalTypeFamily.PREDEFINED, LogicalTypeFamily.DATETIME, LogicalTypeFamily.TIMESTAMP),
    TIMESTAMP_WITH_LOCAL_TIME_ZONE(LogicalTypeFamily.PREDEFINED, LogicalTypeFamily.DATETIME, LogicalTypeFamily.TIMESTAMP, LogicalTypeFamily.EXTENSION),
    INTERVAL_YEAR_MONTH(LogicalTypeFamily.PREDEFINED, LogicalTypeFamily.INTERVAL),
    INTERVAL_DAY_TIME(LogicalTypeFamily.PREDEFINED, LogicalTypeFamily.INTERVAL),
    ARRAY(LogicalTypeFamily.CONSTRUCTED, LogicalTypeFamily.COLLECTION),
    MULTISET(LogicalTypeFamily.CONSTRUCTED, LogicalTypeFamily.COLLECTION),
    MAP(LogicalTypeFamily.CONSTRUCTED, LogicalTypeFamily.EXTENSION),
    ROW(LogicalTypeFamily.CONSTRUCTED, new LogicalTypeFamily[0]),
    DISTINCT_TYPE(LogicalTypeFamily.USER_DEFINED, new LogicalTypeFamily[0]),
    STRUCTURED_TYPE(LogicalTypeFamily.USER_DEFINED, new LogicalTypeFamily[0]),
    NULL(LogicalTypeFamily.EXTENSION, new LogicalTypeFamily[0]),
    RAW(LogicalTypeFamily.EXTENSION, new LogicalTypeFamily[0]),
    SYMBOL(LogicalTypeFamily.EXTENSION, new LogicalTypeFamily[0]),
    UNRESOLVED(LogicalTypeFamily.EXTENSION, new LogicalTypeFamily[0]);

    private final Set<LogicalTypeFamily> families;

    private LogicalTypeRoot(LogicalTypeFamily firstFamily, LogicalTypeFamily ... otherFamilies) {
        this.families = Collections.unmodifiableSet(EnumSet.of(firstFamily, otherFamilies));
    }

    public Set<LogicalTypeFamily> getFamilies() {
        return this.families;
    }
}

