/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class BuiltInFunctionDefinitions {
    public static final BuiltInFunctionDefinition AND = new BuiltInFunctionDefinition.Builder().name("and").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition OR = new BuiltInFunctionDefinition.Builder().name("or").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition NOT = new BuiltInFunctionDefinition.Builder().name("not").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition IF = new BuiltInFunctionDefinition.Builder().name("ifThenElse").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition EQUALS = new BuiltInFunctionDefinition.Builder().name("equals").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition GREATER_THAN = new BuiltInFunctionDefinition.Builder().name("greaterThan").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition GREATER_THAN_OR_EQUAL = new BuiltInFunctionDefinition.Builder().name("greaterThanOrEqual").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition LESS_THAN = new BuiltInFunctionDefinition.Builder().name("lessThan").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition LESS_THAN_OR_EQUAL = new BuiltInFunctionDefinition.Builder().name("lessThanOrEqual").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition NOT_EQUALS = new BuiltInFunctionDefinition.Builder().name("notEquals").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition IS_NULL = new BuiltInFunctionDefinition.Builder().name("isNull").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition IS_NOT_NULL = new BuiltInFunctionDefinition.Builder().name("isNotNull").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition IS_TRUE = new BuiltInFunctionDefinition.Builder().name("isTrue").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition IS_FALSE = new BuiltInFunctionDefinition.Builder().name("isFalse").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition IS_NOT_TRUE = new BuiltInFunctionDefinition.Builder().name("isNotTrue").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition IS_NOT_FALSE = new BuiltInFunctionDefinition.Builder().name("isNotFalse").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition BETWEEN = new BuiltInFunctionDefinition.Builder().name("between").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition NOT_BETWEEN = new BuiltInFunctionDefinition.Builder().name("notBetween").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition AVG = new BuiltInFunctionDefinition.Builder().name("avg").kind(FunctionKind.AGGREGATE).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition COUNT = new BuiltInFunctionDefinition.Builder().name("count").kind(FunctionKind.AGGREGATE).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition MAX = new BuiltInFunctionDefinition.Builder().name("max").kind(FunctionKind.AGGREGATE).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition MIN = new BuiltInFunctionDefinition.Builder().name("min").kind(FunctionKind.AGGREGATE).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition SUM = new BuiltInFunctionDefinition.Builder().name("sum").kind(FunctionKind.AGGREGATE).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition SUM0 = new BuiltInFunctionDefinition.Builder().name("sum0").kind(FunctionKind.AGGREGATE).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition STDDEV_POP = new BuiltInFunctionDefinition.Builder().name("stddevPop").kind(FunctionKind.AGGREGATE).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition STDDEV_SAMP = new BuiltInFunctionDefinition.Builder().name("stddevSamp").kind(FunctionKind.AGGREGATE).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition VAR_POP = new BuiltInFunctionDefinition.Builder().name("varPop").kind(FunctionKind.AGGREGATE).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition VAR_SAMP = new BuiltInFunctionDefinition.Builder().name("varSamp").kind(FunctionKind.AGGREGATE).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition COLLECT = new BuiltInFunctionDefinition.Builder().name("collect").kind(FunctionKind.AGGREGATE).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition DISTINCT = new BuiltInFunctionDefinition.Builder().name("distinct").kind(FunctionKind.AGGREGATE).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition CHAR_LENGTH = new BuiltInFunctionDefinition.Builder().name("charLength").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition INIT_CAP = new BuiltInFunctionDefinition.Builder().name("initCap").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition LIKE = new BuiltInFunctionDefinition.Builder().name("like").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition LOWER = new BuiltInFunctionDefinition.Builder().name("lower").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition LOWERCASE = new BuiltInFunctionDefinition.Builder().name("lowerCase").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition SIMILAR = new BuiltInFunctionDefinition.Builder().name("similar").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition SUBSTRING = new BuiltInFunctionDefinition.Builder().name("substring").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition REPLACE = new BuiltInFunctionDefinition.Builder().name("replace").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition TRIM = new BuiltInFunctionDefinition.Builder().name("trim").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition UPPER = new BuiltInFunctionDefinition.Builder().name("upper").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition UPPERCASE = new BuiltInFunctionDefinition.Builder().name("upperCase").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition POSITION = new BuiltInFunctionDefinition.Builder().name("position").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition OVERLAY = new BuiltInFunctionDefinition.Builder().name("overlay").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition CONCAT = new BuiltInFunctionDefinition.Builder().name("concat").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition CONCAT_WS = new BuiltInFunctionDefinition.Builder().name("concat_ws").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition LPAD = new BuiltInFunctionDefinition.Builder().name("lpad").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition RPAD = new BuiltInFunctionDefinition.Builder().name("rpad").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition REGEXP_EXTRACT = new BuiltInFunctionDefinition.Builder().name("regexpExtract").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition FROM_BASE64 = new BuiltInFunctionDefinition.Builder().name("fromBase64").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition TO_BASE64 = new BuiltInFunctionDefinition.Builder().name("toBase64").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition UUID = new BuiltInFunctionDefinition.Builder().name("uuid").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition LTRIM = new BuiltInFunctionDefinition.Builder().name("ltrim").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition RTRIM = new BuiltInFunctionDefinition.Builder().name("rtrim").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition REPEAT = new BuiltInFunctionDefinition.Builder().name("repeat").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition REGEXP_REPLACE = new BuiltInFunctionDefinition.Builder().name("regexpReplace").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition PLUS = new BuiltInFunctionDefinition.Builder().name("plus").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition MINUS = new BuiltInFunctionDefinition.Builder().name("minus").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition DIVIDE = new BuiltInFunctionDefinition.Builder().name("divide").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition TIMES = new BuiltInFunctionDefinition.Builder().name("times").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition ABS = new BuiltInFunctionDefinition.Builder().name("abs").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition CEIL = new BuiltInFunctionDefinition.Builder().name("ceil").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition EXP = new BuiltInFunctionDefinition.Builder().name("exp").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition FLOOR = new BuiltInFunctionDefinition.Builder().name("floor").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition LOG10 = new BuiltInFunctionDefinition.Builder().name("log10").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition LOG2 = new BuiltInFunctionDefinition.Builder().name("log2").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition LN = new BuiltInFunctionDefinition.Builder().name("ln").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition LOG = new BuiltInFunctionDefinition.Builder().name("log").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition POWER = new BuiltInFunctionDefinition.Builder().name("power").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition MOD = new BuiltInFunctionDefinition.Builder().name("mod").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition SQRT = new BuiltInFunctionDefinition.Builder().name("sqrt").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition MINUS_PREFIX = new BuiltInFunctionDefinition.Builder().name("minusPrefix").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition SIN = new BuiltInFunctionDefinition.Builder().name("sin").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition COS = new BuiltInFunctionDefinition.Builder().name("cos").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition SINH = new BuiltInFunctionDefinition.Builder().name("sinh").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition TAN = new BuiltInFunctionDefinition.Builder().name("tan").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition TANH = new BuiltInFunctionDefinition.Builder().name("tanh").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition COT = new BuiltInFunctionDefinition.Builder().name("cot").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition ASIN = new BuiltInFunctionDefinition.Builder().name("asin").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition ACOS = new BuiltInFunctionDefinition.Builder().name("acos").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition ATAN = new BuiltInFunctionDefinition.Builder().name("atan").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition ATAN2 = new BuiltInFunctionDefinition.Builder().name("atan2").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition COSH = new BuiltInFunctionDefinition.Builder().name("cosh").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition DEGREES = new BuiltInFunctionDefinition.Builder().name("degrees").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition RADIANS = new BuiltInFunctionDefinition.Builder().name("radians").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition SIGN = new BuiltInFunctionDefinition.Builder().name("sign").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition ROUND = new BuiltInFunctionDefinition.Builder().name("round").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition PI = new BuiltInFunctionDefinition.Builder().name("pi").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition E = new BuiltInFunctionDefinition.Builder().name("e").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition RAND = new BuiltInFunctionDefinition.Builder().name("rand").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition RAND_INTEGER = new BuiltInFunctionDefinition.Builder().name("randInteger").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition BIN = new BuiltInFunctionDefinition.Builder().name("bin").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition HEX = new BuiltInFunctionDefinition.Builder().name("hex").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition TRUNCATE = new BuiltInFunctionDefinition.Builder().name("truncate").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition EXTRACT = new BuiltInFunctionDefinition.Builder().name("extract").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition CURRENT_DATE = new BuiltInFunctionDefinition.Builder().name("currentDate").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition CURRENT_TIME = new BuiltInFunctionDefinition.Builder().name("currentTime").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition CURRENT_TIMESTAMP = new BuiltInFunctionDefinition.Builder().name("currentTimestamp").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition LOCAL_TIME = new BuiltInFunctionDefinition.Builder().name("localTime").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition LOCAL_TIMESTAMP = new BuiltInFunctionDefinition.Builder().name("localTimestamp").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition TEMPORAL_OVERLAPS = new BuiltInFunctionDefinition.Builder().name("temporalOverlaps").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition DATE_TIME_PLUS = new BuiltInFunctionDefinition.Builder().name("dateTimePlus").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition DATE_FORMAT = new BuiltInFunctionDefinition.Builder().name("dateFormat").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition TIMESTAMP_DIFF = new BuiltInFunctionDefinition.Builder().name("timestampDiff").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition AT = new BuiltInFunctionDefinition.Builder().name("at").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition CARDINALITY = new BuiltInFunctionDefinition.Builder().name("cardinality").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition ARRAY = new BuiltInFunctionDefinition.Builder().name("array").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.SPECIFIC_FOR_ARRAY).outputTypeStrategy(TypeStrategies.ARRAY).build();
    public static final BuiltInFunctionDefinition ARRAY_ELEMENT = new BuiltInFunctionDefinition.Builder().name("element").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition MAP = new BuiltInFunctionDefinition.Builder().name("map").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.SPECIFIC_FOR_MAP).outputTypeStrategy(TypeStrategies.MAP).build();
    public static final BuiltInFunctionDefinition ROW = new BuiltInFunctionDefinition.Builder().name("row").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.wildcardWithCount(ConstantArgumentCount.from(1))).outputTypeStrategy(TypeStrategies.ROW).build();
    public static final BuiltInFunctionDefinition FLATTEN = new BuiltInFunctionDefinition.Builder().name("flatten").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition GET = new BuiltInFunctionDefinition.Builder().name("get").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition WINDOW_START = new BuiltInFunctionDefinition.Builder().name("start").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition WINDOW_END = new BuiltInFunctionDefinition.Builder().name("end").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition ORDER_ASC = new BuiltInFunctionDefinition.Builder().name("asc").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition ORDER_DESC = new BuiltInFunctionDefinition.Builder().name("desc").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition MD5 = new BuiltInFunctionDefinition.Builder().name("md5").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition SHA1 = new BuiltInFunctionDefinition.Builder().name("sha1").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition SHA224 = new BuiltInFunctionDefinition.Builder().name("sha224").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition SHA256 = new BuiltInFunctionDefinition.Builder().name("sha256").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition SHA384 = new BuiltInFunctionDefinition.Builder().name("sha384").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition SHA512 = new BuiltInFunctionDefinition.Builder().name("sha512").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition SHA2 = new BuiltInFunctionDefinition.Builder().name("sha2").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition PROCTIME = new BuiltInFunctionDefinition.Builder().name("proctime").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition ROWTIME = new BuiltInFunctionDefinition.Builder().name("rowtime").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition OVER = new BuiltInFunctionDefinition.Builder().name("over").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition UNBOUNDED_RANGE = new BuiltInFunctionDefinition.Builder().name("unboundedRange").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition UNBOUNDED_ROW = new BuiltInFunctionDefinition.Builder().name("unboundedRow").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition CURRENT_RANGE = new BuiltInFunctionDefinition.Builder().name("currentRange").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition CURRENT_ROW = new BuiltInFunctionDefinition.Builder().name("currentRow").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition WITH_COLUMNS = new BuiltInFunctionDefinition.Builder().name("withColumns").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition WITHOUT_COLUMNS = new BuiltInFunctionDefinition.Builder().name("withoutColumns").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition IN = new BuiltInFunctionDefinition.Builder().name("in").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition CAST = new BuiltInFunctionDefinition.Builder().name("cast").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition REINTERPRET_CAST = new BuiltInFunctionDefinition.Builder().name("reinterpretCast").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition AS = new BuiltInFunctionDefinition.Builder().name("as").kind(FunctionKind.OTHER).inputTypeStrategy(InputTypeStrategies.varyingSequence(InputTypeStrategies.or(InputTypeStrategies.OUTPUT_IF_NULL, InputTypeStrategies.ANY), InputTypeStrategies.and(InputTypeStrategies.LITERAL, InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING)), InputTypeStrategies.and(InputTypeStrategies.LITERAL, InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING)))).outputTypeStrategy(TypeStrategies.argument(0)).build();
    public static final BuiltInFunctionDefinition STREAM_RECORD_TIMESTAMP = new BuiltInFunctionDefinition.Builder().name("streamRecordTimestamp").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition RANGE_TO = new BuiltInFunctionDefinition.Builder().name("rangeTo").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final Set<FunctionDefinition> WINDOW_PROPERTIES = new HashSet<BuiltInFunctionDefinition>(Arrays.asList(WINDOW_START, WINDOW_END, PROCTIME, ROWTIME));
    public static final Set<FunctionDefinition> TIME_ATTRIBUTES = new HashSet<BuiltInFunctionDefinition>(Arrays.asList(PROCTIME, ROWTIME));
    public static final List<FunctionDefinition> ORDERING = Arrays.asList(ORDER_ASC, ORDER_DESC);

    public static List<BuiltInFunctionDefinition> getDefinitions() {
        Field[] fields = BuiltInFunctionDefinitions.class.getFields();
        ArrayList<BuiltInFunctionDefinition> list = new ArrayList<BuiltInFunctionDefinition>(fields.length);
        for (Field field : fields) {
            if (!FunctionDefinition.class.isAssignableFrom(field.getType())) continue;
            try {
                BuiltInFunctionDefinition funcDef = (BuiltInFunctionDefinition)field.get(BuiltInFunctionDefinitions.class);
                list.add((BuiltInFunctionDefinition)Preconditions.checkNotNull((Object)funcDef));
            }
            catch (IllegalAccessException e) {
                throw new TableException("The function definition for field " + field.getName() + " is not accessible.", e);
            }
        }
        return list;
    }
}

