/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.descriptors.DescriptorBase;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@PublicEvolving
public abstract class ModuleDescriptor
extends DescriptorBase {
    private final String type;

    public ModuleDescriptor(String type) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)type) ? 1 : 0) != 0, (Object)"type cannot be null or empty");
        this.type = type;
    }

    @Override
    public final Map<String, String> toProperties() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString("type", this.type);
        properties.putProperties(this.toModuleProperties());
        return properties.asMap();
    }

    protected abstract Map<String, String> toModuleProperties();
}

