/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.descriptors.ClassInstance;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.descriptors.DescriptorProperties;

@PublicEvolving
public class FunctionDescriptor
implements Descriptor {
    private String from;
    private ClassInstance classInstance;
    private String fullyQualifiedName;

    public FunctionDescriptor fromClass(ClassInstance classType) {
        this.from = "class";
        this.classInstance = classType;
        this.fullyQualifiedName = null;
        return this;
    }

    @Override
    public Map<String, String> toProperties() {
        DescriptorProperties properties = new DescriptorProperties();
        if (this.from != null) {
            properties.putString("from", this.from);
        }
        if (this.classInstance != null) {
            properties.putProperties(this.classInstance.toProperties());
        }
        if (this.fullyQualifiedName != null) {
            properties.putString("fully-qualified-name", this.fullyQualifiedName);
        }
        return properties.asMap();
    }
}

