/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TableSchemaUtilsTest {
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @Test
    public void testBuilderWithGivenSchema() {
        TableSchema oriSchema = TableSchema.builder().field("a", (DataType)DataTypes.INT().notNull()).field("b", DataTypes.STRING()).field("c", DataTypes.INT(), "a + 1").field("t", DataTypes.TIMESTAMP((int)3)).primaryKey("ct1", new String[]{"a"}).watermark("t", "t", DataTypes.TIMESTAMP((int)3)).build();
        TableSchema newSchema = TableSchemaUtils.builderWithGivenSchema((TableSchema)oriSchema).build();
        Assert.assertEquals((Object)oriSchema, (Object)newSchema);
    }

    @Test
    public void testDropConstraint() {
        TableSchema oriSchema = TableSchema.builder().field("a", (DataType)DataTypes.INT().notNull()).field("b", DataTypes.STRING()).field("c", DataTypes.INT(), "a + 1").field("t", DataTypes.TIMESTAMP((int)3)).primaryKey("ct1", new String[]{"a"}).watermark("t", "t", DataTypes.TIMESTAMP((int)3)).build();
        TableSchema newSchema = TableSchemaUtils.dropConstraint((TableSchema)oriSchema, (String)"ct1");
        String expected = "root\n |-- a: INT NOT NULL\n |-- b: STRING\n |-- c: INT AS a + 1\n |-- t: TIMESTAMP(3)\n |-- WATERMARK FOR t AS t\n";
        Assert.assertEquals((Object)"root\n |-- a: INT NOT NULL\n |-- b: STRING\n |-- c: INT AS a + 1\n |-- t: TIMESTAMP(3)\n |-- WATERMARK FOR t AS t\n", (Object)newSchema.toString());
        this.exceptionRule.expect(ValidationException.class);
        this.exceptionRule.expectMessage("Constraint ct2 to drop does not exist");
        TableSchemaUtils.dropConstraint((TableSchema)oriSchema, (String)"ct2");
    }

    @Test
    public void testInvalidProjectSchema() {
        TableSchema schema = TableSchema.builder().field("a", (DataType)DataTypes.INT().notNull()).field("b", DataTypes.STRING()).field("c", DataTypes.INT(), "a + 1").field("t", DataTypes.TIMESTAMP((int)3)).primaryKey("ct1", new String[]{"a"}).watermark("t", "t", DataTypes.TIMESTAMP((int)3)).build();
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage("It's illegal to project on a schema contains computed columns.");
        int[][] projectedFields = new int[][]{{1}};
        TableSchemaUtils.projectSchema((TableSchema)schema, (int[][])projectedFields);
        schema = TableSchema.builder().field("a", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.STRING())})).field("b", DataTypes.STRING()).build();
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage("Nested projection push down is not supported yet.");
        projectedFields = new int[][]{{0, 1}};
        TableSchemaUtils.projectSchema((TableSchema)schema, (int[][])projectedFields);
    }

    @Test
    public void testProjectSchema() {
        TableSchema schema = TableSchema.builder().field("a", (DataType)DataTypes.INT().notNull()).field("b", DataTypes.STRING()).field("t", DataTypes.TIMESTAMP((int)3)).primaryKey(new String[]{"a"}).watermark("t", "t", DataTypes.TIMESTAMP((int)3)).build();
        int[][] projectedFields = new int[][]{{2}, {0}};
        TableSchema projected = TableSchemaUtils.projectSchema((TableSchema)schema, (int[][])projectedFields);
        TableSchema expected = TableSchema.builder().field("t", DataTypes.TIMESTAMP((int)3)).field("a", (DataType)DataTypes.INT().notNull()).build();
        Assert.assertEquals((Object)expected, (Object)projected);
    }
}

