/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeInferenceUtil;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.inference.utils.CallContextMock;
import org.apache.flink.table.types.inference.utils.FunctionDefinitionMock;
import org.apache.flink.util.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TypeStrategiesTest {
    @Parameterized.Parameter
    public TestSpec testSpec;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Parameterized.Parameters(name="{index}: {0}")
    public static List<TestSpec> testData() {
        return Arrays.asList(TestSpec.forStrategy(TypeStrategies.MISSING).inputTypes(DataTypes.INT()).expectErrorMessage("Could not infer an output type for the given arguments."), TestSpec.forStrategy(TypeStrategies.explicit((DataType)DataTypes.BIGINT())).inputTypes(new DataType[0]).expectDataType(DataTypes.BIGINT()), TestSpec.forStrategy(TypeStrategies.argument((int)0)).inputTypes(DataTypes.INT(), DataTypes.STRING()).expectDataType(DataTypes.INT()), TestSpec.forStrategy(TypeStrategies.argument((int)0)).inputTypes(new DataType[0]).expectErrorMessage("Could not infer an output type for the given arguments."), TestSpec.forStrategy(TypeStrategiesTest.createMappingTypeStrategy()).inputTypes(DataTypes.INT(), DataTypes.BOOLEAN()).expectDataType(DataTypes.STRING()), TestSpec.forStrategy(TypeStrategiesTest.createMappingTypeStrategy()).inputTypes(DataTypes.INT(), DataTypes.STRING()).expectDataType((DataType)DataTypes.BOOLEAN().bridgedTo(Boolean.TYPE)), TestSpec.forStrategy(TypeStrategiesTest.createMappingTypeStrategy()).inputTypes(DataTypes.INT(), DataTypes.CHAR((int)10)).expectDataType((DataType)DataTypes.BOOLEAN().bridgedTo(Boolean.TYPE)), TestSpec.forStrategy(TypeStrategiesTest.createMappingTypeStrategy()).inputTypes(DataTypes.INT(), DataTypes.INT()).expectErrorMessage("Could not infer an output type for the given arguments."), TestSpec.forStrategy(TypeStrategies.explicit((DataType)DataTypes.NULL())).inputTypes(new DataType[0]).expectErrorMessage("Could not infer an output type for the given arguments. Untyped NULL received."), TestSpec.forStrategy("Infer a row type", TypeStrategies.ROW).inputTypes(DataTypes.BIGINT(), DataTypes.STRING()).expectDataType((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())}).notNull()), TestSpec.forStrategy("Infer an array type", TypeStrategies.ARRAY).inputTypes(DataTypes.BIGINT(), DataTypes.BIGINT()).expectDataType((DataType)DataTypes.ARRAY((DataType)DataTypes.BIGINT()).notNull()), TestSpec.forStrategy("Infer a map type", TypeStrategies.MAP).inputTypes(DataTypes.BIGINT(), (DataType)DataTypes.STRING().notNull()).expectDataType((DataType)DataTypes.MAP((DataType)DataTypes.BIGINT(), (DataType)((DataType)DataTypes.STRING().notNull())).notNull()));
    }

    @Test
    public void testTypeStrategy() {
        if (this.testSpec.expectedErrorMessage != null) {
            this.thrown.expect(ValidationException.class);
            this.thrown.expectCause(CoreMatchers.containsCause((Throwable)new ValidationException(this.testSpec.expectedErrorMessage)));
        }
        TypeInferenceUtil.Result result = this.runTypeInference();
        if (this.testSpec.expectedDataType != null) {
            Assert.assertThat((Object)result.getOutputDataType(), (Matcher)org.hamcrest.CoreMatchers.equalTo((Object)this.testSpec.expectedDataType));
        }
    }

    private TypeInferenceUtil.Result runTypeInference() {
        FunctionDefinitionMock functionDefinitionMock = new FunctionDefinitionMock();
        functionDefinitionMock.functionKind = FunctionKind.SCALAR;
        CallContextMock callContextMock = new CallContextMock();
        callContextMock.functionDefinition = functionDefinitionMock;
        callContextMock.argumentDataTypes = this.testSpec.inputTypes;
        callContextMock.name = "f";
        callContextMock.outputDataType = Optional.empty();
        TypeInference typeInference = TypeInference.newBuilder().inputTypeStrategy((InputTypeStrategy)InputTypeStrategies.WILDCARD).outputTypeStrategy(this.testSpec.strategy).build();
        return TypeInferenceUtil.runTypeInference((TypeInference)typeInference, (CallContext)callContextMock, null);
    }

    private static TypeStrategy createMappingTypeStrategy() {
        HashMap<InputTypeStrategy, TypeStrategy> mappings = new HashMap<InputTypeStrategy, TypeStrategy>();
        mappings.put(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), TypeStrategies.explicit((DataType)((DataType)DataTypes.BOOLEAN().bridgedTo(Boolean.TYPE))));
        mappings.put(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN())}), TypeStrategies.explicit((DataType)DataTypes.STRING()));
        return TypeStrategies.mapping(mappings);
    }

    private static class TestSpec {
        @Nullable
        private final String description;
        private final TypeStrategy strategy;
        private List<DataType> inputTypes;
        @Nullable
        private DataType expectedDataType;
        @Nullable
        private String expectedErrorMessage;

        private TestSpec(@Nullable String description, TypeStrategy strategy) {
            this.description = description;
            this.strategy = strategy;
        }

        static TestSpec forStrategy(TypeStrategy strategy) {
            return new TestSpec(null, strategy);
        }

        static TestSpec forStrategy(String description, TypeStrategy strategy) {
            return new TestSpec(description, strategy);
        }

        TestSpec inputTypes(DataType ... dataTypes) {
            this.inputTypes = Arrays.asList(dataTypes);
            return this;
        }

        TestSpec expectDataType(DataType expectedDataType) {
            this.expectedDataType = expectedDataType;
            return this;
        }

        TestSpec expectErrorMessage(String expectedErrorMessage) {
            this.expectedErrorMessage = expectedErrorMessage;
            return this;
        }

        public String toString() {
            return this.description != null ? this.description : "";
        }
    }
}

