/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.CatalogDescriptor;
import org.apache.flink.table.descriptors.CatalogDescriptorValidator;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.DescriptorTestBase;
import org.apache.flink.table.descriptors.DescriptorValidator;
import org.junit.Test;

public class CatalogDescriptorTest
extends DescriptorTestBase {
    private static final String CATALOG_TYPE_VALUE = "CatalogDescriptorTest";
    private static final int CATALOG_PROPERTY_VERSION_VALUE = 1;
    private static final String CATALOG_FOO = "foo";
    private static final String CATALOG_FOO_VALUE = "foo-1";

    @Test(expected=ValidationException.class)
    public void testMissingCatalogType() {
        this.removePropertyAndVerify(this.descriptors().get(0), "type");
    }

    @Test(expected=ValidationException.class)
    public void testMissingFoo() {
        this.removePropertyAndVerify(this.descriptors().get(0), CATALOG_FOO);
    }

    @Override
    protected List<Descriptor> descriptors() {
        TestCatalogDescriptor minimumDesc = new TestCatalogDescriptor(CATALOG_FOO_VALUE);
        return Collections.singletonList(minimumDesc);
    }

    @Override
    protected List<Map<String, String>> properties() {
        HashMap<String, String> minimumProps = new HashMap<String, String>();
        minimumProps.put("type", CATALOG_TYPE_VALUE);
        minimumProps.put("property-version", "1");
        minimumProps.put(CATALOG_FOO, CATALOG_FOO_VALUE);
        return Collections.singletonList(minimumProps);
    }

    @Override
    protected DescriptorValidator validator() {
        return new TestCatalogDescriptorValidator();
    }

    private class TestCatalogDescriptorValidator
    extends CatalogDescriptorValidator {
        private TestCatalogDescriptorValidator() {
        }

        public void validate(DescriptorProperties properties) {
            super.validate(properties);
            properties.validateString(CatalogDescriptorTest.CATALOG_FOO, false, 1);
        }
    }

    private class TestCatalogDescriptor
    extends CatalogDescriptor {
        private String foo;

        public TestCatalogDescriptor(String foo) {
            super(CatalogDescriptorTest.CATALOG_TYPE_VALUE, 1);
            this.foo = foo;
        }

        protected Map<String, String> toCatalogProperties() {
            DescriptorProperties properties = new DescriptorProperties();
            if (this.foo != null) {
                properties.putString(CatalogDescriptorTest.CATALOG_FOO, this.foo);
            }
            return properties.asMap();
        }
    }
}

