/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.types.LogicalTypesTest;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LogicalTypeCastAvoidanceTest {
    @Parameterized.Parameter
    public LogicalType sourceType;
    @Parameterized.Parameter(value=1)
    public LogicalType targetType;
    @Parameterized.Parameter(value=2)
    public boolean equals;

    @Parameterized.Parameters(name="{index}: [{0} COMPATIBLE {1} => {2}")
    public static List<Object[]> testData() {
        return Arrays.asList({new CharType(), new CharType(5), false}, {new VarCharType(30), new VarCharType(10), false}, {new VarCharType(10), new VarCharType(30), true}, {new CharType(10), new VarCharType(30), true}, {new BinaryType(10), new VarBinaryType(30), true}, {new CharType(false, 10), new VarCharType(30), true}, {new BinaryType(false, 10), new VarBinaryType(30), true}, {new VarCharType(30), new CharType(10), false}, {new VarBinaryType(30), new BinaryType(10), false}, {new BooleanType(), new BooleanType(false), false}, {new BinaryType(10), new BinaryType(30), false}, {new VarBinaryType(10), new VarBinaryType(30), true}, {new VarBinaryType(30), new VarBinaryType(10), false}, {new DecimalType(), new DecimalType(10, 2), false}, {new TinyIntType(), new TinyIntType(false), false}, {new SmallIntType(), new SmallIntType(false), false}, {new IntType(), new IntType(false), false}, {new IntType(false), new IntType(), true}, {new BigIntType(), new BigIntType(false), false}, {new FloatType(), new FloatType(false), false}, {new DoubleType(), new DoubleType(false), false}, {new DateType(), new DateType(false), false}, {new TimeType(), new TimeType(9), false}, {new TimestampType(9), new TimestampType(3), false}, {new ZonedTimestampType(9), new ZonedTimestampType(3), false}, {new ZonedTimestampType(false, TimestampKind.PROCTIME, 9), new ZonedTimestampType(3), false}, {new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR_TO_MONTH, 2), new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.MONTH), false}, {new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_SECOND, 2, 6), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_SECOND, 2, 7), false}, {new ArrayType((LogicalType)new TimestampType()), new ArrayType((LogicalType)new SmallIntType()), false}, {new MultisetType((LogicalType)new TimestampType()), new MultisetType((LogicalType)new SmallIntType()), false}, {new MapType((LogicalType)new VarCharType(10), (LogicalType)new TimestampType()), new MapType((LogicalType)new VarCharType(30), (LogicalType)new TimestampType()), true}, {new MapType((LogicalType)new VarCharType(30), (LogicalType)new TimestampType()), new MapType((LogicalType)new VarCharType(10), (LogicalType)new TimestampType()), false}, {new RowType(Arrays.asList(new RowType.RowField("a", (LogicalType)new VarCharType()), new RowType.RowField("b", (LogicalType)new VarCharType()), new RowType.RowField("c", (LogicalType)new VarCharType()), new RowType.RowField("d", (LogicalType)new TimestampType()))), new RowType(Arrays.asList(new RowType.RowField("_a", (LogicalType)new VarCharType()), new RowType.RowField("_b", (LogicalType)new VarCharType()), new RowType.RowField("_c", (LogicalType)new VarCharType()), new RowType.RowField("_d", (LogicalType)new TimestampType()))), true}, {new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new VarCharType()))), new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new BooleanType()))), false}, {new ArrayType((LogicalType)new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new IntType())))), new ArrayType((LogicalType)new RowType(Arrays.asList(new RowType.RowField("f3", (LogicalType)new IntType()), new RowType.RowField("f4", (LogicalType)new IntType())))), true}, {new MapType((LogicalType)new IntType(), (LogicalType)new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new IntType())))), new MapType((LogicalType)new IntType(), (LogicalType)new RowType(Arrays.asList(new RowType.RowField("f3", (LogicalType)new IntType()), new RowType.RowField("f4", (LogicalType)new IntType())))), true}, {new MultisetType((LogicalType)new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new IntType())))), new MultisetType((LogicalType)new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new IntType())))), true}, {new TypeInformationRawType(Types.GENERIC(LogicalTypesTest.class)), new TypeInformationRawType(Types.GENERIC(Object.class)), false}, {LogicalTypeCastAvoidanceTest.createUserType("User", new LogicalType[]{new IntType(), new VarCharType()}), LogicalTypeCastAvoidanceTest.createUserType("User", new LogicalType[]{new IntType(), new VarCharType()}), true}, {LogicalTypeCastAvoidanceTest.createUserType("User", new LogicalType[]{new IntType(), new VarCharType()}), LogicalTypeCastAvoidanceTest.createUserType("User2", new LogicalType[]{new IntType(), new VarCharType()}), false}, {LogicalTypeCastAvoidanceTest.createDistinctType("Money", (LogicalType)new DecimalType(10, 2)), LogicalTypeCastAvoidanceTest.createDistinctType("Money", (LogicalType)new DecimalType(10, 2)), true}, {LogicalTypeCastAvoidanceTest.createDistinctType("Money", (LogicalType)new DecimalType(10, 2)), LogicalTypeCastAvoidanceTest.createDistinctType("Money2", (LogicalType)new DecimalType(10, 2)), true});
    }

    @Test
    public void testSupportsAvoidingCast() {
        Assert.assertThat((Object)LogicalTypeCasts.supportsAvoidingCast((LogicalType)this.sourceType, (LogicalType)this.targetType), (Matcher)CoreMatchers.equalTo((Object)this.equals));
        Assert.assertTrue((boolean)LogicalTypeCasts.supportsAvoidingCast((LogicalType)this.sourceType, (LogicalType)this.sourceType.copy()));
        Assert.assertTrue((boolean)LogicalTypeCasts.supportsAvoidingCast((LogicalType)this.targetType, (LogicalType)this.targetType.copy()));
    }

    private static DistinctType createDistinctType(String name, LogicalType sourceType) {
        return DistinctType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)name), (LogicalType)sourceType).description("Money type desc.").build();
    }

    private static StructuredType createUserType(String name, LogicalType ... children) {
        return StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)name), User.class).attributes(Arrays.stream(children).map(lt -> new StructuredType.StructuredAttribute("field", lt)).collect(Collectors.toList())).description("User type desc.").setFinal(true).setInstantiable(true).build();
    }

    private static final class User {
        public int setting;

        private User() {
        }
    }
}

