/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;

public class TestFormatFactory
implements DeserializationFormatFactory,
SerializationFormatFactory {
    public static final String IDENTIFIER = "test-format";
    public static final ConfigOption<String> DELIMITER = ConfigOptions.key((String)"delimiter").stringType().noDefaultValue();
    public static final ConfigOption<Boolean> FAIL_ON_MISSING = ConfigOptions.key((String)"fail-on-missing").booleanType().defaultValue((Object)false);

    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig formatConfig) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatConfig);
        return new DecodingFormatMock((String)formatConfig.get(DELIMITER), (Boolean)formatConfig.get(FAIL_ON_MISSING));
    }

    public EncodingFormat<SerializationSchema<RowData>> createEncodingFormat(DynamicTableFactory.Context context, ReadableConfig formatConfig) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatConfig);
        return new EncodingFormatMock((String)formatConfig.get(DELIMITER));
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(DELIMITER);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(FAIL_ON_MISSING);
        return options;
    }

    public static class EncodingFormatMock
    implements EncodingFormat<SerializationSchema<RowData>> {
        public final String delimiter;

        public EncodingFormatMock(String delimiter) {
            this.delimiter = delimiter;
        }

        public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType consumeDataType) {
            return null;
        }

        public ChangelogMode getChangelogMode() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EncodingFormatMock that = (EncodingFormatMock)o;
            return this.delimiter.equals(that.delimiter);
        }

        public int hashCode() {
            return Objects.hash(this.delimiter);
        }
    }

    public static class DecodingFormatMock
    implements DecodingFormat<DeserializationSchema<RowData>> {
        public final String delimiter;
        public final Boolean failOnMissing;

        public DecodingFormatMock(String delimiter, Boolean failOnMissing) {
            this.delimiter = delimiter;
            this.failOnMissing = failOnMissing;
        }

        public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType producedDataType) {
            return null;
        }

        public ChangelogMode getChangelogMode() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DecodingFormatMock that = (DecodingFormatMock)o;
            return this.delimiter.equals(that.delimiter) && this.failOnMissing.equals(that.failOnMissing);
        }

        public int hashCode() {
            return Objects.hash(this.delimiter, this.failOnMissing);
        }
    }
}

