/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.HashMap;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.factories.TableFormatFactoryBase;
import org.junit.Assert;
import org.junit.Test;

public class TableFormatFactoryBaseTest {
    @Test
    public void testSchemaDerivation() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("schema.0.name", "otherField");
        properties.put("schema.0.type", "VARCHAR");
        properties.put("schema.0.from", "csvField");
        properties.put("schema.1.name", "abcField");
        properties.put("schema.1.type", "VARCHAR");
        properties.put("schema.2.name", "p");
        properties.put("schema.2.type", "TIMESTAMP");
        properties.put("schema.2.proctime", "true");
        properties.put("schema.3.name", "r");
        properties.put("schema.3.type", "TIMESTAMP");
        properties.put("schema.3.rowtime.timestamps.type", "from-source");
        properties.put("schema.3.rowtime.watermarks.type", "from-source");
        TableSchema actualSchema = TableFormatFactoryBase.deriveSchema(properties);
        TableSchema expectedSchema = TableSchema.builder().field("csvField", Types.STRING).field("abcField", Types.STRING).build();
        Assert.assertEquals((Object)expectedSchema, (Object)actualSchema);
    }

    @Test
    public void testSchemaDerivationWithRowtime() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("schema.0.name", "otherField");
        properties.put("schema.0.type", "VARCHAR");
        properties.put("schema.0.from", "csvField");
        properties.put("schema.1.name", "abcField");
        properties.put("schema.1.type", "VARCHAR");
        properties.put("schema.2.name", "p");
        properties.put("schema.2.type", "TIMESTAMP");
        properties.put("schema.2.proctime", "true");
        properties.put("schema.3.name", "r");
        properties.put("schema.3.type", "TIMESTAMP");
        properties.put("schema.3.rowtime.timestamps.type", "from-field");
        properties.put("schema.3.rowtime.timestamps.from", "myTime");
        properties.put("schema.3.rowtime.watermarks.type", "from-source");
        TableSchema actualSchema = TableFormatFactoryBase.deriveSchema(properties);
        TableSchema expectedSchema = TableSchema.builder().field("csvField", Types.STRING).field("abcField", Types.STRING).field("myTime", Types.SQL_TIMESTAMP).build();
        Assert.assertEquals((Object)expectedSchema, (Object)actualSchema);
    }
}

