/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeDefaultVisitor;

@Internal
public final class LogicalTypeCasts {
    private static final Map<LogicalTypeRoot, Set<LogicalTypeRoot>> implicitCastingRules = new HashMap<LogicalTypeRoot, Set<LogicalTypeRoot>>();
    private static final Map<LogicalTypeRoot, Set<LogicalTypeRoot>> explicitCastingRules = new HashMap<LogicalTypeRoot, Set<LogicalTypeRoot>>();

    public static boolean supportsAvoidingCast(LogicalType sourceType, LogicalType targetType) {
        CastAvoidanceChecker checker = new CastAvoidanceChecker(sourceType);
        return targetType.accept(checker);
    }

    public static boolean supportsAvoidingCast(List<LogicalType> sourceTypes, List<LogicalType> targetTypes) {
        if (sourceTypes.size() != targetTypes.size()) {
            return false;
        }
        for (int i = 0; i < sourceTypes.size(); ++i) {
            if (LogicalTypeCasts.supportsAvoidingCast(sourceTypes.get(i), targetTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean supportsImplicitCast(LogicalType sourceType, LogicalType targetType) {
        return LogicalTypeCasts.supportsCasting(sourceType, targetType, false);
    }

    public static boolean supportsExplicitCast(LogicalType sourceType, LogicalType targetType) {
        return LogicalTypeCasts.supportsCasting(sourceType, targetType, true);
    }

    private static boolean supportsCasting(LogicalType sourceType, LogicalType targetType, boolean allowExplicit) {
        if (sourceType.isNullable() && !targetType.isNullable()) {
            return false;
        }
        if (sourceType.copy(true).equals(targetType.copy(true))) {
            return true;
        }
        LogicalTypeRoot sourceRoot = sourceType.getTypeRoot();
        LogicalTypeRoot targetRoot = targetType.getTypeRoot();
        if (LogicalTypeChecks.hasFamily(sourceType, LogicalTypeFamily.INTERVAL) && LogicalTypeChecks.hasFamily(targetType, LogicalTypeFamily.EXACT_NUMERIC)) {
            return LogicalTypeChecks.isSingleFieldInterval(sourceType);
        }
        if (LogicalTypeChecks.hasFamily(sourceType, LogicalTypeFamily.EXACT_NUMERIC) && LogicalTypeChecks.hasFamily(targetType, LogicalTypeFamily.INTERVAL)) {
            return LogicalTypeChecks.isSingleFieldInterval(targetType);
        }
        if (LogicalTypeChecks.hasFamily(sourceType, LogicalTypeFamily.CONSTRUCTED) || LogicalTypeChecks.hasFamily(targetType, LogicalTypeFamily.CONSTRUCTED)) {
            return LogicalTypeCasts.supportsConstructedCasting(sourceType, targetType, allowExplicit);
        }
        if (sourceRoot == LogicalTypeRoot.DISTINCT_TYPE && targetRoot == LogicalTypeRoot.DISTINCT_TYPE) {
            return false;
        }
        if (sourceRoot == LogicalTypeRoot.DISTINCT_TYPE) {
            return LogicalTypeCasts.supportsCasting(((DistinctType)sourceType).getSourceType(), targetType, allowExplicit);
        }
        if (targetRoot == LogicalTypeRoot.DISTINCT_TYPE) {
            return LogicalTypeCasts.supportsCasting(sourceType, ((DistinctType)targetType).getSourceType(), allowExplicit);
        }
        if (sourceRoot == LogicalTypeRoot.STRUCTURED_TYPE || targetRoot == LogicalTypeRoot.STRUCTURED_TYPE) {
            return false;
        }
        if (sourceRoot == LogicalTypeRoot.NULL) {
            return true;
        }
        if (sourceRoot == LogicalTypeRoot.RAW || targetRoot == LogicalTypeRoot.RAW) {
            return false;
        }
        if (sourceRoot == LogicalTypeRoot.SYMBOL || targetRoot == LogicalTypeRoot.SYMBOL) {
            return false;
        }
        if (implicitCastingRules.get((Object)targetRoot).contains((Object)sourceRoot)) {
            return true;
        }
        if (allowExplicit) {
            return explicitCastingRules.get((Object)targetRoot).contains((Object)sourceRoot);
        }
        return false;
    }

    private static boolean supportsConstructedCasting(LogicalType sourceType, LogicalType targetType, boolean allowExplicit) {
        LogicalTypeRoot targetRoot;
        LogicalTypeRoot sourceRoot = sourceType.getTypeRoot();
        if (sourceRoot == (targetRoot = targetType.getTypeRoot())) {
            List<LogicalType> sourceChildren = sourceType.getChildren();
            List<LogicalType> targetChildren = targetType.getChildren();
            if (sourceChildren.size() != targetChildren.size()) {
                return false;
            }
            for (int i = 0; i < sourceChildren.size(); ++i) {
                if (LogicalTypeCasts.supportsCasting(sourceChildren.get(i), targetChildren.get(i), allowExplicit)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static CastingRuleBuilder castTo(LogicalTypeRoot sourceType) {
        return new CastingRuleBuilder(sourceType);
    }

    private static LogicalTypeRoot[] allTypes() {
        return LogicalTypeRoot.values();
    }

    private LogicalTypeCasts() {
    }

    static {
        for (LogicalTypeRoot typeRoot : LogicalTypeCasts.allTypes()) {
            LogicalTypeCasts.castTo(typeRoot).implicitFrom(typeRoot).build();
        }
        LogicalTypeCasts.castTo(LogicalTypeRoot.CHAR).implicitFrom(LogicalTypeRoot.CHAR).explicitFromFamily(LogicalTypeFamily.PREDEFINED).explicitNotFromFamily(LogicalTypeFamily.BINARY_STRING).build();
        LogicalTypeCasts.castTo(LogicalTypeRoot.VARCHAR).implicitFromFamily(LogicalTypeFamily.CHARACTER_STRING).explicitFromFamily(LogicalTypeFamily.PREDEFINED).explicitNotFromFamily(LogicalTypeFamily.BINARY_STRING).build();
        LogicalTypeCasts.castTo(LogicalTypeRoot.BOOLEAN).implicitFrom(LogicalTypeRoot.BOOLEAN).explicitFromFamily(LogicalTypeFamily.CHARACTER_STRING).build();
        LogicalTypeCasts.castTo(LogicalTypeRoot.BINARY).implicitFrom(LogicalTypeRoot.BINARY).build();
        LogicalTypeCasts.castTo(LogicalTypeRoot.VARBINARY).implicitFromFamily(LogicalTypeFamily.BINARY_STRING).build();
        LogicalTypeCasts.castTo(LogicalTypeRoot.DECIMAL).implicitFromFamily(LogicalTypeFamily.NUMERIC).explicitFromFamily(LogicalTypeFamily.CHARACTER_STRING).build();
        LogicalTypeCasts.castTo(LogicalTypeRoot.TINYINT).implicitFrom(LogicalTypeRoot.TINYINT).explicitFromFamily(LogicalTypeFamily.NUMERIC, LogicalTypeFamily.CHARACTER_STRING).build();
        LogicalTypeCasts.castTo(LogicalTypeRoot.SMALLINT).implicitFrom(LogicalTypeRoot.TINYINT, LogicalTypeRoot.SMALLINT).explicitFromFamily(LogicalTypeFamily.NUMERIC, LogicalTypeFamily.CHARACTER_STRING).build();
        LogicalTypeCasts.castTo(LogicalTypeRoot.INTEGER).implicitFrom(LogicalTypeRoot.TINYINT, LogicalTypeRoot.SMALLINT, LogicalTypeRoot.INTEGER).explicitFromFamily(LogicalTypeFamily.NUMERIC, LogicalTypeFamily.CHARACTER_STRING).build();
        LogicalTypeCasts.castTo(LogicalTypeRoot.BIGINT).implicitFrom(LogicalTypeRoot.TINYINT, LogicalTypeRoot.SMALLINT, LogicalTypeRoot.INTEGER, LogicalTypeRoot.BIGINT).explicitFromFamily(LogicalTypeFamily.NUMERIC, LogicalTypeFamily.CHARACTER_STRING).build();
        LogicalTypeCasts.castTo(LogicalTypeRoot.FLOAT).implicitFrom(LogicalTypeRoot.TINYINT, LogicalTypeRoot.SMALLINT, LogicalTypeRoot.INTEGER, LogicalTypeRoot.BIGINT, LogicalTypeRoot.FLOAT, LogicalTypeRoot.DECIMAL).explicitFromFamily(LogicalTypeFamily.NUMERIC, LogicalTypeFamily.CHARACTER_STRING).build();
        LogicalTypeCasts.castTo(LogicalTypeRoot.DOUBLE).implicitFromFamily(LogicalTypeFamily.NUMERIC).explicitFromFamily(LogicalTypeFamily.CHARACTER_STRING).build();
        LogicalTypeCasts.castTo(LogicalTypeRoot.DATE).implicitFrom(LogicalTypeRoot.DATE, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).explicitFromFamily(LogicalTypeFamily.TIMESTAMP, LogicalTypeFamily.CHARACTER_STRING).build();
        LogicalTypeCasts.castTo(LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE).implicitFrom(LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).explicitFromFamily(LogicalTypeFamily.TIME, LogicalTypeFamily.TIMESTAMP, LogicalTypeFamily.CHARACTER_STRING).build();
        LogicalTypeCasts.castTo(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).implicitFrom(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).explicitFromFamily(LogicalTypeFamily.DATETIME, LogicalTypeFamily.CHARACTER_STRING).build();
        LogicalTypeCasts.castTo(LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE).implicitFrom(LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE).explicitFromFamily(LogicalTypeFamily.DATETIME, LogicalTypeFamily.CHARACTER_STRING).build();
        LogicalTypeCasts.castTo(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).implicitFrom(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).explicitFromFamily(LogicalTypeFamily.DATETIME, LogicalTypeFamily.CHARACTER_STRING).build();
        LogicalTypeCasts.castTo(LogicalTypeRoot.INTERVAL_YEAR_MONTH).implicitFrom(LogicalTypeRoot.INTERVAL_YEAR_MONTH).explicitFromFamily(LogicalTypeFamily.EXACT_NUMERIC, LogicalTypeFamily.CHARACTER_STRING).build();
        LogicalTypeCasts.castTo(LogicalTypeRoot.INTERVAL_DAY_TIME).implicitFrom(LogicalTypeRoot.INTERVAL_DAY_TIME).explicitFromFamily(LogicalTypeFamily.EXACT_NUMERIC, LogicalTypeFamily.CHARACTER_STRING).build();
    }

    private static class CastAvoidanceChecker
    extends LogicalTypeDefaultVisitor<Boolean> {
        private final LogicalType sourceType;

        private CastAvoidanceChecker(LogicalType sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public Boolean visit(VarCharType targetType) {
            if (this.sourceType.isNullable() && !targetType.isNullable()) {
                return false;
            }
            if ((LogicalTypeChecks.hasRoot(this.sourceType, LogicalTypeRoot.CHAR) || LogicalTypeChecks.hasRoot(this.sourceType, LogicalTypeRoot.VARCHAR)) && LogicalTypeChecks.getLength(this.sourceType) <= targetType.getLength()) {
                return true;
            }
            return this.defaultMethod(targetType);
        }

        @Override
        public Boolean visit(VarBinaryType targetType) {
            if (this.sourceType.isNullable() && !targetType.isNullable()) {
                return false;
            }
            if ((LogicalTypeChecks.hasRoot(this.sourceType, LogicalTypeRoot.BINARY) || LogicalTypeChecks.hasRoot(this.sourceType, LogicalTypeRoot.VARBINARY)) && LogicalTypeChecks.getLength(this.sourceType) <= targetType.getLength()) {
                return true;
            }
            return this.defaultMethod(targetType);
        }

        @Override
        public Boolean visit(StructuredType targetType) {
            if (this.sourceType.isNullable() && !targetType.isNullable()) {
                return false;
            }
            return this.sourceType.equals(targetType) || this.sourceType.copy(true).equals(targetType);
        }

        @Override
        protected Boolean defaultMethod(LogicalType targetType) {
            if (this.sourceType == targetType) {
                return true;
            }
            if (this.sourceType.isNullable() && !targetType.isNullable() || this.sourceType.getClass() != targetType.getClass() || this.sourceType.getTypeRoot() != targetType.getTypeRoot()) {
                return false;
            }
            List<LogicalType> sourceChildren = this.sourceType.getChildren();
            List<LogicalType> targetChildren = targetType.getChildren();
            if (sourceChildren.isEmpty()) {
                return this.sourceType.equals(targetType) || this.sourceType.copy(true).equals(targetType);
            }
            return LogicalTypeCasts.supportsAvoidingCast(sourceChildren, targetChildren);
        }
    }

    private static class CastingRuleBuilder {
        private final LogicalTypeRoot targetType;
        private Set<LogicalTypeRoot> implicitSourceTypes = new HashSet<LogicalTypeRoot>();
        private Set<LogicalTypeRoot> explicitSourceTypes = new HashSet<LogicalTypeRoot>();

        CastingRuleBuilder(LogicalTypeRoot targetType) {
            this.targetType = targetType;
        }

        CastingRuleBuilder implicitFrom(LogicalTypeRoot ... sourceTypes) {
            this.implicitSourceTypes.addAll(Arrays.asList(sourceTypes));
            return this;
        }

        CastingRuleBuilder implicitFromFamily(LogicalTypeFamily ... sourceFamilies) {
            for (LogicalTypeFamily family : sourceFamilies) {
                for (LogicalTypeRoot root : LogicalTypeRoot.values()) {
                    if (!root.getFamilies().contains((Object)family)) continue;
                    this.implicitSourceTypes.add(root);
                }
            }
            return this;
        }

        CastingRuleBuilder explicitFrom(LogicalTypeRoot ... sourceTypes) {
            this.explicitSourceTypes.addAll(Arrays.asList(sourceTypes));
            return this;
        }

        CastingRuleBuilder explicitFromFamily(LogicalTypeFamily ... sourceFamilies) {
            for (LogicalTypeFamily family : sourceFamilies) {
                for (LogicalTypeRoot root : LogicalTypeRoot.values()) {
                    if (!root.getFamilies().contains((Object)family)) continue;
                    this.explicitSourceTypes.add(root);
                }
            }
            return this;
        }

        CastingRuleBuilder explicitNotFromFamily(LogicalTypeFamily ... sourceFamilies) {
            for (LogicalTypeFamily family : sourceFamilies) {
                for (LogicalTypeRoot root : LogicalTypeRoot.values()) {
                    if (!root.getFamilies().contains((Object)family)) continue;
                    this.explicitSourceTypes.remove((Object)root);
                }
            }
            return this;
        }

        void build() {
            implicitCastingRules.put(this.targetType, this.implicitSourceTypes);
            explicitCastingRules.put(this.targetType, this.explicitSourceTypes);
        }
    }
}

