/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.python;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.python.PythonEnv;
import org.apache.flink.table.functions.python.PythonFunction;
import org.apache.flink.table.functions.python.PythonFunctionKind;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;

@Internal
public class PythonTableFunction
extends TableFunction<Row>
implements PythonFunction {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final byte[] serializedScalarFunction;
    private final TypeInformation[] inputTypes;
    private final RowTypeInfo resultType;
    private final PythonFunctionKind pythonFunctionKind;
    private final boolean deterministic;
    private final PythonEnv pythonEnv;

    public PythonTableFunction(String name, byte[] serializedScalarFunction, TypeInformation[] inputTypes, RowTypeInfo resultType, PythonFunctionKind pythonFunctionKind, boolean deterministic, PythonEnv pythonEnv) {
        this.name = name;
        this.serializedScalarFunction = serializedScalarFunction;
        this.inputTypes = inputTypes;
        this.resultType = resultType;
        this.pythonFunctionKind = pythonFunctionKind;
        this.deterministic = deterministic;
        this.pythonEnv = pythonEnv;
    }

    public void eval(Object ... args) {
        throw new UnsupportedOperationException("This method is a placeholder and should not be called.");
    }

    @Override
    public byte[] getSerializedPythonFunction() {
        return this.serializedScalarFunction;
    }

    @Override
    public PythonEnv getPythonEnv() {
        return this.pythonEnv;
    }

    @Override
    public PythonFunctionKind getPythonFunctionKind() {
        return this.pythonFunctionKind;
    }

    @Override
    public boolean isDeterministic() {
        return this.deterministic;
    }

    @Override
    public TypeInformation[] getParameterTypes(Class[] signature) {
        return this.inputTypes;
    }

    @Override
    public TypeInformation<Row> getResultType() {
        return this.resultType;
    }

    @Override
    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        List<DataType> argumentDataTypes = Stream.of(this.inputTypes).map(TypeConversions::fromLegacyInfoToDataType).collect(Collectors.toList());
        return TypeInference.newBuilder().typedArguments(argumentDataTypes).outputTypeStrategy(TypeStrategies.explicit(TypeConversions.fromLegacyInfoToDataType(this.resultType))).build();
    }

    @Override
    public String toString() {
        return this.name;
    }
}

