/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class UnresolvedUserDefinedType
extends LogicalType {
    private final UnresolvedIdentifier unresolvedIdentifier;

    public UnresolvedUserDefinedType(boolean isNullable, UnresolvedIdentifier unresolvedIdentifier) {
        super(isNullable, LogicalTypeRoot.UNRESOLVED);
        this.unresolvedIdentifier = (UnresolvedIdentifier)Preconditions.checkNotNull((Object)unresolvedIdentifier, (String)"Type identifier must not be null.");
    }

    public UnresolvedUserDefinedType(UnresolvedIdentifier unresolvedIdentifier) {
        this(true, unresolvedIdentifier);
    }

    public UnresolvedIdentifier getUnresolvedIdentifier() {
        return this.unresolvedIdentifier;
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new UnresolvedUserDefinedType(isNullable, this.unresolvedIdentifier);
    }

    @Override
    public String asSummaryString() {
        return this.withNullability(this.unresolvedIdentifier.asSummaryString(), new Object[0]);
    }

    @Override
    public String asSerializableString() {
        throw new TableException("An unresolved user-defined type has no serializable string representation. It needs to be resolved into a proper user-defined type.");
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        throw new TableException("An unresolved user-defined type does not support any input conversion.");
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        throw new TableException("An unresolved user-defined type does not support any output conversion.");
    }

    @Override
    public Class<?> getDefaultConversion() {
        throw new TableException("An unresolved user-defined type has no default conversion.");
    }

    @Override
    public List<LogicalType> getChildren() {
        throw new TableException("An unresolved user-defined type cannot return children.");
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UnresolvedUserDefinedType that = (UnresolvedUserDefinedType)o;
        return this.unresolvedIdentifier.equals(that.unresolvedIdentifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.unresolvedIdentifier);
    }
}

