/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

@Internal
public final class OrArgumentTypeStrategy
implements ArgumentTypeStrategy {
    private final List<? extends ArgumentTypeStrategy> argumentStrategies;

    public OrArgumentTypeStrategy(List<? extends ArgumentTypeStrategy> argumentStrategies) {
        Preconditions.checkArgument((argumentStrategies.size() > 0 ? 1 : 0) != 0);
        this.argumentStrategies = argumentStrategies;
    }

    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        LogicalType actualType = callContext.getArgumentDataTypes().get(argumentPos).getLogicalType();
        Optional<DataType> closestDataType = Optional.empty();
        for (ArgumentTypeStrategy argumentTypeStrategy : this.argumentStrategies) {
            Optional<DataType> inferredDataType = argumentTypeStrategy.inferArgumentType(callContext, argumentPos, false);
            if (!inferredDataType.isPresent()) continue;
            LogicalType inferredType = inferredDataType.get().getLogicalType();
            if (actualType.equals(inferredType)) {
                return inferredDataType;
            }
            if (closestDataType.isPresent()) continue;
            closestDataType = inferredDataType;
        }
        if (closestDataType.isPresent()) {
            return closestDataType;
        }
        if (throwOnFailure) {
            for (ArgumentTypeStrategy argumentTypeStrategy : this.argumentStrategies) {
                argumentTypeStrategy.inferArgumentType(callContext, argumentPos, true);
            }
        }
        return Optional.empty();
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        String argument = this.argumentStrategies.stream().map(v -> v.getExpectedArgument(functionDefinition, argumentPos).getType()).collect(Collectors.joining(" | ", "[", "]"));
        return Signature.Argument.of(argument);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrArgumentTypeStrategy that = (OrArgumentTypeStrategy)o;
        return Objects.equals(this.argumentStrategies, that.argumentStrategies);
    }

    public int hashCode() {
        return Objects.hash(this.argumentStrategies);
    }
}

