/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.AndArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.AnyArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.ExplicitArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.LiteralArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.OrArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.OrInputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.OutputArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.SequenceInputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.VaryingSequenceInputTypeStrategy;
import org.apache.flink.table.types.inference.strategies.WildcardInputTypeStrategy;

@Internal
public final class InputTypeStrategies {
    public static final WildcardInputTypeStrategy WILDCARD = new WildcardInputTypeStrategy();
    public static final OutputArgumentTypeStrategy OUTPUT_IF_NULL = new OutputArgumentTypeStrategy();
    public static final AnyArgumentTypeStrategy ANY = new AnyArgumentTypeStrategy();
    public static final LiteralArgumentTypeStrategy LITERAL = new LiteralArgumentTypeStrategy(false);
    public static final LiteralArgumentTypeStrategy LITERAL_OR_NULL = new LiteralArgumentTypeStrategy(true);

    public static InputTypeStrategy sequence(ArgumentTypeStrategy ... strategies) {
        return new SequenceInputTypeStrategy(Arrays.asList(strategies), null);
    }

    public static InputTypeStrategy sequence(String[] argumentNames, ArgumentTypeStrategy[] strategies) {
        return new SequenceInputTypeStrategy(Arrays.asList(strategies), Arrays.asList(argumentNames));
    }

    public static InputTypeStrategy varyingSequence(ArgumentTypeStrategy ... strategies) {
        return new VaryingSequenceInputTypeStrategy(Arrays.asList(strategies), null);
    }

    public static InputTypeStrategy varyingSequence(String[] argumentNames, ArgumentTypeStrategy[] strategies) {
        return new VaryingSequenceInputTypeStrategy(Arrays.asList(strategies), Arrays.asList(argumentNames));
    }

    public static InputTypeStrategy explicitSequence(DataType ... expectedDataTypes) {
        List strategies = Arrays.stream(expectedDataTypes).map(InputTypeStrategies::explicit).collect(Collectors.toList());
        return new SequenceInputTypeStrategy(strategies, null);
    }

    public static InputTypeStrategy explicitSequence(String[] argumentNames, DataType[] expectedDataTypes) {
        List strategies = Arrays.stream(expectedDataTypes).map(InputTypeStrategies::explicit).collect(Collectors.toList());
        return new SequenceInputTypeStrategy(strategies, Arrays.asList(argumentNames));
    }

    public static InputTypeStrategy or(InputTypeStrategy ... strategies) {
        return new OrInputTypeStrategy(Arrays.asList(strategies));
    }

    public static ExplicitArgumentTypeStrategy explicit(DataType expectedDataType) {
        return new ExplicitArgumentTypeStrategy(expectedDataType);
    }

    public static AndArgumentTypeStrategy and(ArgumentTypeStrategy ... strategies) {
        return new AndArgumentTypeStrategy(Arrays.asList(strategies));
    }

    public static OrArgumentTypeStrategy or(ArgumentTypeStrategy ... strategies) {
        return new OrArgumentTypeStrategy(Arrays.asList(strategies));
    }

    private InputTypeStrategies() {
    }
}

