/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction.utils;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.shaded.asm7.org.objectweb.asm.ClassReader;
import org.apache.flink.shaded.asm7.org.objectweb.asm.ClassVisitor;
import org.apache.flink.shaded.asm7.org.objectweb.asm.Label;
import org.apache.flink.shaded.asm7.org.objectweb.asm.MethodVisitor;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeLookup;
import org.apache.flink.table.types.DataType;

public final class ExtractionUtils {
    private static final Map<Class<?>, Class<?>> primitiveWrapperMap = new HashMap();

    public static ValidationException extractionError(String message, Object ... args) {
        return ExtractionUtils.extractionError(null, message, args);
    }

    public static ValidationException extractionError(Throwable cause, String message, Object ... args) {
        return new ValidationException(String.format(message, args), cause);
    }

    public static List<Type> collectTypeHierarchy(Type type) {
        Type currentType = type;
        Class<?> currentClass = ExtractionUtils.toClass(type);
        ArrayList<Type> typeHierarchy = new ArrayList<Type>();
        while (currentClass != null) {
            typeHierarchy.add(currentType);
            for (Type genericInterface : currentClass.getGenericInterfaces()) {
                Class<?> interfaceClass = ExtractionUtils.toClass(genericInterface);
                if (interfaceClass == null) continue;
                typeHierarchy.addAll(ExtractionUtils.collectTypeHierarchy(genericInterface));
            }
            currentType = currentClass.getGenericSuperclass();
            currentClass = ExtractionUtils.toClass(currentType);
        }
        return typeHierarchy;
    }

    @Nullable
    public static Class<?> toClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return null;
    }

    public static DataType createRawType(DataTypeLookup lookup, @Nullable Class<? extends TypeSerializer<?>> rawSerializer, @Nullable Class<?> conversionClass) {
        if (rawSerializer != null) {
            return DataTypes.RAW(ExtractionUtils.createConversionClass(conversionClass), ExtractionUtils.instantiateRawSerializer(rawSerializer));
        }
        return lookup.resolveRawDataType(ExtractionUtils.createConversionClass(conversionClass));
    }

    private static Class<?> createConversionClass(@Nullable Class<?> conversionClass) {
        if (conversionClass != null) {
            return conversionClass;
        }
        return Object.class;
    }

    private static TypeSerializer<?> instantiateRawSerializer(Class<? extends TypeSerializer<?>> rawSerializer) {
        try {
            return rawSerializer.newInstance();
        }
        catch (Exception e) {
            throw ExtractionUtils.extractionError(e, "Cannot instantiate type serializer '%s' for RAW type. Make sure the class is publicly accessible and has a default constructor.", rawSerializer.getName());
        }
    }

    public static Type resolveVariable(List<Type> typeHierarchy, TypeVariable<?> variable) {
        for (int i = typeHierarchy.size() - 1; i >= 0; --i) {
            Type currentType = typeHierarchy.get(i);
            if (!(currentType instanceof ParameterizedType)) continue;
            Type resolvedType = ExtractionUtils.resolveVariableInParameterizedType(variable, (ParameterizedType)currentType);
            if (resolvedType instanceof TypeVariable) {
                variable = (TypeVariable)resolvedType;
                continue;
            }
            if (resolvedType == null) continue;
            return resolvedType;
        }
        return variable;
    }

    @Nullable
    private static Type resolveVariableInParameterizedType(TypeVariable<?> variable, ParameterizedType currentType) {
        Class currentRaw = (Class)currentType.getRawType();
        TypeVariable<Class<T>>[] currentVariables = currentRaw.getTypeParameters();
        for (int paramPos = 0; paramPos < currentVariables.length; ++paramPos) {
            if (!ExtractionUtils.typeVariableEquals(variable, currentVariables[paramPos])) continue;
            return currentType.getActualTypeArguments()[paramPos];
        }
        return null;
    }

    private static boolean typeVariableEquals(TypeVariable<?> variable, TypeVariable<?> currentVariable) {
        return currentVariable.getGenericDeclaration().equals(variable.getGenericDeclaration()) && currentVariable.getName().equals(variable.getName());
    }

    public static void validateStructuredClass(Class<?> clazz) {
        int m = clazz.getModifiers();
        if (Modifier.isAbstract(m)) {
            throw ExtractionUtils.extractionError("Class '%s' must not be abstract.", clazz.getName());
        }
        if (!Modifier.isPublic(m)) {
            throw ExtractionUtils.extractionError("Class '%s' is not public.", clazz.getName());
        }
        if (!(clazz.getEnclosingClass() == null || clazz.getDeclaringClass() != null && Modifier.isStatic(m))) {
            throw ExtractionUtils.extractionError("Class '%s' is a not a static, globally accessible class.", clazz.getName());
        }
    }

    public static List<Field> collectStructuredFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != Object.class) {
            Field[] declaredFields = clazz.getDeclaredFields();
            Stream.of(declaredFields).filter(field -> {
                int m = field.getModifiers();
                return !Modifier.isStatic(m) && !Modifier.isTransient(m);
            }).forEach(fields::add);
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static void validateStructuredFieldReadability(Class<?> clazz, Field field) {
        int m = field.getModifiers();
        if (Modifier.isPublic(m)) {
            return;
        }
        if (!ExtractionUtils.hasStructuredFieldGetter(clazz, field)) {
            throw ExtractionUtils.extractionError("Field '%s' of class '%s' is neither publicly accessible nor does it have a corresponding getter method.", field.getName(), clazz.getName());
        }
    }

    public static boolean isStructuredFieldMutable(Class<?> clazz, Field field) {
        int m = field.getModifiers();
        if (Modifier.isFinal(m)) {
            return false;
        }
        if (Modifier.isPublic(m)) {
            return true;
        }
        if (ExtractionUtils.hasFieldSetter(clazz, field)) {
            return true;
        }
        throw ExtractionUtils.extractionError("Field '%s' of class '%s' is mutable but is neither publicly accessible nor does it have a corresponding setter method.", field.getName(), clazz.getName());
    }

    public static boolean hasFieldSetter(Class<?> clazz, Field field) {
        String normalizedFieldName = field.getName().toUpperCase();
        List<Method> methods = ExtractionUtils.collectStructuredMethods(clazz);
        for (Method method : methods) {
            boolean hasParameter;
            Class<?> returnType;
            boolean hasReturnType;
            String normalizedMethodName = method.getName().toUpperCase();
            boolean hasName = normalizedMethodName.equals("SET" + normalizedFieldName) || normalizedMethodName.equals(normalizedFieldName) || normalizedMethodName.equals(normalizedFieldName + "_$EQ");
            if (!hasName || !(hasReturnType = (returnType = method.getReturnType()) == Void.TYPE || returnType == clazz)) continue;
            boolean bl = hasParameter = method.getParameterCount() == 1 && (method.getGenericParameterTypes()[0].equals(field.getGenericType()) || ExtractionUtils.boxPrimitive(method.getGenericParameterTypes()[0]).equals(field.getGenericType()));
            if (!hasParameter) continue;
            return true;
        }
        return false;
    }

    public static Type boxPrimitive(Type type) {
        if (type instanceof Class && ((Class)type).isPrimitive()) {
            return primitiveWrapperMap.get(type);
        }
        return type;
    }

    public static boolean hasStructuredFieldGetter(Class<?> clazz, Field field) {
        String normalizedFieldName = field.getName().toUpperCase();
        List<Method> methods = ExtractionUtils.collectStructuredMethods(clazz);
        for (Method method : methods) {
            boolean hasNoParameters;
            Type returnType;
            boolean hasReturnType;
            String normalizedMethodName = method.getName().toUpperCase();
            boolean hasName = normalizedMethodName.equals("GET" + normalizedFieldName) || normalizedMethodName.equals("IS" + normalizedFieldName) || normalizedMethodName.equals(normalizedFieldName);
            if (!hasName || !(hasReturnType = (returnType = method.getGenericReturnType()).equals(field.getGenericType()))) continue;
            boolean bl = hasNoParameters = method.getParameterCount() == 0;
            if (!hasNoParameters) continue;
            return true;
        }
        return false;
    }

    public static List<Method> collectStructuredMethods(Class<?> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        while (clazz != Object.class) {
            Method[] declaredMethods = clazz.getDeclaredMethods();
            Stream.of(declaredMethods).filter(field -> {
                int m = field.getModifiers();
                return Modifier.isPublic(m) && !Modifier.isNative(m) && !Modifier.isAbstract(m);
            }).forEach(methods::add);
            clazz = clazz.getSuperclass();
        }
        return methods;
    }

    @Nullable
    public static AssigningConstructor extractAssigningConstructor(Class<?> clazz, List<Field> fields) {
        AssigningConstructor foundConstructor = null;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            List<String> parameterNames;
            boolean qualifyingConstructor;
            boolean bl = qualifyingConstructor = Modifier.isPublic(constructor.getModifiers()) && constructor.getParameterTypes().length == fields.size();
            if (!qualifyingConstructor || (parameterNames = ExtractionUtils.extractConstructorParameterNames(clazz, constructor, fields)) == null) continue;
            if (foundConstructor != null) {
                throw ExtractionUtils.extractionError("Multiple constructors found that assign all fields for class '%s'.", clazz.getName());
            }
            foundConstructor = new AssigningConstructor(constructor, parameterNames);
        }
        return foundConstructor;
    }

    @Nullable
    private static List<String> extractConstructorParameterNames(Class<?> clazz, Constructor<?> constructor, List<Field> fields) {
        Type[] parameterTypes = constructor.getGenericParameterTypes();
        List<String> parameterNames = Stream.of(constructor.getParameters()).map(Parameter::getName).collect(Collectors.toList());
        if (parameterNames.stream().allMatch(n -> n.startsWith("arg"))) {
            ParameterExtractor extractor = new ParameterExtractor(constructor);
            ExtractionUtils.getClassReader(clazz).accept((ClassVisitor)extractor, 0);
            List<String> extractedNames = extractor.getParameterNames();
            if (extractedNames.size() == 0 || !extractedNames.get(0).equals("this")) {
                return null;
            }
            parameterNames = extractedNames.subList(1, Math.min(fields.size() + 1, extractedNames.size()));
        }
        if (parameterNames.size() != fields.size()) {
            return null;
        }
        Map<String, Type> fieldMap = fields.stream().collect(Collectors.toMap(Field::getName, Field::getGenericType));
        for (int i = 0; i < parameterNames.size(); ++i) {
            String parameterName = parameterNames.get(i);
            Type fieldType = fieldMap.get(parameterName);
            Type parameterType = parameterTypes[i];
            if (ExtractionUtils.boxPrimitive(parameterType).equals(ExtractionUtils.boxPrimitive(fieldType))) continue;
            return null;
        }
        return parameterNames;
    }

    private static ClassReader getClassReader(Class<?> cls) {
        String className = cls.getName().replaceFirst("^.*\\.", "") + ".class";
        try {
            return new ClassReader(cls.getResourceAsStream(className));
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not instantiate ClassReader.", e);
        }
    }

    private ExtractionUtils() {
    }

    static {
        primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperMap.put(Character.TYPE, Character.class);
        primitiveWrapperMap.put(Short.TYPE, Short.class);
        primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperMap.put(Long.TYPE, Long.class);
        primitiveWrapperMap.put(Double.TYPE, Double.class);
        primitiveWrapperMap.put(Float.TYPE, Float.class);
    }

    private static class ParameterExtractor
    extends ClassVisitor {
        private final String constructorDescriptor;
        private final List<String> parameterNames = new ArrayList<String>();

        public ParameterExtractor(Constructor constructor) {
            super(458752);
            this.constructorDescriptor = org.apache.flink.shaded.asm7.org.objectweb.asm.Type.getConstructorDescriptor((Constructor)constructor);
        }

        public List<String> getParameterNames() {
            return this.parameterNames;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (descriptor.equals(this.constructorDescriptor)) {
                return new MethodVisitor(458752){

                    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
                        parameterNames.add(name);
                    }
                };
            }
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }
    }

    public static class AssigningConstructor {
        public final Constructor<?> constructor;
        public final List<String> parameterNames;

        private AssigningConstructor(Constructor<?> constructor, List<String> parameterNames) {
            this.constructor = constructor;
            this.parameterNames = parameterNames;
        }
    }
}

