/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.dataview;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.dataview.DataView;
import org.apache.flink.table.dataview.MapViewTypeInfoFactory;

@TypeInfo(value=MapViewTypeInfoFactory.class)
@PublicEvolving
public class MapView<K, V>
implements DataView {
    private static final long serialVersionUID = -6185595470714822744L;
    public transient TypeInformation<?> keyType;
    public transient TypeInformation<?> valueType;
    public final Map<K, V> map;

    public MapView(TypeInformation<?> keyType, TypeInformation<?> valueType, Map<K, V> map) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.map = map;
    }

    public MapView(TypeInformation<?> keyType, TypeInformation<?> valueType) {
        this(keyType, valueType, new HashMap());
    }

    public MapView() {
        this(null, null);
    }

    public V get(K key) throws Exception {
        return this.map.get(key);
    }

    public void put(K key, V value) throws Exception {
        this.map.put(key, value);
    }

    public void putAll(Map<K, V> map) throws Exception {
        this.map.putAll(map);
    }

    public void remove(K key) throws Exception {
        this.map.remove(key);
    }

    public boolean contains(K key) throws Exception {
        return this.map.containsKey(key);
    }

    public Iterable<Map.Entry<K, V>> entries() throws Exception {
        return this.map.entrySet();
    }

    public Iterable<K> keys() throws Exception {
        return this.map.keySet();
    }

    public Iterable<V> values() throws Exception {
        return this.map.values();
    }

    public Iterator<Map.Entry<K, V>> iterator() throws Exception {
        return this.map.entrySet().iterator();
    }

    public boolean isEmpty() throws Exception {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public boolean equals(Object other) {
        if (other instanceof MapView) {
            return this.map.equals(((MapView)other).map);
        }
        return false;
    }

    public int hashCode() {
        return this.map.hashCode();
    }
}

