/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.SqlFactory;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.PartitionQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class TableReferenceExpression
implements ResolvedExpression {
    private final String name;
    private final QueryOperation queryOperation;
    @Nullable
    private final TableEnvironment env;

    @Deprecated
    TableReferenceExpression(String name, QueryOperation queryOperation) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.queryOperation = (QueryOperation)Preconditions.checkNotNull((Object)queryOperation);
        this.env = null;
    }

    TableReferenceExpression(String name, QueryOperation queryOperation, TableEnvironment env) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.queryOperation = (QueryOperation)Preconditions.checkNotNull((Object)queryOperation);
        this.env = (TableEnvironment)Preconditions.checkNotNull((Object)env);
    }

    public String getName() {
        return this.name;
    }

    public QueryOperation getQueryOperation() {
        return this.queryOperation;
    }

    @Nullable
    public TableEnvironment getTableEnvironment() {
        return this.env;
    }

    public DataType getOutputDataType() {
        return DataTypeUtils.fromResolvedSchemaPreservingTimeAttributes((ResolvedSchema)this.queryOperation.getResolvedSchema());
    }

    public List<ResolvedExpression> getResolvedChildren() {
        return Collections.emptyList();
    }

    public String asSerializableString(SqlFactory sqlFactory) {
        if (this.queryOperation instanceof PartitionQueryOperation) {
            return OperationUtils.indent(this.queryOperation.asSerializableString(sqlFactory));
        }
        return String.format("(%s\n)", OperationUtils.indent(this.queryOperation.asSerializableString(sqlFactory)));
    }

    public String asSummaryString() {
        return this.name;
    }

    public List<Expression> getChildren() {
        return Collections.emptyList();
    }

    public <R> R accept(ExpressionVisitor<R> visitor) {
        return (R)visitor.visit((Expression)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableReferenceExpression that = (TableReferenceExpression)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.queryOperation, that.queryOperation) && Objects.equals(this.env, that.env);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.queryOperation, this.env);
    }

    public String toString() {
        return this.asSummaryString();
    }
}

